/*
 * Decompiled with CFR 0.152.
 */
package t4j.data;

import java.util.ArrayList;
import java.util.List;
import t4j.TBlogException;
import t4j.http.Response;
import t4j.org.json.JSONArray;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Venue {
    private String name;
    private String address;
    private String city;
    private String province;
    private String state;
    private double[] coordinates = new double[2];

    public double getLatitude() {
        return this.coordinates[0];
    }

    public double getLongitude() {
        return this.coordinates[1];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public Venue(JSONObject json) throws TBlogException {
        try {
            this.name = json.getString("name");
            this.address = json.getString("address");
            this.city = json.getString("city");
            this.province = json.getString("province");
            this.state = json.getString("state");
            JSONArray coordinates = json.getJSONArray("coordinates");
            this.coordinates[0] = coordinates.getDouble(0);
            this.coordinates[1] = coordinates.getDouble(1);
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
    }

    public static List<Venue> createVenueList(Response res) throws TBlogException {
        try {
            JSONArray jsonArray = res.asJSONArray();
            ArrayList<Venue> venues = new ArrayList<Venue>();
            int i = 0;
            while (i < jsonArray.length()) {
                venues.add(new Venue(jsonArray.getJSONObject(i)));
                ++i;
            }
            return venues;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
    }
}

