/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.utils.Debug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class PduOutputFormatter
extends FilterOutputStream {
    private int _packetSize;
    private byte[] _netBuf;
    private int _nextOut;
    private int _pduType;
    private int _pduStatus;
    private SybConnection _conn;

    public PduOutputFormatter(OutputStream outputStream, int n, SybConnection sybConnection) throws SQLException {
        super(outputStream);
        this.setNetBufSize(n);
        this._nextOut = 8;
        this._pduType = 15;
        this._pduStatus = 0;
        this._conn = sybConnection;
    }

    protected void changeOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    private void doFlush(boolean bl) throws IOException {
        try {
            try {
                this._netBuf[0] = (byte)this._pduType;
                int n = this._packetSize;
                if (bl) {
                    this._netBuf[1] = (byte)this._pduStatus;
                } else {
                    this._netBuf[1] = (byte)(this._pduStatus | 1);
                    n = this._nextOut;
                }
                this._netBuf[2] = (byte)((n & 0xFF00) >> 8);
                this._netBuf[3] = (byte)(n & 0xFF);
                this.out.write(this._netBuf, 0, n);
                if (!bl) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                this._conn.markDeadTryHA();
            }
            Object var3_3 = null;
            this._nextOut = 8;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this._nextOut = 8;
            throw throwable;
        }
    }

    public void flush() throws IOException {
        this.doFlush(false);
    }

    public void setNetBufSize(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < this._nextOut) {
            byArray[n2] = this._netBuf[n2];
            ++n2;
        }
        int n3 = this._nextOut;
        while (n3 < n) {
            byArray[n3] = 0;
            ++n3;
        }
        this._netBuf = byArray;
        this._packetSize = n;
    }

    public void setPDUHeader(int n, int n2) {
        this._pduType = n;
        this._pduStatus = n2;
    }

    public void write(int n) throws IOException {
        if (this._nextOut >= this._packetSize) {
            this.doFlush(true);
        }
        this._netBuf[this._nextOut++] = (byte)n;
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Debug.assert(this, n2 + n <= byArray.length, "Offset/Length values are incorrect");
        int n3 = n;
        while (n2 > 0) {
            int n4;
            if (this._nextOut >= this._packetSize) {
                this.doFlush(true);
            }
            int n5 = (n4 = this._packetSize - this._nextOut) < n2 - n ? n4 : n2 - n;
            System.arraycopy(byArray, n3, this._netBuf, this._nextOut, n5);
            this._nextOut += n5;
            n2 -= n5;
            n3 += n5;
        }
    }
}

