/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlSerializer;

public class SimpleXmlSerializer
extends XmlSerializer {
    public SimpleXmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected void serializeContentToken(ContentNode item, TagNode tagNode, Writer writer) throws IOException {
        String content = item.getContent();
        String trimmed = content.trim();
        boolean dontEscape = this.dontEscape(tagNode);
        if (trimmed.endsWith("/*]]>*/")) {
            int pos = content.lastIndexOf("/*]]>*/");
            String ending = content.substring(pos);
            if (dontEscape) {
                writer.write(content.substring(0, pos).replaceAll("]]>", "]]&gt;"));
            } else if (trimmed.startsWith("<![CDATA[")) {
                int actualStart = content.indexOf("<![CDATA[") + "<![CDATA[".length();
                writer.write(content.substring(0, actualStart));
                writer.write(this.escapeXml(content.substring(actualStart, pos)));
            } else {
                writer.write(this.escapeXml(content.substring(0, pos)));
            }
            writer.write(ending);
        } else if (dontEscape) {
            writer.write(content.replaceAll("]]>", "]]&gt;"));
        } else {
            writer.write(this.escapeXml(content));
        }
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        List tagChildren = tagNode.getAllChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            for (Object item : tagChildren) {
                if (item == null) continue;
                if (item instanceof ContentNode) {
                    this.serializeContentToken((ContentNode)item, tagNode, writer);
                    continue;
                }
                ((BaseToken)item).serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }
}

