/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSS;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class MSVSSGET
extends MSVSS {
    private String m_LocalPath = null;
    private boolean m_Recursive = false;
    private boolean m_Writable = false;
    private String m_Version = null;
    private String m_Date = null;
    private String m_Label = null;

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        int result = 0;
        if (this.getVsspath() == null) {
            String msg = "vsspath attribute must be set!";
            throw new BuildException(msg, this.location);
        }
        commandLine.setExecutable(this.getSSCommand());
        commandLine.createArgument().setValue("Get");
        commandLine.createArgument().setValue(this.getVsspath());
        this.getLocalpathCommand(commandLine);
        commandLine.createArgument().setValue("-I-");
        this.getRecursiveCommand(commandLine);
        this.getVersionCommand(commandLine);
        this.getWritableCommand(commandLine);
        this.getLoginCommand(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    public void getLocalpathCommand(Commandline cmd) {
        if (this.m_LocalPath == null) {
            return;
        }
        File dir = this.project.resolveFile(this.m_LocalPath);
        if (!dir.exists()) {
            boolean done = dir.mkdirs();
            if (!done) {
                String msg = "Directory " + this.m_LocalPath + " creation was not " + "succesful for an unknown reason";
                throw new BuildException(msg, this.location);
            }
            this.project.log("Created dir: " + dir.getAbsolutePath());
        }
        cmd.createArgument().setValue("-GL" + this.m_LocalPath);
    }

    public void getRecursiveCommand(Commandline cmd) {
        if (!this.m_Recursive) {
            return;
        }
        cmd.createArgument().setValue("-R");
    }

    public void getVersionCommand(Commandline cmd) {
        if (this.m_Version != null) {
            cmd.createArgument().setValue("-V" + this.m_Version);
        } else if (this.m_Date != null) {
            cmd.createArgument().setValue("-Vd" + this.m_Date);
        } else if (this.m_Label != null) {
            cmd.createArgument().setValue("-VL" + this.m_Label);
        }
    }

    public void getWritableCommand(Commandline cmd) {
        if (!this.m_Writable) {
            return;
        }
        cmd.createArgument().setValue("-W");
    }

    public void setDate(String date) {
        this.m_Date = date.equals("") || date.equals("null") ? null : date;
    }

    public void setLabel(String label) {
        this.m_Label = label.equals("") || label.equals("null") ? null : label;
    }

    public void setLocalpath(Path localPath) {
        this.m_LocalPath = localPath.toString();
    }

    public void setRecursive(boolean recursive) {
        this.m_Recursive = recursive;
    }

    public void setVersion(String version) {
        this.m_Version = version.equals("") || version.equals("null") ? null : version;
    }

    public final void setWritable(boolean argWritable) {
        this.m_Writable = argWritable;
    }
}

