/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslEngineByteBufferInputStream
extends InputStream {
    private final SSLEngine sslEngine;
    private final ByteBuffer plainIn;
    private final ByteBuffer cipherIn;
    private final ReadableByteChannel channel;

    public SslEngineByteBufferInputStream(SSLEngine sslEngine, ByteBuffer plainIn, ByteBuffer cipherIn, ReadableByteChannel channel) {
        this.sslEngine = sslEngine;
        this.plainIn = plainIn;
        this.cipherIn = cipherIn;
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        if (this.plainIn.hasRemaining()) {
            return this.readFromBuffer(this.plainIn);
        }
        this.plainIn.clear();
        SSLEngineResult result = this.sslEngine.unwrap(this.cipherIn, this.plainIn);
        switch (result.getStatus()) {
            case OK: {
                this.plainIn.flip();
                if (!this.plainIn.hasRemaining()) break;
                return this.readFromBuffer(this.plainIn);
            }
            case BUFFER_OVERFLOW: {
                throw new SSLException("buffer overflow in read");
            }
            case BUFFER_UNDERFLOW: {
                if (this.cipherIn.hasRemaining()) {
                    this.cipherIn.compact();
                } else {
                    this.cipherIn.clear();
                }
                int bytesRead = NioHelper.read(this.channel, this.cipherIn);
                if (bytesRead > 0) {
                    this.cipherIn.flip();
                } else {
                    bytesRead = NioHelper.retryRead(this.channel, this.cipherIn);
                    if (bytesRead <= 0) {
                        throw new IllegalStateException("Should be reading something from the network");
                    }
                }
                this.plainIn.clear();
                result = this.sslEngine.unwrap(this.cipherIn, this.plainIn);
                if (result.getStatus() != SSLEngineResult.Status.OK) {
                    throw new SSLException("Unexpected result: " + result);
                }
                this.plainIn.flip();
                if (!this.plainIn.hasRemaining()) break;
                return this.readFromBuffer(this.plainIn);
            }
            case CLOSED: {
                throw new SSLException("closed in read");
            }
            default: {
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
            }
        }
        return -1;
    }

    private int readFromBuffer(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }
}

