/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.OSSObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CreateFolderSample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static String bucketName = "*** Provide bucket name ***";

    public static void main(String[] args) throws IOException {
        OSSClient client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            try {
                String keySuffixWithSlash = "MyObjectKey/";
                client.putObject(bucketName, "MyObjectKey/", new ByteArrayInputStream(new byte[0]));
                System.out.println("Creating an empty folder MyObjectKey/\n");
                OSSObject object = client.getObject(bucketName, "MyObjectKey/");
                System.out.println("Size of the empty folder '" + object.getKey() + "' is " + object.getObjectMetadata().getContentLength());
                object.getObjectContent().close();
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                client.shutdown();
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                client.shutdown();
            }
        }
        finally {
            client.shutdown();
        }
    }
}

