/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.tags.HTMLTextareaTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLTextareaTagScanner
extends HTMLTagScanner {
    public HTMLTextareaTagScanner() {
    }

    public HTMLTextareaTagScanner(String pFilter) {
        super(pFilter);
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currLine) throws HTMLParserException {
        try {
            HTMLTextareaTag textareaTag;
            HTMLEndTag endTag = null;
            HTMLNode node = null;
            boolean endTagFound = false;
            StringBuffer value = new StringBuffer();
            HTMLNode prevNode = tag;
            do {
                if ((node = reader.readElement()) instanceof HTMLEndTag) {
                    endTag = (HTMLEndTag)node;
                    if (!endTag.getText().toUpperCase().equals("TEXTAREA")) continue;
                    endTagFound = true;
                    continue;
                }
                if (prevNode != null && prevNode.elementEnd() > node.elementBegin()) {
                    value.append(HTMLNode.getLineSeparator());
                }
                value.append(node.toHTML());
                prevNode = node;
            } while (!endTagFound);
            HTMLTextareaTag hTMLTextareaTag = textareaTag = new HTMLTextareaTag(0, node.elementEnd(), tag.getText(), value.toString(), currLine, tag.getLine());
            return hTMLTextareaTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLTextareaTagScanner.scan() : Error while scanning textarea tags, current line = ".concat(String.valueOf(String.valueOf(currLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"TEXTAREA"};
        return ids;
    }
}

