/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;

public class HTMLStringNode
extends HTMLNode {
    private static final int BEFORE_PARSE_BEGINS_STATE = 0;
    private static final int PARSE_HAS_BEGUN_STATE = 1;
    private static final int PARSE_COMPLETED_STATE = 2;
    public static final String STRING_FILTER = "-string";
    protected StringBuffer textBuffer;
    int nLine;

    public HTMLStringNode(StringBuffer textBuffer, int textBegin, int textEnd) {
        super(textBegin, textEnd);
        this.textBuffer = textBuffer;
    }

    public HTMLStringNode(StringBuffer textBuffer, int textBegin, int textEnd, int _nLine) {
        super(textBegin, textEnd);
        this.textBuffer = textBuffer;
        this.nLine = _nLine;
    }

    public static HTMLNode find(HTMLReader reader, String input, int position) {
        return HTMLStringNode.find(reader, input, position, reader.getLineCount() - 1);
    }

    public static HTMLNode find(HTMLReader reader, String input, int position, int _nLine) {
        StringBuffer textBuffer = new StringBuffer();
        int state = 0;
        int textBegin = position;
        int textEnd = position;
        int inputLen = input.length();
        for (int i = position; i < inputLen && state != 2; ++i) {
            char nextChar;
            char ch = input.charAt(i);
            if (ch == '<' && state == 0) {
                return null;
            }
            if (ch == '<' && i + 1 < input.length() && ((nextChar = input.charAt(i + 1)) >= 'A' && nextChar <= 'Z' || nextChar >= 'a' && nextChar <= 'z' || nextChar == '/' || nextChar == '!' || nextChar == '>' || nextChar == '%')) {
                state = 2;
                textEnd = i - 1;
            }
            if (state == 0) {
                if (ch != ' ') {
                    state = 1;
                } else {
                    textBuffer.append(input.charAt(i));
                }
            }
            if (state == 1) {
                textBuffer.append(input.charAt(i));
            }
            if (state == 0 && i == inputLen - 1) {
                state = 1;
            }
            if (state != 1 || i != inputLen - 1) continue;
            input = reader.getNextLine();
            if (input == null) {
                textEnd = i;
                state = 2;
                continue;
            }
            textBuffer.append(HTMLNode.lineSeparator);
            inputLen = input.length();
            i = -1;
        }
        return new HTMLStringNode(textBuffer, textBegin, textEnd, _nLine);
    }

    public int getLine() {
        return this.nLine;
    }

    public String getText() {
        return this.textBuffer.toString();
    }

    public String toPlainTextString() {
        return this.textBuffer.toString();
    }

    public String toHTML() {
        return this.textBuffer.toString();
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("Text = ").append(this.getText()).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd())));
    }

    public void collectInto(Vector collectionVector, String filter) {
        if (filter == STRING_FILTER) {
            collectionVector.add(this);
        }
    }

    static {
        BEFORE_PARSE_BEGINS_STATE = 0;
        PARSE_HAS_BEGUN_STATE = 1;
        PARSE_COMPLETED_STATE = 2;
        STRING_FILTER = STRING_FILTER;
    }
}

