/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLAppletScanner;
import org.htmlparser.scanners.HTMLDoctypeScanner;
import org.htmlparser.scanners.HTMLFormScanner;
import org.htmlparser.scanners.HTMLFrameSetScanner;
import org.htmlparser.scanners.HTMLJspScanner;
import org.htmlparser.scanners.HTMLLinkScanner;
import org.htmlparser.scanners.HTMLMetaTagScanner;
import org.htmlparser.scanners.HTMLScriptScanner;
import org.htmlparser.scanners.HTMLStyleScanner;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.scanners.HTMLTitleScanner;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.DefaultHTMLParserFeedback;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLLinkProcessor;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLParserFeedback;
import org.htmlparser.util.HTMLTagParser;

public class HTMLParser {
    protected String resourceLocn;
    protected HTMLReader reader;
    protected HTMLNode node;
    protected boolean readFlag = false;
    private Hashtable scanners = new Hashtable();
    private boolean connectionOpened = true;
    private HTMLParserFeedback feedback;
    public static final String VERSION_STRING = "1.2 (Production Release)";

    public HTMLParser(HTMLReader reader, HTMLParserFeedback feedback) {
        this.reader = reader;
        this.feedback = feedback == null ? new DefaultHTMLParserFeedback(0) : feedback;
        HTMLTag.setTagParser(new HTMLTagParser(feedback));
        reader.setParser(this);
        this.connectionOpened = false;
    }

    public HTMLParser(String resourceLocn, HTMLParserFeedback feedback) throws HTMLParserException {
        try {
            this.resourceLocn = resourceLocn;
            this.feedback = feedback == null ? new DefaultHTMLParserFeedback(0) : feedback;
            HTMLTag.setTagParser(new HTMLTagParser(feedback));
            this.openConnection();
        }
        catch (Exception e) {
            String msg = "Error in constructing the parser object for resource ".concat(String.valueOf(String.valueOf(resourceLocn)));
            HTMLParserException ex = new HTMLParserException(msg, e);
            feedback.error(msg, ex);
            throw ex;
        }
    }

    public HTMLParser(String resourceLocn) throws HTMLParserException {
        this(resourceLocn, (HTMLParserFeedback)new DefaultHTMLParserFeedback());
    }

    public HTMLParser(HTMLReader reader) {
        this(reader, (HTMLParserFeedback)new DefaultHTMLParserFeedback());
    }

    public void addScanner(HTMLTagScanner scanner) {
        String[] ids = scanner.getID();
        for (int i = 0; i < ids.length; ++i) {
            this.scanners.put(ids[i], scanner);
        }
        scanner.setFeedback(this.feedback);
    }

    private String checkEnding(String link) {
        int l1 = link.indexOf("html");
        int l2 = link.indexOf("htm");
        int l3 = link.indexOf("php");
        int l4 = link.indexOf("jsp");
        return link;
    }

    public HTMLEnumeration elements() {
        return new HTMLEnumeration(){

            public boolean hasMoreNodes() throws HTMLParserException {
                if (HTMLParser.this.reader == null) {
                    return false;
                }
                try {
                    HTMLParser.this.node = HTMLParser.this.reader.readElement();
                    HTMLParser.this.readFlag = true;
                    if (HTMLParser.this.node == null) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    StringBuffer msgBuffer = new StringBuffer();
                    msgBuffer.append("Unexpected Exception occurred in HTMLParser.hasMoreNodes()");
                    msgBuffer.append(HTMLParser.this.resourceLocn);
                    msgBuffer.append(", in nextHTMLNode");
                    HTMLParser.this.reader.appendLineDetails(msgBuffer);
                    HTMLParserException ex = new HTMLParserException(msgBuffer.toString(), e);
                    HTMLParser.this.feedback.error(msgBuffer.toString(), ex);
                    throw ex;
                }
            }

            public HTMLNode nextHTMLNode() throws HTMLParserException {
                try {
                    if (!HTMLParser.this.readFlag) {
                        HTMLParser.this.node = HTMLParser.this.reader.readElement();
                    }
                    HTMLNode hTMLNode = HTMLParser.this.node;
                    return hTMLNode;
                }
                catch (Exception e) {
                    StringBuffer msgBuffer = new StringBuffer();
                    msgBuffer.append("Unexpected Exception occurred while reading ");
                    msgBuffer.append(HTMLParser.this.resourceLocn);
                    msgBuffer.append(", in nextHTMLNode");
                    HTMLParser.this.reader.appendLineDetails(msgBuffer);
                    HTMLParserException ex = new HTMLParserException(msgBuffer.toString(), e);
                    HTMLParser.this.feedback.error(msgBuffer.toString(), ex);
                    throw ex;
                }
            }
        };
    }

    public void flushScanners() {
        this.scanners = new Hashtable();
    }

    public int getNumScanners() {
        return this.scanners.size();
    }

    public Hashtable getScanners() {
        return this.scanners;
    }

    public HTMLTagScanner getScanner(String id) {
        return (HTMLTagScanner)this.scanners.get(id);
    }

    public static void main(String[] args) {
        block8: {
            System.out.println("HTMLParser v1.2 (Production Release)");
            if (args.length < 1 || args[0].equals("-help")) {
                System.out.println();
                System.out.println("Syntax : java -jar htmlparser.jar <resourceLocn/website> -l");
                System.out.println("   <resourceLocn> the name of the file to be parsed (with complete path if not in current directory)");
                System.out.println("   -l Show only the link tags extracted from the document");
                System.out.println("   -i Show only the image tags extracted from the document");
                System.out.println("   -s Show only the Javascript code extracted from the document");
                System.out.println("   -t Show only the Style code extracted from the document");
                System.out.println("   -a Show only the Applet tag extracted from the document");
                System.out.println("   -j Parse JSP tags");
                System.out.println("   -m Parse Meta tags");
                System.out.println("   -T Extract the Title");
                System.out.println("   -f Extract forms");
                System.out.println("   -r Extract frameset");
                System.out.println("   -help This screen");
                System.out.println();
                System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
                System.out.println();
                System.out.println("Example : java -jar htmlparser.jar http://www.yahoo.com");
                System.out.println();
                System.out.println("If you have any doubts, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page instead of mailing any of the contributors directly. You will be surprised with the quality of open source support. ");
                System.exit(-1);
            }
            if (args[0].indexOf("http") != -1 || args[0].indexOf("www.") != -1) {
                System.out.println("Parsing website ".concat(String.valueOf(String.valueOf(args[0]))));
            } else {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parsing file ").append(args[0]).append("..."))));
            }
            try {
                HTMLParser parser = new HTMLParser(args[0], (HTMLParserFeedback)new DefaultHTMLParserFeedback());
                parser.registerScanners();
                try {
                    if (args.length == 2) {
                        parser.parse(args[1]);
                        break block8;
                    }
                    parser.parse(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (HTMLParserException e) {
                e.printStackTrace();
            }
        }
    }

    private void openConnection() throws HTMLParserException {
        try {
            this.reader = HTMLLinkProcessor.isURL(this.resourceLocn) ? this.openURLConnection() : this.openFileConnection();
            this.reader.setParser(this);
        }
        catch (Exception e) {
            String msg = "HTMLParser.openConnection() : Error in opening a connection to ".concat(String.valueOf(String.valueOf(this.resourceLocn)));
            HTMLParserException ex = new HTMLParserException(msg, e);
            this.feedback.error(msg, ex);
            throw ex;
        }
    }

    private HTMLReader openFileConnection() throws HTMLParserException {
        try {
            HTMLReader hTMLReader = new HTMLReader((Reader)new BufferedReader(new FileReader(this.resourceLocn)), this.resourceLocn);
            return hTMLReader;
        }
        catch (Exception e) {
            String msg = "HTMLParser.openFileConnection() : Error in opening a file connection to ".concat(String.valueOf(String.valueOf(this.resourceLocn)));
            HTMLParserException ex = new HTMLParserException(msg, e);
            this.feedback.error(msg, ex);
            throw ex;
        }
    }

    private HTMLReader openURLConnection() throws HTMLParserException {
        try {
            if (-1 != this.resourceLocn.indexOf("#38;")) {
                this.feedback.warning("URL contains escape - use org.htmlparser.util.Translate.decode()");
            }
            this.resourceLocn = this.checkEnding(this.resourceLocn);
            this.resourceLocn = HTMLLinkProcessor.fixSpaces(this.resourceLocn);
            URL url = new URL(this.resourceLocn);
            URLConnection uc = url.openConnection();
            HTMLReader hTMLReader = new HTMLReader((Reader)new BufferedReader(new InputStreamReader(uc.getInputStream(), "8859_1")), this.resourceLocn);
            return hTMLReader;
        }
        catch (Exception e) {
            String msg = "HTMLParser.openURLConnection() : Error in opening a URL connection to ".concat(String.valueOf(String.valueOf(this.resourceLocn)));
            HTMLParserException ex = new HTMLParserException(msg, e);
            this.feedback.error(msg, ex);
            throw ex;
        }
    }

    public void parse(String filter) throws Exception {
        HTMLEnumeration e = this.elements();
        while (e.hasMoreNodes()) {
            HTMLNode node = e.nextHTMLNode();
            if (node != null) {
                String tagFilter;
                HTMLTag tag;
                HTMLTagScanner scanner;
                if (filter == null) {
                    node.print();
                    continue;
                }
                if (!(node instanceof HTMLTag) || (scanner = (tag = (HTMLTag)node).getThisScanner()) == null || (tagFilter = scanner.getFilter()) == null || !tagFilter.equals(filter)) continue;
                node.print();
                continue;
            }
            System.out.println("Node is null");
        }
    }

    public void registerScanners() {
        if (this.scanners.size() > 0) {
            System.err.println("registerScanners() should be called first, when no other scanner has been registered.");
            System.err.println("Other scanners already exist, hence this method call wont have any effect");
            return;
        }
        HTMLLinkScanner linkScanner = new HTMLLinkScanner("-l");
        this.addScanner(linkScanner);
        this.addScanner(linkScanner.createImageScanner("-i"));
        this.addScanner(new HTMLScriptScanner("-s"));
        this.addScanner(new HTMLStyleScanner("-t"));
        this.addScanner(new HTMLJspScanner("-j"));
        this.addScanner(new HTMLAppletScanner("-a"));
        this.addScanner(new HTMLMetaTagScanner("-m"));
        this.addScanner(new HTMLTitleScanner("-T"));
        this.addScanner(new HTMLDoctypeScanner("-d"));
        this.addScanner(new HTMLFormScanner("-f"));
        this.addScanner(new HTMLFrameSetScanner("-r"));
        this.addScanner(linkScanner.createBaseHREFScanner("-b"));
    }

    public void removeScanner(HTMLTagScanner scanner) {
        this.scanners.remove(scanner);
    }

    public void setScanners(Hashtable newScanners) {
        this.scanners = newScanners;
    }

    public static void setLineSeparator(String lineSeparator) {
        HTMLNode.setLineSeparator(lineSeparator);
    }

    public HTMLParserFeedback getFeedback() {
        return this.feedback;
    }

    public HTMLReader getReader() {
        return this.reader;
    }

    static {
        VERSION_STRING = VERSION_STRING;
    }
}

