/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.factories;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.ColumnMap;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.RelatedClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmldbms.maps.factories.XMLNameChecker;
import org.xmlmiddleware.xmldbms.maps.utils.MapInverter;
import org.xmlmiddleware.xmlutils.XMLName;

public class MapFactory_Database {
    private Connection[] connections;
    private String prefix;
    private String uri;
    private String[] databaseNames;
    private boolean useElementTypes = true;
    private boolean followPrimaryKeys = true;
    private boolean followForeignKeys = true;
    private XMLDBMSMap map;
    private Hashtable processedTables = new Hashtable();
    private Hashtable conns = new Hashtable();
    private Hashtable metas = new Hashtable();
    private XMLNameChecker checker = new XMLNameChecker();
    private static final Object o = new Object();
    private static final Hashtable emptyHashtable = new Hashtable();
    private static final String DEFAULT = "Default";
    private static final String PERIOD = ".";
    private static final String CONNECTIONS = "connections";
    private static final String DATABASENAME = "database name";
    private static final String CATALOGNAME = "catalog name";
    private static final String SCHEMANAME = "schema name";
    private static final String TABLENAME = "table name";
    private static final String ARRAY = "s array";
    private static final String STOP = "Stop ";
    private static final String ROOT = "root ";

    public MapFactory_Database() {
    }

    public MapFactory_Database(Connection connection) {
        this.setConnection(connection);
    }

    public MapFactory_Database(String[] stringArray, Connection[] connectionArray) {
        this.databaseNames = stringArray;
        this.connections = connectionArray;
    }

    public void setNamespaceInfo(String string, String string2) {
        if (string == null && string2 != null) {
            throw new IllegalArgumentException("The namespace prefix must be null if the namespace URI is null.");
        }
        this.uri = string;
        this.prefix = string2;
    }

    public final boolean areColumnsElementTypes() {
        return this.useElementTypes;
    }

    public void columnsAreElementTypes(boolean bl) {
        this.useElementTypes = bl;
    }

    public void setConnection(Connection connection) {
        this.connections = new Connection[1];
        this.connections[0] = connection;
        this.databaseNames = new String[1];
        this.databaseNames[0] = DEFAULT;
    }

    public void setConnections(String[] stringArray, Connection[] connectionArray) {
        this.databaseNames = stringArray;
        this.connections = connectionArray;
    }

    public boolean followPrimaryKeys() {
        return this.followPrimaryKeys;
    }

    public void followPrimaryKeys(boolean bl) {
        this.followPrimaryKeys = bl;
    }

    public boolean followForeignKeys() {
        return this.followForeignKeys;
    }

    public void followForeignKeys(boolean bl) {
        this.followForeignKeys = bl;
    }

    public XMLDBMSMap createMap(String string, String string2, String string3) throws SQLException, XMLMiddlewareException {
        this.checkNull(string3, "root table name");
        this.initGlobalVariables();
        this.processTable(DEFAULT, string, string2, string3, emptyHashtable);
        this.invertMap();
        return this.map;
    }

    public XMLDBMSMap createMap(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws SQLException, XMLMiddlewareException {
        this.checkArray(stringArray4, 0, true, null, TABLENAME);
        this.checkArray(stringArray, stringArray4.length, false, DEFAULT, "root database name");
        this.checkArray(stringArray2, stringArray4.length, false, null, CATALOGNAME);
        this.checkArray(stringArray3, stringArray4.length, false, null, SCHEMANAME);
        this.initGlobalVariables();
        this.processTables(stringArray, stringArray2, stringArray3, stringArray4, emptyHashtable);
        this.invertMap();
        return this.map;
    }

    public XMLDBMSMap createMap(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String[] stringArray8) throws SQLException, XMLMiddlewareException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.checkArray(stringArray4, 0, true, null, "root table name");
        this.checkArray(stringArray, stringArray4.length, false, DEFAULT, "root database name");
        this.checkArray(stringArray2, stringArray4.length, false, null, "root catalog name");
        this.checkArray(stringArray3, stringArray4.length, false, null, "root schema name");
        this.checkArray(stringArray8, 0, true, null, "Stop table name");
        this.checkArray(stringArray5, stringArray8.length, false, DEFAULT, "Stop database name");
        this.checkArray(stringArray6, stringArray8.length, false, null, "Stop catalog name");
        this.checkArray(stringArray7, stringArray8.length, false, null, "Stop schema name");
        this.initGlobalVariables();
        int n = 0;
        while (n < stringArray8.length) {
            String string = Table.getHashName(stringArray5[n], stringArray6[n], stringArray7[n], stringArray8[n]);
            hashtable.put(string, o);
            ++n;
        }
        this.processTables(stringArray, stringArray2, stringArray3, stringArray4, hashtable);
        this.invertMap();
        return this.map;
    }

    public XMLDBMSMap createMap(String[] stringArray, String[] stringArray2) throws SQLException, XMLMiddlewareException {
        this.checkArray(stringArray2, 0, true, null, "root catalog name");
        this.checkArray(stringArray, stringArray2.length, false, DEFAULT, "root database name");
        this.initGlobalVariables();
        this.processCatalogs(stringArray, stringArray2);
        this.invertMap();
        return this.map;
    }

    public XMLDBMSMap createMap(String[] stringArray, String[] stringArray2, String[] stringArray3) throws SQLException, XMLMiddlewareException {
        this.checkArray(stringArray3, 0, true, null, "root schema name");
        this.checkArray(stringArray, stringArray3.length, false, DEFAULT, "root database name");
        this.checkArray(stringArray2, stringArray3.length, false, null, "root catalog name");
        this.initGlobalVariables();
        this.processSchemas(stringArray, stringArray2, stringArray3);
        this.invertMap();
        return this.map;
    }

    private void processCatalogs(String[] stringArray, String[] stringArray2) throws SQLException, XMLMiddlewareException {
        int n = 0;
        while (n < stringArray.length) {
            this.processCatalogOrSchema(stringArray[n], stringArray2[n], null);
            ++n;
        }
    }

    private void processSchemas(String[] stringArray, String[] stringArray2, String[] stringArray3) throws SQLException, XMLMiddlewareException {
        int n = 0;
        while (n < stringArray.length) {
            this.processCatalogOrSchema(stringArray[n], stringArray2[n], stringArray3[n]);
            ++n;
        }
    }

    private void processTables(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Hashtable hashtable) throws SQLException, XMLMiddlewareException {
        int n = 0;
        while (n < stringArray.length) {
            this.processTable(stringArray[n], stringArray2[n], stringArray3[n], stringArray4[n], hashtable);
            ++n;
        }
    }

    private void processCatalogOrSchema(String string, String string2, String string3) throws SQLException, XMLMiddlewareException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        DatabaseMetaData databaseMetaData = this.getDatabaseMetaData(string);
        string3 = this.escapeDBName(databaseMetaData, string3);
        ResultSet resultSet = databaseMetaData.getTables(string2, string3, null, null);
        while (resultSet.next()) {
            vector.addElement(resultSet.getString(1));
            vector2.addElement(resultSet.getString(2));
            vector3.addElement(resultSet.getString(3));
        }
        resultSet.close();
        int n = 0;
        while (n < vector2.size()) {
            this.processTable(string, (String)vector.elementAt(n), (String)vector2.elementAt(n), (String)vector3.elementAt(n), emptyHashtable);
            ++n;
        }
    }

    private void processTable(String string, String string2, String string3, String string4, Hashtable hashtable) throws SQLException, XMLMiddlewareException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Table table = this.map.createTable(string, string2, string3, string4);
        if (this.processedTables.get(table) != null) {
            return;
        }
        this.processedTables.put(table, o);
        ClassTableMap classTableMap = this.map.createClassTableMap(table);
        DatabaseMetaData databaseMetaData = this.getDatabaseMetaData(string);
        string3 = this.escapeDBName(databaseMetaData, string3);
        this.getPrimaryKey(databaseMetaData, table, string2, string3, string4);
        if (classTableMap.getElementTypeName() == null) {
            classTableMap.setElementTypeName(this.getElementTypeName(table));
        }
        if (this.followForeignKeys) {
            this.getForeignKeys(databaseMetaData, string, string2, string3, string4, vector, vector2, false, hashtable);
        }
        this.processColumns(databaseMetaData, classTableMap, table, string, string2, string3, string4);
        this.setResultSetIndexes(table);
        if (this.followPrimaryKeys) {
            this.getForeignKeys(databaseMetaData, string, string2, string3, string4, vector, vector2, true, hashtable);
        }
        this.linkRemoteTables(classTableMap, vector, vector2);
        this.processRemoteTables(vector, hashtable);
    }

    private void processColumns(DatabaseMetaData databaseMetaData, ClassTableMap classTableMap, Table table, String string, String string2, String string3, String string4) throws SQLException, XMLMiddlewareException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Enumeration enumeration = table.getForeignKeys();
        while (enumeration.hasMoreElements()) {
            Key key = (Key)enumeration.nextElement();
            Column[] columnArray = key.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                hashtable.put(columnArray[n].getName(), o);
                ++n;
            }
        }
        ResultSet resultSet = databaseMetaData.getColumns(string2, string3, this.escapeDBName(databaseMetaData, string4), null);
        while (resultSet.next()) {
            String string5 = resultSet.getString(4);
            Column column = table.createColumn(string5);
            int n = JDBCTypes.convertDateTimeType(resultSet.getShort(5));
            column.setType(n);
            int n2 = resultSet.getInt(7);
            if (JDBCTypes.typeIsChar(n) || JDBCTypes.typeIsBinary(n)) {
                column.setLength(n2);
            }
            column.setNullability(resultSet.getInt(11));
            column.setFormatter(this.map.getDefaultFormatter(n));
            if (hashtable.get(string5) != null) continue;
            this.createColumnMap(classTableMap, table, column);
        }
        resultSet.close();
    }

    private void setResultSetIndexes(Table table) {
        Enumeration enumeration = table.getColumns();
        int n = 1;
        while (n <= table.getNumberOfColumns()) {
            Column column = (Column)enumeration.nextElement();
            column.setResultSetIndex(n);
            ++n;
        }
    }

    private void createColumnMap(ClassTableMap classTableMap, Table table, Column column) throws XMLMiddlewareException {
        ColumnMap columnMap = classTableMap.createColumnMap(column);
        int n = this.useElementTypes ? 1 : 2;
        XMLName xMLName = n == 1 ? this.getElementTypeName(table, column) : this.getAttributeName(table, column, classTableMap.getElementTypeName());
        columnMap.setXMLName(xMLName, n);
    }

    private void linkRemoteTables(ClassTableMap classTableMap, Vector vector, Vector vector2) throws SQLException, XMLMiddlewareException {
        int n = 0;
        while (n < vector.size()) {
            LinkInfo linkInfo = (LinkInfo)vector2.elementAt(n);
            Table table = (Table)vector.elementAt(n);
            ClassTableMap classTableMap2 = this.map.createClassTableMap(table);
            if (!this.linkExists(classTableMap.getTable(), linkInfo, classTableMap2)) {
                RelatedClassTableMap relatedClassTableMap = RelatedClassTableMap.create(classTableMap2);
                classTableMap.addRelatedClassTableMap(relatedClassTableMap);
                relatedClassTableMap.setLinkInfo(linkInfo);
                XMLName xMLName = classTableMap2.getElementTypeName();
                if (xMLName == null) {
                    xMLName = this.getElementTypeName(table);
                    classTableMap2.setElementTypeName(xMLName);
                }
                relatedClassTableMap.setElementTypeName(xMLName);
            }
            ++n;
        }
    }

    private boolean linkExists(Table table, LinkInfo linkInfo, ClassTableMap classTableMap) {
        Enumeration enumeration = classTableMap.getRelatedClassTableMap(table.getDatabaseName(), table.getCatalogName(), table.getSchemaName(), table.getTableName());
        while (enumeration.hasMoreElements()) {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)enumeration.nextElement();
            LinkInfo linkInfo2 = relatedClassTableMap.getLinkInfo();
            if (!linkInfo2.getParentKey().equals(linkInfo.getChildKey()) || !linkInfo2.getChildKey().equals(linkInfo.getParentKey())) continue;
            return true;
        }
        return false;
    }

    private void processRemoteTables(Vector vector, Hashtable hashtable) throws SQLException, XMLMiddlewareException {
        int n = 0;
        while (n < vector.size()) {
            Table table = (Table)vector.elementAt(n);
            this.processTable(table.getDatabaseName(), table.getCatalogName(), table.getSchemaName(), table.getTableName(), hashtable);
            ++n;
        }
    }

    private void getPrimaryKey(DatabaseMetaData databaseMetaData, Table table, String string, String string2, String string3) throws SQLException {
        String string4;
        Key key = null;
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
        while (resultSet.next()) {
            string4 = resultSet.getString(4);
            short s = resultSet.getShort(5);
            vector.addElement(string4);
            vector2.addElement(new Integer(s));
            if (s != 1) continue;
            String string5 = resultSet.getString(6);
            if (resultSet.wasNull()) {
                string5 = null;
            }
            key = table.createPrimaryKey(string5);
        }
        resultSet.close();
        if (key != null) {
            Column[] columnArray = new Column[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                int n2 = (Integer)vector2.elementAt(n);
                string4 = (String)vector.elementAt(n);
                columnArray[n2 - 1] = table.createColumn(string4);
                ++n;
            }
            key.setColumns(columnArray);
        }
    }

    private void getForeignKeys(DatabaseMetaData databaseMetaData, String string, String string2, String string3, String string4, Vector vector, Vector vector2, boolean bl, Hashtable hashtable) throws SQLException {
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Key key = null;
        Key key2 = null;
        Table table = null;
        Table table2 = null;
        ResultSet resultSet = bl ? databaseMetaData.getExportedKeys(string2, string3, string4) : databaseMetaData.getImportedKeys(string2, string3, string4);
        while (resultSet.next()) {
            String string5 = resultSet.getString(1);
            if (resultSet.wasNull()) {
                string5 = null;
            }
            String string6 = resultSet.getString(2);
            if (resultSet.wasNull()) {
                string6 = null;
            }
            String string7 = resultSet.getString(3);
            String string8 = resultSet.getString(4);
            String string9 = resultSet.getString(5);
            if (resultSet.wasNull()) {
                string9 = null;
            }
            String string10 = resultSet.getString(6);
            if (resultSet.wasNull()) {
                string10 = null;
            }
            String string11 = resultSet.getString(7);
            String string12 = resultSet.getString(8);
            String string13 = bl ? Table.getHashName(string, string9, string10, string11) : Table.getHashName(string, string5, string6, string7);
            if (hashtable.get(string13) != null) continue;
            short s = resultSet.getShort(9);
            String string14 = resultSet.getString(12);
            if (resultSet.wasNull()) {
                string14 = null;
            }
            String string15 = resultSet.getString(13);
            if (resultSet.wasNull()) {
                string15 = null;
            }
            if (s == 1) {
                LinkInfo linkInfo;
                if (key2 != null) {
                    this.setKeyColumnArray(table2, vector4, key2);
                    this.setKeyColumnArray(table, vector3, key);
                }
                table = this.map.createTable(string, string5, string6, string7);
                key = table.createPrimaryKey(string15);
                table2 = this.map.createTable(string, string9, string10, string11);
                key2 = table2.createForeignKey(string14);
                key2.setRemoteKey(table, key);
                if (bl) {
                    vector.addElement(table2);
                    linkInfo = LinkInfo.create(key, key2);
                } else {
                    vector.addElement(table);
                    linkInfo = LinkInfo.create(key2, key);
                }
                vector2.addElement(linkInfo);
                vector4.removeAllElements();
                vector3.removeAllElements();
            }
            vector4.addElement(string12);
            vector3.addElement(string8);
        }
        resultSet.close();
        if (key2 != null) {
            this.setKeyColumnArray(table2, vector4, key2);
            this.setKeyColumnArray(table, vector3, key);
        }
    }

    private void setKeyColumnArray(Table table, Vector vector, Key key) {
        Column[] columnArray = new Column[vector.size()];
        int n = 0;
        while (n < columnArray.length) {
            Column column;
            columnArray[n] = column = table.createColumn((String)vector.elementAt(n));
            ++n;
        }
        key.setColumns(columnArray);
    }

    private DatabaseMetaData getDatabaseMetaData(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)this.metas.get(string);
        if (databaseMetaData == null) {
            Connection connection = (Connection)this.conns.get(string);
            databaseMetaData = connection.getMetaData();
            this.metas.put(string, databaseMetaData);
        }
        return databaseMetaData;
    }

    private void invertMap() throws XMLMiddlewareException {
        MapInverter mapInverter = new MapInverter();
        mapInverter.createXMLView(this.map);
    }

    private String escapeDBName(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            return null;
        }
        String string2 = databaseMetaData.getSearchStringEscape();
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '%': 
                case '_': {
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private XMLName getElementTypeName(Table table, Column column) throws XMLMiddlewareException {
        String[] stringArray = new String[]{table.getTableName(), table.getSchemaName(), table.getCatalogName(), table.getDatabaseName()};
        return this.checker.checkElementTypeName(stringArray, this.uri, column.getName(), this.prefix);
    }

    private XMLName getElementTypeName(Table table) throws XMLMiddlewareException {
        String[] stringArray = new String[]{table.getSchemaName(), table.getCatalogName(), table.getDatabaseName()};
        return this.checker.checkElementTypeName(stringArray, this.uri, table.getTableName(), this.prefix);
    }

    private XMLName getAttributeName(Table table, Column column, XMLName xMLName) throws XMLMiddlewareException {
        String[] stringArray = new String[]{table.getTableName(), table.getSchemaName(), table.getCatalogName(), table.getDatabaseName()};
        return this.checker.checkAttributeName(stringArray, xMLName, null, column.getName(), null);
    }

    private void initGlobalVariables() {
        this.checkState();
        this.setDefault(this.databaseNames, DEFAULT);
        this.map = new XMLDBMSMap();
        this.processedTables.clear();
        this.metas.clear();
        this.buildHashtable(this.conns, this.databaseNames, this.connections);
        this.checker.startNewSession();
    }

    private void checkState() {
        if (this.connections == null) {
            throw new IllegalStateException("You must set at least one connection.");
        }
        if (this.connections.length == 0) {
            throw new IllegalStateException("You must set at least one connection.");
        }
        if (this.databaseNames == null) {
            throw new IllegalStateException("You must set at least one database name.");
        }
        if (this.connections.length != this.databaseNames.length) {
            throw new IllegalStateException("The number of connections and database names must be the same.");
        }
        this.checkNullEntries(this.connections, CONNECTIONS);
    }

    private void buildHashtable(Hashtable hashtable, Object[] objectArray, Object[] objectArray2) {
        hashtable.clear();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray2[n] != null) {
                hashtable.put(objectArray[n], objectArray2[n]);
            }
            ++n;
        }
    }

    private void checkArray(Object[] objectArray, int n, boolean bl, Object object, String string) {
        string = String.valueOf(string) + ARRAY;
        this.checkNull(objectArray, string);
        if (n != 0) {
            this.checkLength(objectArray, n, string);
        }
        if (bl) {
            this.checkNullEntries(objectArray, string);
        }
        if (object != null) {
            this.setDefault(objectArray, object);
        }
    }

    private void checkNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " must not be null.");
        }
    }

    private void checkNull(Object[] objectArray, String string) {
        if (objectArray == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " must not be null.");
        }
    }

    private void checkLength(Object[] objectArray, int n, String string) {
        if (objectArray.length != n) {
            throw new IllegalArgumentException(String.valueOf(string) + " must have a length of " + String.valueOf(n));
        }
    }

    private void checkNullEntries(Object[] objectArray, String string) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new IllegalStateException("All " + string + " must be non-null.");
            }
            ++n;
        }
    }

    private void setDefault(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray[n] = object;
            }
            ++n;
        }
    }
}

