/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.exception.IdMException;
import com.trs.idm.model.sync.ConnectionInfo;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JMSUtil {
    private static final Logger logger = Logger.getLogger(JMSUtil.class);

    public static Destination getDestination(String factory, String className, String url, String desName) throws IdMException {
        Destination destination = null;
        try {
            Properties pro = new Properties();
            pro.setProperty("java.naming.factory.initial", className);
            pro.setProperty("java.naming.provider.url", url);
            InitialContext initCtx = new InitialContext(pro);
            destination = (Destination)initCtx.lookup(desName);
        }
        catch (NamingException e) {
            logger.error((Object)("failed to find connectionFactory by factoryName [" + factory + "]."), (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)("failed to find destination by desName [" + desName + "]."), t);
        }
        return destination;
    }

    public static Connection getJNDIConnection(String factory, String className, String url) throws IdMException {
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        try {
            Properties pro = new Properties();
            pro.setProperty("java.naming.factory.initial", className);
            pro.setProperty("java.naming.provider.url", url);
            InitialContext initCtx = new InitialContext(pro);
            connectionFactory = (ConnectionFactory)initCtx.lookup(factory);
        }
        catch (NamingException e) {
            throw new IdMException("failed to find connectionFactory by factoryName [" + factory + "].", e);
        }
        try {
            connection = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw new IdMException("cannot create connection by factoryName [" + factory + "].", e);
        }
        return connection;
    }

    public static Connection getJNDIConnection(ConnectionInfo connections) throws IdMException {
        if (connections == null) {
            throw new IdMException("Connections info is null ,throw an exception .");
        }
        String factory = (String)connections.get((Object)"jmsFactory");
        String className = connections.getConfiguration("jmsClassName");
        String url = connections.getConfiguration("jmsUrl");
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        try {
            Properties pro = new Properties();
            pro.setProperty("java.naming.factory.initial", className);
            pro.setProperty("java.naming.provider.url", url);
            InitialContext initCtx = new InitialContext(pro);
            connectionFactory = (ConnectionFactory)initCtx.lookup(factory);
        }
        catch (NamingException e) {
            throw new IdMException("failed to find connectionFactory by factoryName [" + connections + "].", e);
        }
        try {
            connection = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw new IdMException("cannot create connection by factoryName [" + connections + "].", e);
        }
        return connection;
    }

    public static void releaseConnection(Connection connection, Session session) {
        try {
            if (connection != null) {
                connection.stop();
                connection.close();
                connection = null;
            }
            if (session != null) {
                session.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

