/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.http;

import com.trs.idm.http.PureClient;
import com.trs.idm.http.Response;
import com.trs.idm.util.Base64Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.log4j.Logger;

public class IDSWrapper {
    private static final Logger LOG = Logger.getLogger(IDSWrapper.class);

    public static Response httpGet(String url, String cookieName, String cookieValue, String idsCmd, String clientIP) {
        URL urlAccess;
        try {
            urlAccess = new URL(url);
        }
        catch (MalformedURLException e) {
            return new Response(url, e);
        }
        String hostOrDomain = urlAccess.getHost();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("url=" + url + ", [cookie]Name=" + cookieName + ", value=" + cookieValue + ", idsCmd=" + idsCmd));
        }
        HttpState initialState = new HttpState();
        initialState.addCookie(new Cookie(hostOrDomain, cookieName, cookieValue, "/", null, false));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("user-agent", "TRS Identity Server");
        headers.put("encoding", System.getProperty("file.encoding"));
        if (clientIP != null) {
            headers.put("clientip-idsknown", clientIP);
        }
        return PureClient.getHttpResponse(url, headers, initialState);
    }

    public static Response httpPost(String url, String cookieName, String cookieValue, String idsCmd, String clientIP, NameValuePair[] pairs) {
        URL urlAccess;
        try {
            urlAccess = new URL(url);
        }
        catch (MalformedURLException e) {
            return new Response(url, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("url=" + url + ", " + cookieName + "=" + cookieValue + ", idsCmd=" + idsCmd));
        }
        String hostOrDomain = urlAccess.getHost();
        HttpState initialState = new HttpState();
        initialState.addCookie(new Cookie(hostOrDomain, cookieName, cookieValue, "/", null, false));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("user-agent", "TRS Identity Server");
        if (clientIP != null) {
            headers.put("clientip-idsknown", clientIP);
        }
        return PureClient.postHttpRequest(url, headers, initialState, pairs);
    }

    public static Response postNotifyAppLogin(String url, String cookieName, String cookieValue, String ssoSessionId, String clientIP, NameValuePair[] pairs) {
        URL urlAccess;
        try {
            urlAccess = new URL(url);
        }
        catch (MalformedURLException e) {
            return new Response(url, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("url=" + url + ", " + cookieName + "=" + cookieValue + ", ssoSessionId=" + ssoSessionId));
        }
        String hostOrDomain = urlAccess.getHost();
        HttpState initialState = new HttpState();
        initialState.addCookie(new Cookie(hostOrDomain, cookieName, cookieValue, "/", null, false));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", "login");
        headers.put("ssoSessionId", ssoSessionId);
        headers.put("user-agent", "TRS Identity Server");
        if (clientIP != null) {
            headers.put("clientip-idsknown", clientIP);
        }
        return PureClient.postHttpRequest(url, headers, initialState, pairs);
    }

    public static Response httpPost(String url, String idsCmd) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("user-agent", "TRS Identity Server");
        return PureClient.postHttpRequest(url, headers, null, null);
    }

    public static Response HttpPost(String url, String idsCmd, Map postParam) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("user-agent", "TRS Identity Server");
        NameValuePair[] parametersBody = null;
        if (postParam != null) {
            int size = postParam.size();
            parametersBody = new NameValuePair[size];
            int i = 0;
            for (String name : postParam.keySet()) {
                NameValuePair valuePair;
                String value = (String)postParam.get(name);
                parametersBody[i] = valuePair = new NameValuePair();
                parametersBody[i].setName(name);
                parametersBody[i].setValue(value);
                ++i;
            }
        }
        return PureClient.postHttpRequest(url, headers, null, parametersBody);
    }

    public static Response httpGet(String url, String idsCmd) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("user-agent", "TRS Identity Server");
        headers.put("encoding", System.getProperty("file.encoding"));
        return PureClient.getHttpResponse(url, headers, null);
    }

    public static Response httpGet(String url, String idsCmd, String userName, String groupName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("userName", Base64Util.encode(userName));
        headers.put("user-agent", "TRS Identity Server");
        headers.put("encoding", System.getProperty("file.encoding"));
        headers.put("groupName", Base64Util.encode(groupName));
        return PureClient.getHttpResponse(url, headers, null);
    }

    public static Response httpGetSyncUser(String url, String idsCmd, String userName, String groupName, String sourceName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("userName", Base64Util.encode(userName));
        headers.put("user-agent", "TRS Identity Server");
        headers.put("encoding", System.getProperty("file.encoding"));
        headers.put("groupName", Base64Util.encode(groupName));
        headers.put("sourceName", Base64Util.encode(sourceName));
        return PureClient.getHttpResponse(url, headers, null);
    }

    public static Response httpGetSyncGroup(String url, String idsCmd, String groupName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("groupName", Base64Util.encode(groupName));
        headers.put("user-agent", "TRS Identity Server");
        headers.put("encoding", System.getProperty("file.encoding"));
        return PureClient.getHttpResponse(url, headers, null);
    }

    public static Response httpGetSyncGroup(String url, String idsCmd, String groupName, String sourceName, String groupDN) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("groupName", Base64Util.encode(groupName));
        headers.put("user-agent", "TRS Identity Server");
        headers.put("encoding", System.getProperty("file.encoding"));
        headers.put("sourceName", Base64Util.encode(sourceName));
        headers.put("groupDN", Base64Util.encode(groupDN));
        LOG.debug((Object)("httpGetSyncGroup set headers: " + headers + ", sourceName: " + sourceName + ", groupDN: " + groupDN));
        return PureClient.getHttpResponse(url, headers, null);
    }

    public static Response httpNotifyToUpdateSSOURL(String url, String ssoUrl) {
        LOG.info((Object)("to Notify" + url + " Update SSOURL: " + ssoUrl));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", "updSSOUrl");
        headers.put("user-agent", "TRS Identity Server");
        headers.put("newSSOUrl", ssoUrl);
        return PureClient.getHttpResponse(url, headers, null);
    }

    public static Response httpPost(HttpClient httpClient, String url, String idsCmd, HttpState httpState) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("trs-ids-cmd", idsCmd);
        headers.put("user-agent", "TRS Identity Server");
        return PureClient.postHttpRequest(httpClient, url, headers, httpState, null);
    }
}

