/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

public class EnvConst {
    public static final String LIBRARY_PATH_LINUX = "LD_LIBRARY_PATH";
    public static final String PATH = "PATH";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String ENCODING = System.getProperty("file.encoding");
    public static final String OS_FAMILY_UNKNOWN = "unknown";
    public static final String OS_FAMILY_LINUX = "linux";
    public static final String OS_FAMILY_MAC = "mac";
    public static final String OS_FAMILY_WINDOWS = "windows";

    public static boolean isWindows() {
        return EnvConst.getOSNameInUpperCase().indexOf("WINDOWS") >= 0;
    }

    public static boolean isLinux() {
        return EnvConst.getOSNameInUpperCase().indexOf("LINUX") >= 0;
    }

    public static boolean isMac() {
        return EnvConst.getOSNameInUpperCase().indexOf("MAC") >= 0;
    }

    public static String getOSNameInUpperCase() {
        if (OS_NAME == null) {
            return "UNKNOWN!";
        }
        return OS_NAME.toUpperCase();
    }

    public static String getOSFamilyName() {
        if (EnvConst.isWindows()) {
            return OS_FAMILY_WINDOWS;
        }
        if (EnvConst.isLinux()) {
            return OS_FAMILY_LINUX;
        }
        if (EnvConst.isMac()) {
            return OS_FAMILY_MAC;
        }
        return OS_FAMILY_UNKNOWN;
    }

    public static String getProcessUser() {
        return System.getProperty("user.name");
    }
}

