/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model.impl;

import com.trs.dev4.jdk16.model.IConfigurable;
import com.trs.dev4.jdk16.model.IConfigurationManager;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ConfigurationBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger logger = Logger.getLogger(ConfigurationBeanPostProcessor.class);
    @Resource(name="configurationManager")
    private IConfigurationManager configurationManager;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (IConfigurable.class.isAssignableFrom(bean.getClass())) {
            logger.debug((Object)("Found IConfigurable(" + bean + ") with beanName(" + beanName + ")."));
            this.configurationManager.registerConfigurable((IConfigurable)bean);
        }
        return bean;
    }
}

