/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DateSerializer
implements Serializer,
Deserializer {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static /* synthetic */ Class class$java$util$Date;

    public DateSerializer() {
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        if (!javaType.equals(class$java$util$Date == null ? (class$java$util$Date = DateSerializer.class$("java.util.Date")) : class$java$util$Date)) {
            throw new IllegalArgumentException("Can only serialize java.util.Date instances");
        }
        nsStack.pushScope();
        if (src != null) {
            SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx);
            String fdate = null;
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                fdate = this.sdf.format((Date)src);
            }
            sink.write(fdate);
            sink.write("</" + context + '>');
        } else {
            SoapEncUtils.generateNullStructure(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx);
        }
        nsStack.popScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Date date = null;
        Element root = (Element)src;
        String value = DOMUtils.getChildCharacterData(root);
        if (value != null && !(value = value.trim()).equals("")) {
            try {
                SimpleDateFormat simpleDateFormat = this.sdf;
                synchronized (simpleDateFormat) {
                    date = this.sdf.parse(value);
                }
            }
            catch (ParseException pe) {
                try {
                    if (value.length() < 19) {
                        throw new ParseException("", 0);
                    }
                    if (value.charAt(4) != '-' || value.charAt(7) != '-' || value.charAt(10) != 'T') {
                        throw new ParseException("", 0);
                    }
                    if (value.charAt(13) != ':' || value.charAt(16) != ':') {
                        throw new ParseException("", 0);
                    }
                    try {
                        SimpleDateFormat simpleDateFormat = this.sdf;
                        synchronized (simpleDateFormat) {
                            date = this.sdf.parse(value.substring(0, 19) + ".000Z");
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("", 0);
                    }
                    int pos = 19;
                    if (pos < value.length() && value.charAt(pos) == '.') {
                        int milliseconds = 0;
                        int start = ++pos;
                        while (pos < value.length() && Character.isDigit(value.charAt(pos))) {
                            ++pos;
                        }
                        String decimal = value.substring(start, pos);
                        if (decimal.length() == 3) {
                            milliseconds = Integer.parseInt(decimal);
                        } else if (decimal.length() < 3) {
                            milliseconds = Integer.parseInt((decimal + "000").substring(0, 3));
                        } else {
                            milliseconds = Integer.parseInt(decimal.substring(0, 3));
                            if (decimal.charAt(3) >= '5') {
                                ++milliseconds;
                            }
                        }
                        date.setTime(date.getTime() + (long)milliseconds);
                    }
                    if (pos + 5 < value.length() && (value.charAt(pos) == '+' || value.charAt(pos) == '-')) {
                        if (!(Character.isDigit(value.charAt(pos + 1)) && Character.isDigit(value.charAt(pos + 2)) && value.charAt(pos + 3) == ':' && Character.isDigit(value.charAt(pos + 4)) && Character.isDigit(value.charAt(pos + 5)))) {
                            throw new ParseException("", 0);
                        }
                        int hours = (value.charAt(pos + 1) - 48) * 10 + value.charAt(pos + 2) - 48;
                        int mins = (value.charAt(pos + 4) - 48) * 10 + value.charAt(pos + 5) - 48;
                        int milliseconds = (hours * 60 + mins) * 60 * 1000;
                        if (value.charAt(pos) == '+') {
                            milliseconds = -milliseconds;
                        }
                        date.setTime(date.getTime() + (long)milliseconds);
                        pos += 6;
                    }
                    if (pos < value.length() && value.charAt(pos) == 'Z') {
                        ++pos;
                    }
                    if (pos < value.length()) {
                        throw new ParseException("", 0);
                    }
                }
                catch (ParseException pe2) {
                    SimpleDateFormat simpleDateFormat = this.sdf;
                    synchronized (simpleDateFormat) {
                        throw new IllegalArgumentException("String represents no valid Date for this Deserializer; try " + this.sdf.toPattern() + ".");
                    }
                }
            }
        }
        return new Bean(class$java$util$Date == null ? (class$java$util$Date = DateSerializer.class$("java.util.Date")) : class$java$util$Date, date);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

