/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.HeadObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import org.junit.Test;

public class DoesObjectExistTest
extends TestBase {
    @Test
    public void testExistingBucketAndObject() {
        boolean exist;
        ArrayList<String> existingKeys = new ArrayList<String>();
        String existingKey = "existing-bucket-and-key";
        existingKeys.add("existing-bucket-and-key");
        if (!TestUtils.batchPutObject(secondClient, bucketName, existingKeys)) {
            Assert.fail((String)"batch put object failed");
        }
        try {
            exist = secondClient.doesObjectExist(bucketName, "existing-bucket-and-key");
            Assert.assertTrue((boolean)exist);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            exist = secondClient.doesObjectExist(new HeadObjectRequest(bucketName, "existing-bucket-and-key"));
            Assert.assertTrue((boolean)exist);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExistingBucketAndNonExistentObject() {
        String nonexistentKey = "existing-bucket-and-nonexistent-key";
        try {
            boolean exist = secondClient.doesObjectExist(bucketName, "existing-bucket-and-nonexistent-key");
            Assert.assertFalse((boolean)exist);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNonExistentBucketAndObject() {
        String nonexistentBucketName = "nonexistent-bucket";
        String nonexistentKey = "nonexistent-bucket-and-key";
        try {
            boolean exist = secondClient.doesObjectExist("nonexistent-bucket", "nonexistent-bucket-and-key");
            Assert.assertFalse((boolean)exist);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testObjectWithMiscConstraints() throws Exception {
        Date modifiedSinceConstraint;
        HeadObjectRequest headObjectRequest;
        block48: {
            Date beforeModifiedTime;
            block46: {
                Date unmodifiedSinceConstraint;
                block44: {
                    block42: {
                        ArrayList<String> nonmatchingETagConstraints;
                        String eTag;
                        block40: {
                            block38: {
                                ArrayList<String> matchingETagConstraints;
                                block36: {
                                    beforeModifiedTime = new Date();
                                    Thread.sleep(3000L);
                                    String existingKey = "object-with-misc-constraints";
                                    eTag = null;
                                    try {
                                        PutObjectResult result = secondClient.putObject(bucketName, "object-with-misc-constraints", TestUtils.genFixedLengthInputStream(1024L), null);
                                        eTag = result.getETag();
                                    }
                                    catch (Exception e) {
                                        Assert.fail((String)e.getMessage());
                                    }
                                    headObjectRequest = new HeadObjectRequest(bucketName, "object-with-misc-constraints");
                                    matchingETagConstraints = new ArrayList<String>();
                                    matchingETagConstraints.add(eTag);
                                    headObjectRequest.setMatchingETagConstraints(matchingETagConstraints);
                                    try {
                                        try {
                                            boolean exist = secondClient.doesObjectExist(headObjectRequest);
                                            Assert.assertTrue((boolean)exist);
                                        }
                                        catch (Exception e) {
                                            Assert.fail((String)e.getMessage());
                                            headObjectRequest.setMatchingETagConstraints(null);
                                            break block36;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        headObjectRequest.setMatchingETagConstraints(null);
                                        throw throwable;
                                    }
                                    headObjectRequest.setMatchingETagConstraints(null);
                                }
                                matchingETagConstraints.clear();
                                matchingETagConstraints.add("nonmatching-etag");
                                headObjectRequest.setMatchingETagConstraints(matchingETagConstraints);
                                try {
                                    try {
                                        secondClient.doesObjectExist(headObjectRequest);
                                        Assert.fail((String)"Check object exist should not be successful.");
                                    }
                                    catch (OSSException e) {
                                        Assert.assertEquals((String)"PreconditionFailed", (String)e.getErrorCode());
                                        Assert.assertTrue((boolean)e.getMessage().startsWith("Precondition Failed"));
                                        headObjectRequest.setMatchingETagConstraints(null);
                                        break block38;
                                    }
                                }
                                catch (Throwable throwable) {
                                    headObjectRequest.setMatchingETagConstraints(null);
                                    throw throwable;
                                }
                                headObjectRequest.setMatchingETagConstraints(null);
                            }
                            nonmatchingETagConstraints = new ArrayList<String>();
                            nonmatchingETagConstraints.add("nonmatching-etag");
                            headObjectRequest.setNonmatchingETagConstraints(nonmatchingETagConstraints);
                            try {
                                try {
                                    boolean exist = secondClient.doesObjectExist(headObjectRequest);
                                    Assert.assertTrue((boolean)exist);
                                }
                                catch (OSSException e) {
                                    Assert.fail((String)e.getMessage());
                                    headObjectRequest.setNonmatchingETagConstraints(null);
                                    break block40;
                                }
                            }
                            catch (Throwable throwable) {
                                headObjectRequest.setNonmatchingETagConstraints(null);
                                throw throwable;
                            }
                            headObjectRequest.setNonmatchingETagConstraints(null);
                        }
                        nonmatchingETagConstraints.clear();
                        nonmatchingETagConstraints.add(eTag);
                        headObjectRequest.setNonmatchingETagConstraints(nonmatchingETagConstraints);
                        try {
                            try {
                                secondClient.doesObjectExist(headObjectRequest);
                                Assert.fail((String)"Check object exist should not be successful.");
                            }
                            catch (OSSException e) {
                                Assert.assertEquals((String)"NotModified", (String)e.getErrorCode());
                                Assert.assertTrue((boolean)e.getMessage().startsWith("Not Modified"));
                                headObjectRequest.setNonmatchingETagConstraints(null);
                                break block42;
                            }
                        }
                        catch (Throwable throwable) {
                            headObjectRequest.setNonmatchingETagConstraints(null);
                            throw throwable;
                        }
                        headObjectRequest.setNonmatchingETagConstraints(null);
                    }
                    unmodifiedSinceConstraint = new Date();
                    headObjectRequest.setUnmodifiedSinceConstraint(unmodifiedSinceConstraint);
                    try {
                        try {
                            boolean exist = secondClient.doesObjectExist(headObjectRequest);
                            Assert.assertTrue((boolean)exist);
                        }
                        catch (OSSException e) {
                            Assert.fail((String)e.getMessage());
                            headObjectRequest.setUnmodifiedSinceConstraint(null);
                            break block44;
                        }
                    }
                    catch (Throwable throwable) {
                        headObjectRequest.setUnmodifiedSinceConstraint(null);
                        throw throwable;
                    }
                    headObjectRequest.setUnmodifiedSinceConstraint(null);
                }
                unmodifiedSinceConstraint = beforeModifiedTime;
                headObjectRequest.setUnmodifiedSinceConstraint(unmodifiedSinceConstraint);
                try {
                    try {
                        secondClient.doesObjectExist(headObjectRequest);
                        Assert.fail((String)"Check object exist should not be successful.");
                    }
                    catch (OSSException e) {
                        Assert.assertEquals((String)"PreconditionFailed", (String)e.getErrorCode());
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Precondition Failed"));
                        headObjectRequest.setUnmodifiedSinceConstraint(null);
                        break block46;
                    }
                }
                catch (Throwable throwable) {
                    headObjectRequest.setUnmodifiedSinceConstraint(null);
                    throw throwable;
                }
                headObjectRequest.setUnmodifiedSinceConstraint(null);
            }
            modifiedSinceConstraint = beforeModifiedTime;
            headObjectRequest.setModifiedSinceConstraint(modifiedSinceConstraint);
            try {
                try {
                    boolean exist = secondClient.doesObjectExist(headObjectRequest);
                    Assert.assertTrue((boolean)exist);
                }
                catch (OSSException e) {
                    Assert.fail((String)e.getMessage());
                    headObjectRequest.setModifiedSinceConstraint(null);
                    break block48;
                }
            }
            catch (Throwable throwable) {
                headObjectRequest.setModifiedSinceConstraint(null);
                throw throwable;
            }
            headObjectRequest.setModifiedSinceConstraint(null);
        }
        modifiedSinceConstraint = new Date();
        headObjectRequest.setModifiedSinceConstraint(modifiedSinceConstraint);
        try {
            try {
                secondClient.doesObjectExist(headObjectRequest);
                Assert.fail((String)"Check object exist should not be successful.");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NotModified", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("Not Modified"));
                headObjectRequest.setModifiedSinceConstraint(null);
            }
        }
        finally {
            headObjectRequest.setModifiedSinceConstraint(null);
        }
    }
}

