/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public class UploadPartCopySample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static OSSClient client = null;
    private static String sourceBucketName = "*** Provide source bucket name ***";
    private static String sourceKey = "*** Provide source key ***";
    private static String targetBucketName = "*** Provide target bucket name ***";
    private static String targetKey = "*** Provide target key ***";
    private static String localFilePath = "*** Provide local file path ***";

    public static void main(String[] args) throws IOException {
        client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            try {
                System.out.println("Uploading a new object to OSS from a file\n");
                client.putObject(new PutObjectRequest(sourceBucketName, sourceKey, UploadPartCopySample.createSampleFile()));
                InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(targetBucketName, targetKey);
                InitiateMultipartUploadResult initiateMultipartUploadResult = client.initiateMultipartUpload(initiateMultipartUploadRequest);
                String uploadId = initiateMultipartUploadResult.getUploadId();
                long partSize = 0x500000L;
                ObjectMetadata metadata = client.getObjectMetadata(sourceBucketName, sourceKey);
                long objectSize = metadata.getContentLength();
                int partCount = (int)(objectSize / 0x500000L);
                if (objectSize % 0x500000L != 0L) {
                    ++partCount;
                }
                if (partCount > 10000) {
                    throw new RuntimeException("Total parts count should not exceed 10000");
                }
                System.out.println("Total parts count " + partCount + "\n");
                System.out.println("Begin to upload multiparts by copy mode to OSS\n");
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                int i = 0;
                while (i < partCount) {
                    long startPos = (long)i * 0x500000L;
                    long curPartSize = i + 1 == partCount ? objectSize - startPos : 0x500000L;
                    UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest(sourceBucketName, sourceKey, targetBucketName, targetKey);
                    uploadPartCopyRequest.setUploadId(uploadId);
                    uploadPartCopyRequest.setPartSize(curPartSize);
                    uploadPartCopyRequest.setBeginIndex(startPos);
                    uploadPartCopyRequest.setPartNumber(i + 1);
                    UploadPartCopyResult uploadPartCopyResult = client.uploadPartCopy(uploadPartCopyRequest);
                    System.out.println("\tPart#" + uploadPartCopyResult.getPartNumber() + " done\n");
                    partETags.add(uploadPartCopyResult.getPartETag());
                    ++i;
                }
                System.out.println("Completing to upload multiparts\n");
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(targetBucketName, targetKey, uploadId, partETags);
                client.completeMultipartUpload(completeMultipartUploadRequest);
                System.out.println("Fetching an object");
                client.getObject(new GetObjectRequest(targetBucketName, targetKey), new File(localFilePath));
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                client.shutdown();
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                client.shutdown();
            }
        }
        finally {
            client.shutdown();
        }
    }

    private static File createSampleFile() throws IOException {
        File file = File.createTempFile("oss-java-sdk-", ".txt");
        file.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
        int i = 0;
        while (i < 1000000) {
            writer.write("abcdefghijklmnopqrstuvwxyz\n");
            writer.write("0123456789011234567890\n");
            ++i;
        }
        ((Writer)writer).close();
        return file;
    }
}

