/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.adapter;

import java.util.ArrayList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.adapter.AdvisorAdapter;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.AfterReturningAdviceAdapter;
import org.springframework.aop.framework.adapter.BeforeAdviceAdapter;
import org.springframework.aop.framework.adapter.ThrowsAdviceAdapter;
import org.springframework.aop.framework.adapter.UnknownAdviceTypeException;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class DefaultAdvisorAdapterRegistry
implements AdvisorAdapterRegistry {
    private final List adapters = new ArrayList();

    public DefaultAdvisorAdapterRegistry() {
        this.registerAdvisorAdapter(new BeforeAdviceAdapter());
        this.registerAdvisorAdapter(new AfterReturningAdviceAdapter());
        this.registerAdvisorAdapter(new ThrowsAdviceAdapter());
    }

    public Advisor wrap(Object adviceObject) throws UnknownAdviceTypeException {
        if (adviceObject instanceof Advisor) {
            return (Advisor)adviceObject;
        }
        if (!(adviceObject instanceof Advice)) {
            throw new UnknownAdviceTypeException(adviceObject);
        }
        Advice advice = (Advice)adviceObject;
        if (advice instanceof Interceptor) {
            return new DefaultPointcutAdvisor(advice);
        }
        for (int i = 0; i < this.adapters.size(); ++i) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i);
            if (!adapter.supportsAdvice(advice)) continue;
            return new DefaultPointcutAdvisor(advice);
        }
        throw new UnknownAdviceTypeException(advice);
    }

    public Interceptor getInterceptor(Advisor advisor) throws UnknownAdviceTypeException {
        Advice advice = advisor.getAdvice();
        if (advice instanceof Interceptor) {
            return (Interceptor)advice;
        }
        for (int i = 0; i < this.adapters.size(); ++i) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i);
            if (!adapter.supportsAdvice(advice)) continue;
            return adapter.getInterceptor(advisor);
        }
        throw new UnknownAdviceTypeException(advisor.getAdvice());
    }

    public void registerAdvisorAdapter(AdvisorAdapter adapter) {
        this.adapters.add(adapter);
    }
}

