/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.ImageInfo;
import com.trs.wcm.photo.Watermark;
import org.apache.log4j.Logger;

public class AutoImageLibUtil {
    private static Logger s_logger = Logger.getLogger(AutoImageLibUtil.class);
    private static IImageLibConfig m_conf;
    private static IImageLibMgr m_manager;

    private AutoImageLibUtil() {
        m_conf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        m_manager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
    }

    public static void saveImage(String _fn, User _user) {
        block2: {
            try {
                InstanceHolder.INSTANCE.save0(_fn, _user);
            }
            catch (Exception e) {
                if (!s_logger.isDebugEnabled()) break block2;
                s_logger.error((Object)"Debug auto save fail:\n", (Throwable)e);
            }
        }
    }

    private void save0(String _fn, User _user) throws Exception {
        if (!m_conf.isAutoEnable()) {
            return;
        }
        String fn = _fn;
        User user = _user;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setImageKindId(m_conf.getRelatedKindId());
        imageInfo.setOtherImageKinedId(m_conf.getOtherRelatedKindIds());
        imageInfo.setImageFileName(fn);
        imageInfo.setSrcFileName(fn);
        int nMarkId = m_conf.getRelatedWaterMarkId();
        Watermark mark = Watermark.findById(nMarkId);
        if (mark != null) {
            imageInfo.setAddMark(true);
            imageInfo.setMarkImageFile(mark.getWMPicture());
            imageInfo.setMarkPos(m_conf.getRelatedWaterMarkPos());
        } else {
            imageInfo.setAddMark(false);
        }
        imageInfo.setConvertToImageType(m_conf.getDefaultConvertImageFileExt());
        ContextHelper.initContext(user);
        imageInfo = m_manager.saveImageInfo(imageInfo);
        imageInfo = null;
    }

    private static class InstanceHolder {
        static AutoImageLibUtil INSTANCE = new AutoImageLibUtil();

        private InstanceHolder() {
        }
    }
}

