/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util;

import com.trs.infra.persistent.db.ConnectPasswordEncrypter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import com.trs.util.DB2SQLProcessor4Ant;
import com.trs.util.DMSQLProcessor4Ant;
import com.trs.util.KingBaseSQLProcessor4Ant;
import com.trs.util.MysqlSQLProcessor4Ant;
import com.trs.util.OracleSQLProcessor4Ant;
import com.trs.util.SQLServerSQLProcessor4Ant;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecSQLFileByAnt {
    private static Logger logger = Logger.getLogger(ExecSQLFileByAnt.class);
    public static final String DB2_SQL_FILE = "db2.sql";
    public static final String MYSQL_SQL_FILE = "mysql.sql";
    public static final String ORACLE_SQL_FILE = "oracle.sql";
    public static final String SQLSERVER_SQL_FILE = "sqlserver.sql";
    public static final String SYBASE_SQL_FILE = "sybase.sql";
    public static final String DM_SQL_FILE = "dm.sql";
    public static final String KINGBASE_SQL_FILE = "kingbase.sql";
    public static final String OSCAR_SQL_FILE = "oscar.sql";
    private static final int SUCCESS = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execSQLFile(String _sSQLFilePath, String _sOutputFile, String _sDBAntBuildFile, String _antPath, String _sLogConFlag) throws Exception {
        CodeSource cs;
        if (CMyString.isEmpty(_sSQLFilePath)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CMyFile.fileExists(_sSQLFilePath)) {
            throw new Exception("\u6307\u5b9a\u7684SQL\u6587\u4ef6\u6240\u5728\u7684\u8def\u5f84\u4e0d\u5b58\u5728\uff01[" + _sSQLFilePath + "]");
        }
        if (!CMyFile.fileExists(_sDBAntBuildFile)) {
            throw new Exception("\u6267\u884c\u6570\u636e\u5e93\u7684ant\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[" + _sDBAntBuildFile + "]");
        }
        DBConnectionConfig dbConfig = DBManager.getDBManager().getDBConnConfig();
        DBType oDBType = dbConfig.getDBType();
        String sDriver = oDBType.getDriverClass();
        int nDBType = oDBType.getType();
        String sUser = dbConfig.getConnectionUser();
        String sPassword = dbConfig.getConnectionPassword();
        String sUrl = dbConfig.getConnectionURL();
        String sSQLPath = _sSQLFilePath;
        String sSQLFile = CMyString.setStrEndWith(sSQLPath, File.separatorChar);
        String sDelimiter = "!";
        DB2SQLProcessor4Ant oSQLProcessor = null;
        switch (nDBType) {
            case 3: 
            case 5: 
            case 6: {
                sSQLFile = sSQLFile + DB2_SQL_FILE;
                oSQLProcessor = new DB2SQLProcessor4Ant();
                break;
            }
            case 7: {
                sSQLFile = sSQLFile + MYSQL_SQL_FILE;
                oSQLProcessor = new MysqlSQLProcessor4Ant();
                sUrl = sUrl.substring(0, sUrl.indexOf("?"));
                sUrl = sUrl + "?characterEncoding=utf-8";
                break;
            }
            case 1: {
                sSQLFile = sSQLFile + ORACLE_SQL_FILE;
                oSQLProcessor = new OracleSQLProcessor4Ant();
                break;
            }
            case 2: {
                sSQLFile = sSQLFile + SQLSERVER_SQL_FILE;
                sDelimiter = ";";
                oSQLProcessor = new SQLServerSQLProcessor4Ant();
                break;
            }
            case 4: {
                sSQLFile = sSQLFile + SYBASE_SQL_FILE;
                sDelimiter = ";";
                oSQLProcessor = new SQLServerSQLProcessor4Ant();
                break;
            }
            case 9: {
                sSQLFile = sSQLFile + KINGBASE_SQL_FILE;
                oSQLProcessor = new KingBaseSQLProcessor4Ant();
                break;
            }
            case 8: {
                sSQLFile = sSQLFile + DM_SQL_FILE;
                oSQLProcessor = new DMSQLProcessor4Ant();
                break;
            }
            case 11: {
                sSQLFile = sSQLFile + OSCAR_SQL_FILE;
                oSQLProcessor = new OracleSQLProcessor4Ant();
                break;
            }
            default: {
                sSQLFile = sSQLFile + oDBType.getName().toLowerCase() + ".sql";
                oSQLProcessor = new MysqlSQLProcessor4Ant();
                sUrl = sUrl.substring(0, sUrl.indexOf("?"));
                sUrl = sUrl + "?characterEncoding=utf-8";
            }
        }
        FileService oSQLFile = new FileService(sSQLFile);
        if (nDBType >= 8 && !oSQLFile.exists()) {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("\u6570\u636e\u5e93\u7c7b\u578b[" + nDBType + "]\u5bf9\u5e94\u7684SQL\u6587\u4ef6[" + sSQLFile + "]\u4e0d\u5b58\u5728\uff0c\u76f4\u63a5\u8fd4\u56de"));
            return;
        }
        if (oSQLFile.isDirectory()) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u8981\u6267\u884c\u7684SQL\u6587\u4ef6");
        }
        if (oSQLProcessor == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684SQL\u811a\u672c\u5904\u7406\u7c7b");
        }
        String sNewFile = CMyFile.excludeFileExt(sSQLFile) + "_new.sql";
        CMyFile.copyFile(sSQLFile, sNewFile);
        oSQLProcessor.process((File)new FileWrapper(new FileService(sNewFile)));
        String sClassPath = "";
        ProtectionDomain pd = Class.forName(sDriver).getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            sClassPath = cs.toString();
            if (logger.isDebugEnabled()) {
                logger.info((Object)("========ant\u6267\u884c\u811a\u672c\u7684\u539fclasspath:=====" + sClassPath));
            }
            sClassPath = sClassPath.substring(sClassPath.indexOf("/"), sClassPath.indexOf(".jar") + 4);
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("========ant\u6267\u884c\u811a\u672c\u7684classpath:=====" + sClassPath));
        }
        HashMap<String, String> sqlExeParam = new HashMap<String, String>();
        sqlExeParam.put("DBDRIVER", sDriver);
        sqlExeParam.put("DBURL", sUrl);
        sqlExeParam.put("DBUSER", sUser);
        sqlExeParam.put("DBPWD", ConnectPasswordEncrypter.deEncrypt(sPassword));
        sqlExeParam.put("DBSRC", sNewFile);
        sqlExeParam.put("DBENCODING", "utf-8");
        sqlExeParam.put("DBDELIMITER", sDelimiter);
        sqlExeParam.put("DBAUTOCOMMIT", "true");
        sqlExeParam.put("DBKEEPFORMAT", "true");
        sqlExeParam.put("DBONERROR", "continue");
        sqlExeParam.put("DRIVERCLASSPATH", sClassPath);
        String sTrueBuildXMLPath = this.makeTrueBuildFile(_sDBAntBuildFile, sqlExeParam);
        String sTempLogFile = _sOutputFile + "_temp";
        String[] cmd = new String[]{_antPath, "-f", sTrueBuildXMLPath, "-logfile", sTempLogFile};
        try {
            logger.debug((Object)("\u5f00\u59cb\u6267\u884cant\u811a\u672c" + Calendar.getInstance().getTime().toString()));
            ExecSQLFileByAnt.exec(cmd, null);
            logger.debug((Object)("\u7ed3\u675fant\u811a\u672c\u7684\u6267\u884c" + Calendar.getInstance().getTime().toString()));
            return;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        finally {
            try {
                this.analysisAntExeLog(sTempLogFile, _sOutputFile);
            }
            catch (Exception ex) {
                throw new Exception(ex.getMessage(), ex);
            }
            finally {
                try {
                    CMyFile.deleteFile(sTrueBuildXMLPath);
                    StringBuffer logBuffer = new StringBuffer();
                    if (CMyFile.fileExists(_sOutputFile)) {
                        logBuffer.append(CMyFile.readFile(_sOutputFile));
                    }
                    logBuffer.append("\n============" + _sLogConFlag + "\u66f4\u65b0\u7ed3\u679c============\n");
                    logBuffer.append(CMyFile.readFile(sTempLogFile));
                    CMyFile.writeFile(_sOutputFile, logBuffer.toString());
                    CMyFile.deleteFile(sTempLogFile);
                }
                catch (Exception ex) {
                    logger.error((Object)"\u5904\u7406ant\u66f4\u65b0\u6570\u636e\u5e93\u811a\u672c\u7684\u65e5\u5fd7\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
                }
            }
        }
    }

    private String makeTrueBuildFile(String _sDBAntBuildFile, Map _sqlExeParam) throws CMyException {
        String sFileExt = CMyFile.extractFileExt(_sDBAntBuildFile);
        String sBuildFile = _sDBAntBuildFile.substring(0, _sDBAntBuildFile.lastIndexOf("." + sFileExt));
        String sBuildNewFile = sBuildFile + "_true." + sFileExt;
        CMyFile.copyFile(_sDBAntBuildFile, sBuildNewFile);
        String sBuildFileContent = CMyFile.readFile(sBuildNewFile);
        sBuildFileContent = CMyString.parsePageVariables(sBuildFileContent, _sqlExeParam);
        CMyFile.writeFile(sBuildNewFile, sBuildFileContent);
        return sBuildNewFile;
    }

    private String analysisAntExeLog(String sLogFile, String _lastLogFile) throws CMyException {
        String sResult = "";
        if (!CMyFile.fileExists(sLogFile)) {
            return sResult;
        }
        String sContent = CMyFile.readFile(sLogFile);
        if (sContent.indexOf("BUILD FAILED") > 0 || sContent.indexOf("Failed to execute") > 0) {
            sResult = "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u4e3a\uff1a\n" + sContent;
            sResult = sResult + "\n\u66f4\u8be6\u7ec6\u7684\u4fe1\u606f\u67e5\u770b\u65e5\u5fd7\u6587\u4ef6:\n\u3010" + _lastLogFile + "\u3011";
            throw new CMyException(sResult);
        }
        return sResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int exec(String[] cmd, String[] result) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer sbCmd = new StringBuffer();
            for (int i = 0; i < cmd.length; ++i) {
                sbCmd.append(cmd[i]).append(" ");
            }
            logger.debug((Object)("\u6267\u884c\u6570\u636e\u5e93\u65f6\u6267\u884c\u7684\u547d\u4ee4:" + sbCmd.toString()));
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream pis = proc.getInputStream();
        final InputStream per = proc.getErrorStream();
        try {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        int a = 0;
                        while ((a = per.read()) != -1) {
                            baos.write(a);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            int a = 0;
            while ((a = pis.read()) != -1) {
                baos.write(a);
            }
            t.join();
            int exitCode = proc.waitFor();
            String msg = new String(baos.toByteArray());
            if (exitCode != 0) {
                throw new Exception("ant exe fail:" + exitCode + ",msg=" + msg);
            }
            if (result != null && result.length > 0) {
                result[0] = msg.trim();
            }
            int n = 0;
            return n;
        }
        finally {
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Exception exception) {}
            }
            if (per != null) {
                try {
                    per.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String _sSQLFilePath = "D:\\WCM\\WCM7.0\\SQLScript\\sybase";
        int nDBType = 4;
        if (CMyString.isEmpty(_sSQLFilePath)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CMyFile.fileExists(_sSQLFilePath)) {
            throw new Exception("\u6307\u5b9a\u7684SQL\u6587\u4ef6\u6240\u5728\u7684\u8def\u5f84\u4e0d\u5b58\u5728\uff01[" + _sSQLFilePath + "]");
        }
        String sSQLPath = _sSQLFilePath;
        String sSQLFile = CMyString.setStrEndWith(sSQLPath, File.separatorChar);
        String sDelimiter = "!";
        DB2SQLProcessor4Ant oSQLProcessor = null;
        switch (nDBType) {
            case 3: 
            case 5: 
            case 6: {
                sSQLFile = sSQLFile + DB2_SQL_FILE;
                oSQLProcessor = new DB2SQLProcessor4Ant();
                break;
            }
            case 7: {
                sSQLFile = sSQLFile + MYSQL_SQL_FILE;
                oSQLProcessor = new MysqlSQLProcessor4Ant();
                break;
            }
            case 1: {
                sSQLFile = sSQLFile + ORACLE_SQL_FILE;
                oSQLProcessor = new OracleSQLProcessor4Ant();
                break;
            }
            case 2: {
                sSQLFile = sSQLFile + SQLSERVER_SQL_FILE;
                sDelimiter = ";";
                oSQLProcessor = new SQLServerSQLProcessor4Ant();
                break;
            }
            case 4: {
                sSQLFile = sSQLFile + SYBASE_SQL_FILE;
                sDelimiter = ";";
                oSQLProcessor = new SQLServerSQLProcessor4Ant();
                break;
            }
        }
        FileService oSQLFile = new FileService(sSQLFile);
        if (oSQLFile.isDirectory()) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u8981\u6267\u884c\u7684SQL\u6587\u4ef6");
        }
        if (oSQLProcessor == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684SQL\u811a\u672c\u5904\u7406\u7c7b");
        }
        String sNewFile = CMyFile.excludeFileExt(sSQLFile) + "_new.sql";
        CMyFile.copyFile(sSQLFile, sNewFile);
        oSQLProcessor.process((File)new FileWrapper(new FileService(sNewFile)));
    }
}

