/*
 * Decompiled with CFR 0.152.
 */
package com.trs.update.wcm;

import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import java.io.File;

public class WCMVersionInfo {
    public static String[] getVersionInfo() throws Exception {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if (!CMyFile.fileExists(sWCMPath)) {
            throw new Exception("\u8bf7\u4fee\u6539WEB-INF/classes/TRSWCMApp.ini\u6587\u4ef6\uff0c\u786e\u4fddWCM_Path\u8bbe\u7f6e\u6b63\u786e\uff01\u76ee\u524d\u914d\u7f6e\u4e3a\u3010" + sWCMPath + "\u3011");
        }
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        return WCMVersionInfo.getProductInfo(sWCMPath);
    }

    private static String[] getProductInfo(String path) {
        String sWCMPath = CMyString.setStrEndWith(path, File.separatorChar);
        String sAboutHtml = "app/main/about.html".replace('/', File.separatorChar);
        String sAboutJsp = "app/main/about.jsp".replace('/', File.separatorChar);
        boolean bHasTheJsp = new FileService(sWCMPath + sAboutJsp).exists();
        boolean bHasTheHtml = new FileService(sWCMPath + sAboutHtml).exists();
        String sLineVersion = "";
        if (bHasTheJsp) {
            sLineVersion = WCMVersionInfo.readFileReturnVersion(sWCMPath + sAboutJsp);
        } else if (bHasTheHtml) {
            sLineVersion = WCMVersionInfo.readFileReturnVersion(sWCMPath + sAboutHtml);
        }
        String[] r = new String[2];
        if (!CMyString.isEmpty(sLineVersion)) {
            r = sLineVersion.split("-");
        }
        return r;
    }

    private static String readFileReturnVersion(String aboutFilePath) {
        String sCharset = CharsetDetector.detect(aboutFilePath);
        String sFileContent = "";
        try {
            sFileContent = CMyFile.readFile(aboutFilePath, sCharset);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6[" + aboutFilePath + "]\u51fa\u73b0\u5f02\u5e38");
        }
        int nStartPosition = sFileContent.indexOf("\u7248\u672c");
        if (nStartPosition < 0) {
            return "-1";
        }
        String sFileContentTemp = "";
        sFileContentTemp = sFileContent.substring(nStartPosition + 3, nStartPosition + 12);
        if (sFileContentTemp.equalsIgnoreCase("V6.5-1091")) {
            return sFileContentTemp;
        }
        sFileContent = sFileContent.substring(nStartPosition + 3, nStartPosition + 22);
        sFileContent = sFileContent.substring(0, sFileContent.lastIndexOf("-"));
        return sFileContent;
    }
}

