/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mobile;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.database.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;

public class MyDBManager {
    ConnectionPool m_oDBPool = null;

    public void connect(String _sURL, String _sUserName, String _sPassword) throws Exception {
        if (this.m_oDBPool != null) {
            return;
        }
        DBConnectionConfig dbConfig = this.makeDBConfig(_sURL, _sUserName, _sPassword);
        try {
            this.m_oDBPool = new ConnectionPool(dbConfig);
        }
        catch (SQLException ex) {
            throw new WCMException(41, "\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\uff1a" + dbConfig, ex);
        }
    }

    private DBConnectionConfig makeDBConfig(String _sURL, String _sUserName, String _sPassword) {
        DBManager dbMgr = DBManager.getDBManager();
        DBConnectionConfig currDBConfig = dbMgr.getDBConnConfig();
        DBConnectionConfig dbConfig = new DBConnectionConfig();
        dbConfig.setConnectionURL(_sURL);
        dbConfig.setConnectionUser(_sUserName);
        dbConfig.setConnectionPassword(_sPassword);
        dbConfig.setClassName(currDBConfig.getClassName());
        dbConfig.setCacheScheme(currDBConfig.getCacheScheme());
        dbConfig.setDowithClob(currDBConfig.isDowithClob());
        dbConfig.setInitConnects(5);
        dbConfig.setMaxConnects(20);
        return dbConfig;
    }

    public Connection getConnection() throws Exception {
        if (this.m_oDBPool == null) {
            throw new Exception("Please connect db\uff01");
        }
        Connection oConn = null;
        try {
            oConn = this.m_oDBPool.getConnection();
        }
        catch (Exception ex) {
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label9", "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u5931\u8d25(Application.getConnection)"), ex);
        }
        if (oConn == null) {
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label10", "\u6ca1\u6709\u627e\u5230\u6709\u6548\u53ef\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5(Application.getConnection)"));
        }
        return oConn;
    }

    public void freeConnection(Connection _oConn) {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.free(_oConn);
    }

    public void close() {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.close();
        this.m_oDBPool = null;
    }
}

