/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.job;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class JobScheduler {
    private static Logger s_logger = Logger.getLogger(JobScheduler.class);
    private Scheduler m_oScheduler = null;

    public void restart() throws WCMException {
        this.shutDown();
        this.start();
    }

    public void shutDown() {
        if (this.m_oScheduler == null) {
            return;
        }
        try {
            this.m_oScheduler.shutdown();
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(JobScheduler.class, "JobScheduler.label1", "\u5173\u95ed\u8c03\u5ea6\u7ba1\u7406\u5668\u5931\u8d25\uff01"), (Throwable)ex);
        }
        this.m_oScheduler = null;
    }

    public boolean start() throws WCMException {
        if (this.m_oScheduler == null) {
            return false;
        }
        this.initScheduler();
        return true;
    }

    public void addJob(String _sJobName, Class _jobWorkerClass, String _sArgs, CMyDateTime _dtExecute) throws WCMException {
        JobDetail currJobWorker = this.createJobDetail(_sJobName, _jobWorkerClass, _sArgs);
        SimpleTrigger currTrigger = new SimpleTrigger(_sJobName + "[Trigger]", "DEFAULT", (Date)_dtExecute.toDate());
        this.scheduleJob(currJobWorker, (Trigger)currTrigger);
    }

    public void addJob(String _sJobName, Class _jobWorkerClass, String _sArgs, CMyDateTime _dtStart, CMyDateTime _dtEnd, long _nInterval) throws WCMException {
        JobDetail currJobWorker = this.createJobDetail(_sJobName, _jobWorkerClass, _sArgs);
        SimpleTrigger currTrigger = new SimpleTrigger(_sJobName + "[Trigger]", "DEFAULT", (Date)_dtStart.toDate(), (Date)_dtEnd.toDate(), SimpleTrigger.REPEAT_INDEFINITELY, _nInterval);
        this.scheduleJob(currJobWorker, (Trigger)currTrigger);
    }

    public void addJob(String _sJobName, Class _jobWorkerClass, String _sArgs, long _nInterval) throws WCMException {
        JobDetail currJobWorker = this.createJobDetail(_sJobName, _jobWorkerClass, _sArgs);
        SimpleTrigger currTrigger = new SimpleTrigger(_sJobName + "[Trigger]", "DEFAULT", SimpleTrigger.REPEAT_INDEFINITELY, _nInterval);
        this.scheduleJob(currJobWorker, (Trigger)currTrigger);
    }

    public void addJob(String _sJobName, Class _jobWorkerClass, String _sArgs, String _sCronExpression) throws WCMException {
        JobDetail currJobWorker = this.createJobDetail(_sJobName, _jobWorkerClass, _sArgs);
        CronTrigger currTrigger = null;
        try {
            currTrigger = new CronTrigger(_sJobName + "[Trigger]", "DEFAULT", _sCronExpression);
        }
        catch (ParseException ex) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label2", "\u63a7\u5236\u8868\u8fbe\u5f0f\u6709\u8bef[") + _sCronExpression + "].", ex);
        }
        this.scheduleJob(currJobWorker, (Trigger)currTrigger);
    }

    public void addJob(String _sJobName, Class _jobWorkerClass, String _sArgs, String[] _arCronExpression) throws WCMException {
        if (_arCronExpression.length == 1) {
            this.addJob(_sJobName, _jobWorkerClass, _sArgs, _arCronExpression[0]);
            return;
        }
        for (int i = 0; i < _arCronExpression.length; ++i) {
            this.addJob(_sJobName + "-" + (i + 1), _jobWorkerClass, _sArgs, _arCronExpression[i]);
        }
    }

    public void deleteJob(String _sJobName) throws WCMException {
        try {
            this.getScheduler().deleteJob(_sJobName, "DEFAULT");
        }
        catch (SchedulerException ex) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label3", "\u5220\u9664JOB[") + _sJobName + I18NMessage.get(JobScheduler.class, "JobScheduler.label4", "]\u5931\u8d25\uff01"), ex);
        }
    }

    private void scheduleJob(JobDetail _currJobDetail, Trigger _currTrigger) throws WCMException {
        try {
            this.getScheduler().scheduleJob(_currJobDetail, _currTrigger);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label5", "\u6dfb\u52a0\u6307\u5b9a\u7684\u4efb\u52a1[") + _currJobDetail.getName() + I18NMessage.get(JobScheduler.class, "JobScheduler.label4", "]\u5931\u8d25\uff01"), ex);
        }
    }

    private void initScheduler() throws WCMException {
        if (this.m_oScheduler != null) {
            return;
        }
        try {
            StdSchedulerFactory schedFac = new StdSchedulerFactory();
            this.m_oScheduler = schedFac.getScheduler();
            this.m_oScheduler.start();
        }
        catch (Throwable ex) {
            throw new WCMException(1100, I18NMessage.get(JobScheduler.class, "JobScheduler.label6", "\u6784\u9020\u8ba1\u5212\u7ba1\u7406\u5668\u51fa\u73b0\u5f02\u5e38\uff01"), ex);
        }
    }

    private Scheduler getScheduler() throws WCMException {
        if (this.m_oScheduler == null) {
            this.initScheduler();
        }
        return this.m_oScheduler;
    }

    private JobDetail createJobDetail(String _sJobName, Class _jobWorkerClass, String _sArgs) {
        JobDetail currJobWorker = new JobDetail(_sJobName, "DEFAULT", _jobWorkerClass);
        if (_sArgs != null && (_sArgs = _sArgs.trim()).length() > 0) {
            AttributesString attrArgs = new AttributesString(_sArgs);
            int nAttCount = attrArgs.size();
            for (int i = 0; i < nAttCount; ++i) {
                String sName = attrArgs.getNameAt(i);
                currJobWorker.getJobDataMap().put(sName.toUpperCase(), attrArgs.getAttributeValue(sName));
            }
        }
        return currJobWorker;
    }

    public void addJob(String _sJobName, Class _jobWorkerClass, String _sArgs, Trigger _trigger) throws WCMException {
        JobDetail jobDetail = this.createJobDetail(_sJobName, _jobWorkerClass, _sArgs);
        _trigger.setJobGroup(jobDetail.getGroup());
        _trigger.setJobName(jobDetail.getName());
        this.scheduleJob(jobDetail, _trigger);
        try {
            if (s_logger.isDebugEnabled()) {
                JobDetail job = this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup());
                Trigger trigger = this.getScheduler().getTrigger(_trigger.getName(), _trigger.getGroup());
                s_logger.debug((Object)("job:" + job));
                s_logger.debug((Object)("trigger" + trigger));
                s_logger.debug((Object)("start:" + trigger.getStartTime()));
                s_logger.debug((Object)("end:" + trigger.getEndTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerCalendar(String _calendarName, Calendar _calendar) throws WCMException {
        try {
            Scheduler scheduler = this.getScheduler();
            if (scheduler.getCalendar(_calendarName) != null) {
                scheduler.deleteCalendar(_calendarName);
            }
            scheduler.addCalendar(_calendarName, _calendar, false, false);
        }
        catch (SchedulerException e) {
            throw new WCMException(1100, "fail to add calendar:" + _calendarName, e);
        }
    }

    public Iterator listTirggers() throws Exception {
        Scheduler scheduler = this.getScheduler();
        String[] names = scheduler.getJobNames("DEFAULT");
        ArrayList<Trigger> list = new ArrayList<Trigger>(names.length);
        JobDetail job = null;
        Trigger trigger = null;
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            job = scheduler.getJobDetail(names[i], "DEFAULT");
            trigger = scheduler.getTrigger(job.getName() + "[Trigger]", "DEFAULT");
            list.add(trigger);
        }
        return list.iterator();
    }
}

