/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.channel;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.wcm.channel.VChannel;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.PinyinHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VChannelManager {
    private static final String[] ADDEDIT_PAGES = new String[]{"../document/document_addedit.jsp", "../photo/photo_upload.jsp", "", "", ""};
    private static final String[] LIST_PAGES = new String[]{"../document/document_list.html", "../photo/photo_thumb.html", "", "", ""};
    private static final String[] SHOW_PAGES = new String[]{"../document/document_detail.jsp", "../photo/photo_show.jsp", "", "", ""};

    public void save(WebSite _parent, VChannel _oVChannel) throws WCMException {
        Map props = _oVChannel.getProperties();
        if (!props.isEmpty()) {
            Channel channel = new Channel();
            channel.setDesc(_oVChannel.getDesc());
            channel.setCanPub(true);
            channel.setType(0);
            channel.setSite(_parent.getId());
            channel.setOrder(1);
            channel.setParent(0);
            int nSiteType = _parent.getType();
            channel.setProperty("CONTENTADDEDITPAGE", ADDEDIT_PAGES[nSiteType]);
            channel.setProperty("CONTENTLISTPAGE", LIST_PAGES[nSiteType]);
            channel.setProperty("CONTENTSHOWPAGE", SHOW_PAGES[nSiteType]);
            String name = _oVChannel.getName();
            if (Channel.findByName(_parent.getSiteId(), name) != null) {
                channel.setNextId();
                name = name + "_" + channel.getId();
            }
            channel.setName(name);
            channel.insert(ContextHelper.getLoginUser());
            List children = _oVChannel.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.save(channel, (VChannel)children.get(i));
            }
            this.savePubConf(channel, name);
        } else {
            List children = _oVChannel.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.save(_parent, (VChannel)children.get(i));
            }
        }
    }

    public void save(Channel _parent, VChannel _oVChannel) throws WCMException {
        Map props = _oVChannel.getProperties();
        if (!props.isEmpty()) {
            Channel channel = new Channel();
            channel.setDesc(_oVChannel.getDesc());
            channel.setCanPub(true);
            channel.setType(0);
            channel.setOrder(1);
            channel.setSite(_parent.getSiteId());
            channel.setParent(_parent.getId());
            int nSiteType = _parent.getSite().getType();
            channel.setProperty("CONTENTADDEDITPAGE", ADDEDIT_PAGES[nSiteType]);
            channel.setProperty("CONTENTLISTPAGE", LIST_PAGES[nSiteType]);
            channel.setProperty("CONTENTSHOWPAGE", SHOW_PAGES[nSiteType]);
            String name = _oVChannel.getName();
            if (Channel.findByName(_parent.getSiteId(), name) != null) {
                channel.setNextId();
                name = name + "_" + channel.getId();
            }
            channel.setName(name);
            channel.insert(ContextHelper.getLoginUser());
            List children = _oVChannel.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.save(channel, (VChannel)children.get(i));
            }
            this.savePubConf(channel, name);
        } else {
            List children = _oVChannel.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.save(_parent, (VChannel)children.get(i));
            }
        }
    }

    private void savePubConf(BaseChannel substance, String name) throws WCMException {
        FolderPublishConfig conf = new FolderPublishConfig();
        conf.setDataPath(this.getDatapath(substance, name));
        conf.setFolder(substance.getWCMType(), substance.getId());
        if (substance.isSite()) {
            conf.setPageEncoding("utf-8");
            conf.setSiteLanguage(8);
            String rootDomain = "";
            try {
                rootDomain = (String)ContextParameters.get(1, true);
                rootDomain = rootDomain + "/pub/" + conf.getDataPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            conf.setRootDomain(rootDomain);
        }
        User user = ContextHelper.getLoginUser();
        conf.save(user);
        if (substance.isSite()) {
            WCMPubStatusConfig pubconf = new WCMPubStatusConfig();
            pubconf.setFolderType(substance);
            pubconf.setStatusesCanDoPub("16,10");
            pubconf.setStatusIdAfterModify(1);
            pubconf.save(user);
        }
    }

    private String getDatapath(BaseChannel substance, String name) throws WCMException {
        DBManager manager;
        String datapath = PinyinHelper.getFirstLetter(name, true);
        if (CMyString.isEmpty(datapath = datapath.replaceAll("[^\\w]", ""))) {
            datapath = "_" + substance.getId();
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(new Integer(substance.getWCMType()));
        params.add(datapath);
        String sql = "select FOLDERPUBLISHCONFIGID from WCMFOLDERPUBLISHCONFIG where FOLDERTYPE=? and DATAPATH=?";
        if (!substance.isSite()) {
            sql = sql + " and exists(select CHANNELID from WCMCHANNEL where PARENTID=? and channelid=WCMFOLDERPUBLISHCONFIG.FOLDERID and WCMFOLDERPUBLISHCONFIG.FOLDERTYPE=101";
            int parentid = substance.getParentId();
            params.add(new Integer(parentid));
            if (parentid == 0) {
                sql = sql + " and SITEID=?";
                params.add(new Integer(substance.getSiteId()));
            }
            sql = sql + ")";
        }
        if ((manager = DBManager.getDBManager()).sqlExecuteIntQuery(sql, params) >= 1) {
            datapath = datapath.replaceAll("(_\\d+)+", "");
            datapath = datapath + "_" + substance.getId();
        }
        return datapath;
    }

    public void save(WCMSystemObject _parent, VChannel _oVChannel) throws WCMException {
        Map props = _oVChannel.getProperties();
        if (!props.isEmpty()) {
            WebSite site = new WebSite();
            site.setDesc(_oVChannel.getDesc());
            site.setOrder(1);
            site.setType(_parent.getId());
            site.setParent(0);
            String name = _oVChannel.getName();
            if (this.existSite(name)) {
                site.setNextId();
                name = name + "_" + site.getId();
            }
            site.setName(name);
            User user = ContextHelper.getLoginUser();
            site.insert(user);
            List children = _oVChannel.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.save(site, (VChannel)children.get(i));
            }
            this.savePubConf(site, name);
        } else {
            List children = _oVChannel.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.save(_parent, (VChannel)children.get(i));
            }
        }
    }

    private boolean existSite(String name) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select SITEID from WCMWEBSITE where SITENAME=?";
        DBManager manager = DBManager.getDBManager();
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            return rs.next() && rs.getInt(1) > 0;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

