/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.IUserLoginInfoMgr;
import com.trs.components.stat.UserLoginInfo;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class UserLoginInfoServiceProvider
implements IGlueServiceProvider {
    private IUserLoginInfoMgr m_oUserLoginInfoMgr = (IUserLoginInfoMgr)DreamFactory.createObjectById("IUserLoginInfoMgr");

    @Override
    public Object query(MethodContext context) throws Throwable {
        User user = this.getLoginUser();
        WCMFilter oWCMFilter = context.getExtraWCMFilter();
        WCMFilter oFilter = null;
        if (!CMyString.isEmpty(context.getValue("userName"))) {
            oFilter = this.m_oUserLoginInfoMgr.getSearchUserName(context.getValue("userName"));
        } else if (!CMyString.isEmpty(context.getValue("groupName"))) {
            oFilter = this.m_oUserLoginInfoMgr.getSearchGroupName(context.getValue("groupName"));
        }
        oWCMFilter.mergeWith(oFilter);
        if (user.isAdministrator()) {
            return this.m_oUserLoginInfoMgr.query(user, oWCMFilter);
        }
        UserMgr userMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        if (userMgr.isAdminOfGroup(user)) {
            WCMFilter sFilter = this.m_oUserLoginInfoMgr.getUsersForGrpAdmin(user);
            oWCMFilter.mergeWith(sFilter);
            return this.m_oUserLoginInfoMgr.query(user, oWCMFilter);
        }
        WCMFilter sFilter = this.m_oUserLoginInfoMgr.getCurrUser(user);
        oWCMFilter.mergeWith(sFilter);
        return this.m_oUserLoginInfoMgr.query(user, oWCMFilter);
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        User currUser = this.getLoginUser();
        UserLoginInfo userLoginInfo = UserLoginInfo.createNewInstance();
        userLoginInfo.setUserId(currUser.getId());
        userLoginInfo.setLoginTime(currUser.getLoginTime());
        userLoginInfo.setIpAddress(currUser.getLoginIP());
        this.m_oUserLoginInfoMgr.save(userLoginInfo, currUser);
        return userLoginInfo.getId();
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

