/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aton.container.ContainerUtil;
import org.aton.container.IClearable;

public class TagItem
implements IClearable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String m_sName;
    private HashMap m_hAttributes = null;
    private Hashtable m_hExtraAttributes = null;
    private HashMap m_hVariableParameters = null;
    private List m_children = null;
    private int m_iBeginLineNo;
    private int m_iBeginColumn;
    private int m_iCloseLineNo;
    private int m_iCloseColumn;
    private TagItem m_parentItem;
    private boolean m_zIsVariableDeclare;
    private TemplateParameter m_oVariableParameter;

    public static final boolean isVariableParameter(String _sValue) {
        if (_sValue == null || _sValue.length() <= 3) {
            return false;
        }
        return _sValue.charAt(0) == '$' && _sValue.charAt(1) == '{' && _sValue.charAt(_sValue.length() - 1) == '}';
    }

    public static final boolean isVariableDeclare(String _sTagName) {
        return "TRS_VARIABLE".equals(_sTagName);
    }

    public void clear() {
        if (this.m_hAttributes != null && !this.m_hAttributes.isEmpty()) {
            this.m_hAttributes.clear();
        }
        if (this.m_children != null && !this.m_children.isEmpty()) {
            ContainerUtil.clearContainer((List)this.m_children);
        }
        if (this.m_hExtraAttributes != null && !this.m_hExtraAttributes.isEmpty()) {
            this.m_hExtraAttributes.clear();
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.toUpperCase();
        }
        if (this.m_sName == null) {
            this.m_sName = name;
            this.m_zIsVariableDeclare = TagItem.isVariableDeclare(name);
            if (this.m_zIsVariableDeclare) {
                this.m_oVariableParameter = new TemplateParameter();
                this.m_hVariableParameters = new HashMap();
                this.m_hVariableParameters.put(null, this.m_oVariableParameter);
            }
        } else {
            this.m_sName = name;
            this.m_zIsVariableDeclare = false;
        }
    }

    public HashMap getAttributes() {
        return this.m_hAttributes;
    }

    public String getAttribute(String _sName) {
        if (this.m_hAttributes == null || _sName == null) {
            return null;
        }
        return (String)this.m_hAttributes.get(_sName.toUpperCase());
    }

    public String getAttributeTrim(String _sName) {
        String sValue = this.getAttribute(_sName);
        return sValue == null ? null : sValue.trim();
    }

    public String getRequiredAttribute(String _sName) throws WCMException {
        String sValue = this.getAttribute(_sName);
        if (sValue == null || sValue.length() == 0) {
            throw new WCMException(1106, "Attribute [" + _sName + "] required!");
        }
        return sValue;
    }

    public String getRequiredAttributeTrim(String _sName) throws WCMException {
        String sValue = this.getAttributeTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            throw new WCMException(1106, "Property [" + _sName + "] required!");
        }
        return sValue;
    }

    public int getIntAttribute(String _sName, int _nDefault) throws WCMException {
        String sValue = this.getAttributeTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            throw new WCMException(2, "Value [" + sValue + "] of attribute [" + _nDefault + "] is not integer!", ex);
        }
    }

    public boolean getBooleanAttribute(String _sName, boolean _bDefault) {
        String sValue = this.getAttribute(_sName);
        if (sValue == null || (sValue = sValue.trim()).length() == 0) {
            return _bDefault;
        }
        return sValue.equalsIgnoreCase("true");
    }

    public void setAttributes(HashMap _attributes) {
        this.m_hAttributes = _attributes;
    }

    public void setAttribute(String _sName, String _sValue) throws WCMException {
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            throw new WCMException(10, "Property name required!");
        }
        _sName = _sName.toUpperCase();
        if (_sValue == null) {
            if (this.m_zIsVariableDeclare) {
                this.parseVariableDeclare(_sName, _sValue);
            } else if (this.m_hVariableParameters != null) {
                this.m_hVariableParameters.remove(_sName);
            }
            if (this.m_hAttributes != null) {
                this.m_hAttributes.remove(_sName);
            }
        } else {
            if (this.m_zIsVariableDeclare) {
                this.parseVariableDeclare(_sName, _sValue);
            } else if (TagItem.isVariableParameter(_sValue)) {
                this.setVariableParameter(_sName, _sValue);
            }
            if (this.m_hAttributes == null) {
                this.m_hAttributes = new HashMap();
            }
            this.m_hAttributes.put(_sName.toUpperCase(), _sValue);
        }
    }

    public void setAttribute(String _sName, int _nValue) throws WCMException {
        this.setAttribute(_sName, String.valueOf(_nValue));
    }

    public void setAttribute(String _sName, boolean _bValue) throws WCMException {
        this.setAttribute(_sName, _bValue ? "true" : "false");
    }

    public String removeAttribute(String _sName) {
        if (_sName == null) {
            return null;
        }
        _sName = _sName.toUpperCase();
        if (this.m_hVariableParameters != null) {
            this.m_hVariableParameters.remove(_sName);
        }
        if (this.m_hAttributes != null) {
            return (String)this.m_hAttributes.remove(_sName);
        }
        return null;
    }

    public List getChildren() {
        return this.m_children;
    }

    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    public boolean containsChild(String _sName) {
        if (this.m_children == null) {
            return false;
        }
        int nSize = this.m_children.size();
        for (int i = 0; i < nSize; ++i) {
            Object child = this.m_children.get(i);
            if (child == null || !(child instanceof TagItem) || !((TagItem)child).getName().equalsIgnoreCase(_sName)) continue;
            return true;
        }
        return false;
    }

    public String getText() {
        Object firstChild;
        if (this.m_children != null && !this.m_children.isEmpty() && (firstChild = this.m_children.get(0)) != null && firstChild instanceof String) {
            return (String)firstChild;
        }
        return null;
    }

    public String setText(String sNewValue) {
        String sOldValue = this.getText();
        if (sNewValue == null) {
            return sOldValue;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        if (this.m_children.isEmpty()) {
            this.m_children.add(sNewValue);
        } else {
            Object firstChild = this.m_children.get(0);
            if (firstChild != null && firstChild instanceof String) {
                this.m_children.set(0, sNewValue);
            } else {
                this.m_children.add(0, sNewValue);
            }
        }
        return sOldValue;
    }

    public void setChildren(List _children) {
        this.m_children = _children;
    }

    public void addChild(TagItem _child) {
        if (_child == null) {
            return;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(_child);
        if (this.m_oVariableParameter != null && "TRS_ENUM".equals(_child.getName())) {
            this.m_oVariableParameter.addEnumValue(_child.getAttribute("VALUE"), _child.getAttribute("DISPLAY"));
        }
    }

    public void addChild(String _child) {
        if (_child == null) {
            return;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(_child);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<").append(this.getName());
        if (this.m_hAttributes != null) {
            for (Map.Entry entry : this.m_hAttributes.entrySet()) {
                buff.append(' ').append(entry.getKey()).append("=\"");
                buff.append(CMyString.replaceStr((String)entry.getValue(), "\"", "\\\""));
                buff.append("\"");
            }
        }
        buff.append(">");
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.size(); ++i) {
                Object aChild = this.m_children.get(i);
                if (aChild instanceof TagItem) {
                    buff.append(((TagItem)aChild).toString());
                    continue;
                }
                buff.append(aChild.toString());
            }
        }
        buff.append("</").append(this.getName()).append(">");
        return buff.toString();
    }

    public int getBeginColumn() {
        return this.m_iBeginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.m_iBeginColumn = beginColumn;
    }

    public int getBeginLineNo() {
        return this.m_iBeginLineNo;
    }

    public void setBeginLineNo(int beginLineNo) {
        this.m_iBeginLineNo = beginLineNo;
    }

    public int getCloseColumn() {
        return this.m_iCloseColumn;
    }

    public void setCloseColumn(int closeColumn) {
        this.m_iCloseColumn = closeColumn;
    }

    public int getCloseLineNo() {
        return this.m_iCloseLineNo;
    }

    public void setCloseLineNo(int closeLineNo) {
        this.m_iCloseLineNo = closeLineNo;
    }

    public String getDescWithPos() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getName());
        sb.append(I18NMessage.get(TagItem.class, "TagItem.label1", "[\u884c:")).append(this.m_iBeginLineNo).append(',');
        sb.append(I18NMessage.get(TagItem.class, "TagItem.label2", "\u5217:")).append(this.m_iBeginColumn).append(']');
        sb.append(">");
        return sb.toString();
    }

    public void setExtraAttribute(String _sAttrName, String _sValue) {
        if (this.m_hExtraAttributes == null) {
            Hashtable<String, String> hTemp = new Hashtable<String, String>(1);
            hTemp.put(_sAttrName.toUpperCase(), _sValue);
            this.m_hExtraAttributes = hTemp;
        } else {
            this.m_hExtraAttributes.put(_sAttrName.toUpperCase(), _sValue);
        }
    }

    public String getExtraAttributeValue(String _sAttrName) {
        if (this.m_hExtraAttributes == null) {
            return null;
        }
        Object value = this.m_hExtraAttributes.get(_sAttrName.toUpperCase());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public HashMap getVariableParameters() {
        return this.m_hVariableParameters;
    }

    public TemplateParameter getVariableParameter(String _sName) {
        if (_sName == null || this.m_hVariableParameters == null) {
            return null;
        }
        return (TemplateParameter)this.m_hVariableParameters.get(_sName.toUpperCase());
    }

    private void setVariableParameter(String _sName, String _sValue) {
        if (this.m_hVariableParameters == null) {
            this.m_hVariableParameters = new HashMap();
        }
        TemplateParameter aParameter = new TemplateParameter();
        this.m_hVariableParameters.put(_sName, aParameter);
        String sValue = _sValue.substring(2, _sValue.length() - 1);
        int iNameSplit = sValue.indexOf(126);
        if (iNameSplit <= 0) {
            aParameter.setParameterName(sValue);
            return;
        }
        aParameter.setParameterName(sValue.substring(0, iNameSplit++));
        int iTypeSplit = sValue.indexOf(126, iNameSplit);
        if (iTypeSplit <= 0) {
            aParameter.setParameterType(TemplateParameter.Type.STRING);
            aParameter.setParameterDefault(sValue.substring(iNameSplit));
            return;
        }
        aParameter.setParameterType(sValue.substring(iNameSplit, iTypeSplit++));
        int iDefaultSplit = sValue.indexOf(126, iTypeSplit);
        if (iDefaultSplit <= 0) {
            aParameter.setParameterDefault(sValue.substring(iTypeSplit));
            return;
        }
        aParameter.setParameterDefault(sValue.substring(iTypeSplit, iDefaultSplit++));
        int iSplitThis = 0;
        int iSplitLast = iDefaultSplit;
        while ((iSplitThis = sValue.indexOf(126, iSplitLast)) > 0) {
            aParameter.addEnumValue(sValue.substring(iSplitLast, iSplitThis));
            iSplitLast = iSplitThis + 1;
        }
        if (iSplitLast < sValue.length()) {
            aParameter.addEnumValue(sValue.substring(iSplitLast));
        } else {
            aParameter.setCanCustom(true);
        }
    }

    private void parseVariableDeclare(String _sName, String _sValue) {
        if (this.m_oVariableParameter == null) {
            throw new IllegalStateException("'m_oVariableParameter' is null");
        }
        if ("NAME".equals(_sName)) {
            if (_sValue == null) {
                throw new IllegalArgumentException("'Variable name' is null");
            }
            this.m_oVariableParameter.setParameterName(_sValue);
            return;
        }
        if ("TYPE".equals(_sName)) {
            this.m_oVariableParameter.setParameterType(_sValue);
            return;
        }
        if ("DEFAULT".equals(_sName)) {
            this.m_oVariableParameter.setParameterDefault(_sValue);
            return;
        }
        if ("SPLIT".equals(_sName)) {
            if (_sValue != null && (_sValue = _sValue.trim()).length() == 1) {
                this.m_oVariableParameter.setEnumSplit(_sValue.charAt(0));
            }
            return;
        }
        if ("ENUMERATE".equals(_sName)) {
            this.m_oVariableParameter.addEnumValue(_sValue);
            return;
        }
        if ("CANCUSTOM".equals(_sName)) {
            this.m_oVariableParameter.setCanCustom("true".equalsIgnoreCase(_sValue));
            return;
        }
    }

    public Iterator findItems(final String[] itemNames) {
        Iterator itr = new Iterator(){
            int m_iCurrentIndex = -1;
            List m_oCurrentList = TagItem.access$000(TagItem.this);
            TagItem m_oCurrentItem = null;
            Stack m_oStack = new Stack();

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return this.m_oCurrentItem != null || this.findNext();
            }

            public Object next() {
                if (this.m_oCurrentItem != null || this.findNext()) {
                    TagItem temp = this.m_oCurrentItem;
                    this.m_oCurrentItem = null;
                    return temp;
                }
                return null;
            }

            /*
             * Unable to fully structure code
             */
            private boolean findNext() {
                block0: while (true) {
                    ++this.m_iCurrentIndex;
                    while (this.m_iCurrentIndex >= this.m_oCurrentList.size()) {
                        if (this.m_oStack.isEmpty()) {
                            return false;
                        }
                        this.m_oCurrentList = (List)this.m_oStack.pop();
                        this.m_iCurrentIndex = (Integer)this.m_oStack.pop();
                        ++this.m_iCurrentIndex;
                    }
                    objCurrent = this.m_oCurrentList.get(this.m_iCurrentIndex);
                    if (!(objCurrent instanceof TagItem)) continue;
                    tagCurrent = (TagItem)objCurrent;
                    if (tagCurrent.hasChildren()) {
                        this.m_oStack.push(new Integer(this.m_iCurrentIndex));
                        this.m_oStack.push(this.m_oCurrentList);
                        this.m_oCurrentList = tagCurrent.getChildren();
                        this.m_iCurrentIndex = -1;
                    }
                    if (itemNames == null || itemNames.length == 0) {
                        this.m_oCurrentItem = tagCurrent;
                        return true;
                    }
                    tagName = tagCurrent.getName();
                    i = 0;
                    while (true) {
                        if (i < itemNames.length) ** break;
                        continue block0;
                        if (tagName.equalsIgnoreCase(itemNames[i])) {
                            this.m_oCurrentItem = tagCurrent;
                            return true;
                        }
                        ++i;
                    }
                    break;
                }
            }
        };
        return itr;
    }

    public void setParent(TagItem _parentItem) {
        this.m_parentItem = _parentItem;
    }

    public TagItem getParent() {
        return this.m_parentItem;
    }

    public List findParentItems() {
        ArrayList<TagItem> parents = new ArrayList<TagItem>(3);
        for (TagItem parent = this.m_parentItem; parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        return parents;
    }

    static /* synthetic */ List access$000(TagItem x0) {
        return x0.m_children;
    }
}

