/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.logger;

import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.OperType;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;

public final class OperTypeHelper {
    private static final Integer UNKNOWN = new Integer(0);
    private static final HashMap ADD_OPS = new HashMap(20, 0.5f);
    private static final HashMap MODIFY_OPS = new HashMap(20, 0.5f);
    private static final HashMap DELETE_OPS = new HashMap(20, 0.5f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAddOp(BaseObj object) {
        Class<?> objClass = object.getClass();
        Integer optype = (Integer)ADD_OPS.get(objClass.getName());
        if (optype == null) {
            Class<?> clazz = objClass;
            synchronized (clazz) {
                optype = OperTypeHelper.find("\u65b0\u5efa" + OperTypeHelper.getTypeName(object));
                if (optype != UNKNOWN) {
                    ADD_OPS.put(objClass.getName(), optype);
                }
            }
        }
        return optype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModifyOp(BaseObj object) {
        Class<?> objClass = object.getClass();
        Integer optype = (Integer)MODIFY_OPS.get(objClass.getName());
        if (optype == null) {
            Class<?> clazz = objClass;
            synchronized (clazz) {
                optype = OperTypeHelper.find("\u4fee\u6539" + OperTypeHelper.getTypeName(object));
                if (optype != UNKNOWN) {
                    MODIFY_OPS.put(objClass.getName(), optype);
                }
            }
        }
        return optype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeleteOp(BaseObj object) {
        Class<?> objClass = object.getClass();
        Integer optype = (Integer)DELETE_OPS.get(objClass.getName());
        if (optype == null) {
            Class<?> clazz = objClass;
            synchronized (clazz) {
                optype = OperTypeHelper.find("\u5220\u9664" + OperTypeHelper.getTypeName(object));
                if (optype != UNKNOWN) {
                    DELETE_OPS.put(objClass.getName(), optype);
                }
            }
        }
        return optype;
    }

    private static String getTypeName(BaseObj object) {
        String typeName = WCMTypes.getObjName(object.getWCMType(), true);
        if ("\u672a\u77e5".equals(typeName) || "unknown".equals(typeName.toLowerCase())) {
            typeName = object.getClassName(false);
        }
        return typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer find(String objname) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select OPERTYPEID from WCMOPERTYPE where NAME=?";
        DBManager dbmanager = DBManager.getDBManager();
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, objname);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer n = new Integer(rs.getInt(1));
                return n;
            }
        }
        catch (Exception ex) {
            Integer n = UNKNOWN;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        try {
            OperType type = new OperType();
            type.setName(objname);
            type.setDesc(objname);
            type.setProperty("CRUSER", "system");
            type.setProperty("CRTIME", CMyDateTime.now());
            type.save();
            return new Integer(type.getId());
        }
        catch (Exception ex) {
            return UNKNOWN;
        }
    }

    protected void finalize() throws Throwable {
        ADD_OPS.clear();
        MODIFY_OPS.clear();
        DELETE_OPS.clear();
        super.finalize();
    }
}

