/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.cluster.ClusterConfigHelper;
import com.trs.cluster.TRSClusterExtensionImpl;
import com.trs.cluster.ext.wcm.ActionMessage;
import com.trs.cluster.ext.wcm.ActionMessages;
import com.trs.cluster.ext.wcm.ClusterWatchDog;
import com.trs.cluster.ext.wcm.MasterTokenListener;
import com.trs.cluster.ext.wcm.MemberInfo;
import com.trs.cluster.ext.wcm.MemberShipNotifier;
import com.trs.infra.BaseServer;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.Extension;
import com.trs.infra.cluster.ExtensionManager;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.TokenListener;
import com.trs.infra.cluster.impl.ClusterContextImpl;
import com.trs.infra.cluster.io.FilterStreamReader;
import com.trs.infra.cluster.io.FilterStreamWriter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TRSWCMClusterServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(TRSWCMClusterServer.class);
    private static final String GUID_TRSWCM_CLUSTER = "TRSWCMClustorEx1.0";
    private ClusterContextImpl m_oClusterContextImpl = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRSWCMClusterServer() {
        Class<TRSWCMClusterServer> clazz = TRSWCMClusterServer.class;
        synchronized (TRSWCMClusterServer.class) {
            this.startup();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void doShutdown() {
        if (this.m_oClusterContextImpl == null) {
            return;
        }
        this.m_oClusterContextImpl.close();
        this.m_oClusterContextImpl = null;
    }

    @Override
    protected boolean doStart() throws WCMException {
        if (this.m_oClusterContextImpl != null) {
            return true;
        }
        ClusterConfig config = ClusterConfigHelper.getConfig();
        if (!config.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Not a cluster member.");
            }
            return true;
        }
        ClusterContextImpl impl = new ClusterContextImpl();
        impl.setConfig(config);
        ExtensionManager em = impl.getExtensionManager();
        TRSClusterExtensionImpl extension = new TRSClusterExtensionImpl(GUID_TRSWCM_CLUSTER);
        em.addExtension((Extension)extension);
        impl.start();
        this.setAfterStarted(impl);
        this.m_oClusterContextImpl = impl;
        new Redo().start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAfterStarted(ClusterContextImpl impl) {
        Member local = impl.getMemberManager().member();
        impl.getMemberManager().addListener((MemberListener)new MemberShipNotifier(local));
        MemberInfo info = new MemberInfo();
        InputStream ins = null;
        Properties props = new Properties();
        try {
            ins = this.getClass().getResourceAsStream("/trswcmcluster.properties");
            props.load(ins);
            String prop = props.getProperty("cluster.extra.serviceAddress");
            if (CMyString.isEmpty(prop)) {
                logger.warn((Object)"cluster.extra.serviceAddress has not config properly!");
                prop = local.getTCPAddress().getHostAddress();
            }
            info.setHost(prop);
            prop = props.getProperty("cluster.extra.servicePort", "8080");
            info.setPort(Integer.parseInt(prop));
            prop = props.getProperty("cluster.extra.serviceCheckURL");
            info.setCheckURL(prop);
            local.setAttribute("cluster.extra.MemberInfo", (Object)info);
            ClusterWatchDog dog = new ClusterWatchDog(local.getTCPAddress().getHostAddress());
            dog.barkOnStarted(info.getPort());
        }
        catch (Exception e) {
            logger.warn((Object)"init member extra attributes failed.", (Throwable)e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            props.clear();
        }
        impl.getTokenManager().addListener("cluster.token.MasterNode", (TokenListener)new MasterTokenListener());
    }

    public void sendMsg(Serializable _args) {
        if (this.m_oClusterContextImpl == null || !this.m_oClusterContextImpl.getConfig().isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Not a cluster member.");
            }
            return;
        }
        this.m_oClusterContextImpl.getExtensionManager().sendToCluster(GUID_TRSWCM_CLUSTER, _args);
    }

    public void sendMsg(Serializable _args, boolean _bPersistentMsg) {
        if (_bPersistentMsg) {
            Member caller = this.m_oClusterContextImpl.getMemberManager().member();
            try {
                String data = TRSWCMClusterServer.serializeMessage(_args);
                ActionMessage msg = new ActionMessage();
                msg.setBody(data);
                msg.setHashValue(data.hashCode());
                msg.setSourceGUID(caller._guid());
                msg.save();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to persistent the message.", (Throwable)e);
            }
        }
        this.sendMsg(_args);
    }

    public ClusterContext getContext() {
        return this.m_oClusterContextImpl;
    }

    public String getGUID() {
        return GUID_TRSWCM_CLUSTER;
    }

    public static String serializeMessage(Serializable _args) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        FilterStreamWriter writer = new FilterStreamWriter((OutputStream)baos);
        writer.write_object(_args);
        return baos.toString("ISO-8859-1");
    }

    public static Object deserializeMessage(String message) {
        ByteArrayInputStream bains = null;
        FilterStreamReader reader = null;
        try {
            bains = new ByteArrayInputStream(message.getBytes("ISO-8859-1"));
            reader = new FilterStreamReader((InputStream)bains);
            return reader.read_object();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to deserialize cluster message.", (Throwable)e);
            return null;
        }
    }

    private class Redo
    extends Thread {
        private static final int HALF_MINUTE = 30000;

        public Redo() {
            super("ClusterActionMsgRedo");
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                WCMFilter filter = new WCMFilter("", "MSGDATE=?", "XWCMCLUSTERACTIONMSGID asc");
                filter.addSearchValues(CMyDateTime.now().toString("yyyyMMdd"));
                ActionMessages msgs = new ActionMessages();
                msgs.open(filter);
                ClusterContext context = TRSWCMClusterServer.this.getContext();
                Extension extentsion = context.getExtensionManager().getExtension(TRSWCMClusterServer.GUID_TRSWCM_CLUSTER);
                MemberManager memberManager = context.getMemberManager();
                Member current = memberManager.member();
                String guid = current._guid();
                HashSet<String> msghashSet = new HashSet<String>();
                int size = msgs.size();
                for (int i = 0; i < size; ++i) {
                    Object args;
                    ActionMessage msg = (ActionMessage)msgs.getAt(i);
                    if (msg == null || guid.equals(msg.getSourceGUID()) || msghashSet.contains(String.valueOf(msg.getHashValue())) || (args = TRSWCMClusterServer.deserializeMessage(msg.getBody())) == null) continue;
                    Member caller = memberManager.find(msg.getSourceGUID());
                    if (caller == null) {
                        caller = current;
                    }
                    extentsion.callByCluster(args, caller);
                    msghashSet.add(String.valueOf(msg.getHashValue()));
                }
                msghashSet.clear();
                msgs.clear();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to redo the message.", (Throwable)e);
            }
        }
    }
}

