/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class RequestUtil {
    public static final String HEADER_USER_AGENT = "user-agent";
    public static final String HEADER_REFER = "referer";
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.cis4.util.RequestUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static int getParameterAsInt(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsInt(request, param, 0);
    }

    public static int getParameterAsInt(HttpServletRequest request, String param, int defaultValue) {
        String value = request.getParameter(param);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.warn((Object)("err=" + e + "! param=" + param + ", value=" + value + "! return " + defaultValue));
            return defaultValue;
        }
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsBool(request, param, false);
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param, boolean defaultValue) {
        boolean result = defaultValue;
        String paramValue = request.getParameter(param);
        if (paramValue != null) {
            result = "true".equalsIgnoreCase(paramValue);
        }
        return result;
    }

    public static String getParameterAsGBK(HttpServletRequest request, String param) {
        return RequestUtil.getParamByEncoding(request, param, "ISO-8859-1", "GBK");
    }

    public static String getParameterAsGBK(HttpServletRequest request, String param, String originEncoding) {
        return RequestUtil.getParamByEncoding(request, param, originEncoding, "GBK");
    }

    public static String getParameter(HttpServletRequest request, String param) {
        return RequestUtil.getParamByEncoding(request, param, "ISO-8859-1", "UTF-8");
    }

    public static String getParamByEncoding(HttpServletRequest request, String param, String originEncoding, String toEncoding) {
        if (param == null) {
            return null;
        }
        String result = request.getParameter(param);
        if (result == null) {
            return null;
        }
        try {
            String retString = new String(result.getBytes(originEncoding), toEncoding);
            if (retString.indexOf("??") == -1) {
                return retString;
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("unspport encoding! origin=" + originEncoding + ", to=" + toEncoding), (Throwable)e);
            return "";
        }
    }

    public static String getAttributeAsTrimStr(HttpServletRequest request, String attrName) {
        return RequestUtil.getAttributeAsTrimStr(request, attrName, "");
    }

    public static String getAttributeAsTrimStr(HttpServletRequest request, String attrName, String defValue) {
        Object obj = request.getAttribute(attrName);
        return obj instanceof String ? ((String)obj).trim() : defValue;
    }

    public static int getAttributeAsInt(HttpServletRequest request, String attrName, int defValue) {
        Object obj = request.getAttribute(attrName);
        return obj instanceof Integer ? (Integer)obj : defValue;
    }

    public static boolean existParameter(HttpServletRequest request, String param) {
        return param != null && request.getParameter(param) != null;
    }

    public static String getFullGetStr(HttpServletRequest request) {
        String qryStr = request.getQueryString();
        if (qryStr == null) {
            return request.getRequestURL().toString();
        }
        return request.getRequestURL().append('?').append(qryStr).toString();
    }

    public static String getCurPageWithQryStr(HttpServletRequest request) {
        return RequestUtil.getCurPageWithQryStr(request, null);
    }

    public static String getCurPageWithQryStr(HttpServletRequest request, String param) {
        String qryStr = RequestUtil.removeQryParam(request.getQueryString(), param);
        if (qryStr == null) {
            return RequestUtil.getCurrentPage(request);
        }
        return RequestUtil.getCurrentPage(request) + '?' + qryStr;
    }

    public static String removeQryParam(String qryStr, String param) {
        if (qryStr == null || param == null) {
            return qryStr;
        }
        String[] params = qryStr.split("&");
        StringBuffer sb = new StringBuffer(qryStr.length());
        int i = 0;
        while (i < params.length) {
            if (!params[i].startsWith(String.valueOf(param) + "=")) {
                sb.append(params[i]).append('&');
            }
            ++i;
        }
        return sb.length() > 0 ? sb.deleteCharAt(sb.length() - 1).toString() : null;
    }

    public static String getCurrentPage(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        return requestURI.substring(requestURI.lastIndexOf(47) + 1);
    }

    public static String getRequestBrief(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("[Req]");
        sb.append(request.getMethod()).append(' ');
        sb.append(request.getRequestURI());
        return sb.toString();
    }

    public static String getFullRequestStr(HttpServletRequest request) {
        return new StringBuffer(256).append(request.getRequestURL()).append(RequestUtil.getParamString(request)).toString();
    }

    public static String getParamString(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        int i = 0;
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            sb.append(++i == 1 ? "?" : "&").append(param).append("=").append(request.getParameter(param));
        }
        return sb.toString();
    }

    public static String getAllHeadersStr(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            sb.append(header);
            sb.append("=");
            sb.append(request.getHeader(header));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getReferUrl(HttpServletRequest request) {
        String referUrl = request.getHeader(HEADER_REFER);
        return referUrl == null ? "" : referUrl;
    }

    public static int getPageUriPosInRequest(HttpServletRequest request, String someUri) {
        if (someUri == null || someUri.trim().length() == 0) {
            return -2;
        }
        return RequestUtil.getRelativePath(request).indexOf(someUri);
    }

    public static String getContextRoot(HttpServletRequest request) {
        String servletPath;
        String sysUrl = request.getRequestURL().toString();
        int servletPathIndex = sysUrl.indexOf(servletPath = request.getServletPath());
        if (servletPathIndex == -1) {
            logger.error((Object)("servletPath=" + servletPath + ", sysUrl=" + sysUrl + ", so index=" + servletPathIndex));
            return sysUrl;
        }
        return sysUrl.substring(0, servletPathIndex);
    }

    public static String getRelativePathWithQryStr(HttpServletRequest request) {
        String qryStr = request.getQueryString();
        String relativePath = RequestUtil.getRelativePath(request);
        if (qryStr == null) {
            return relativePath;
        }
        return new StringBuffer(relativePath.length() + qryStr.length() + 1).append(relativePath).append('?').append(qryStr).toString();
    }

    public static String getRelativePath(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    public static String getServletContainerInfo(ServletContext application) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(application.getServerInfo());
        sb.append(" (Servlet ").append(application.getMajorVersion()).append('.').append(application.getMinorVersion());
        return sb.toString();
    }

    public static void log(HttpServletRequest request) {
        RequestUtil.log(RequestUtil.getRequestInfo(request), null);
    }

    public static String getRequestInfo(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("[Request]");
        sb.append(request.getClass().getName());
        sb.append(": (").append(request.getScheme()).append(')').append(request.getServerName()).append(':').append(request.getServerPort());
        sb.append(", ").append(request.getMethod()).append(' ').append(request.getProtocol());
        sb.append(", uri=").append(request.getRequestURI());
        sb.append(", ctx=").append(request.getContextPath());
        sb.append(", servlet=").append(request.getServletPath());
        sb.append(", qryStr=").append(request.getQueryString());
        sb.append(", refer=").append(request.getHeader(HEADER_REFER));
        sb.append(", useragt=").append(request.getHeader(HEADER_USER_AGENT));
        sb.append(", ip=").append(request.getRemoteAddr());
        return sb.toString();
    }

    public static void log(Object obj, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(new Timestamp(System.currentTimeMillis()));
        if (request != null) {
            sb.append('\t').append(request.getRequestURI());
        }
        sb.append('\t').append(obj);
        System.out.println(sb);
    }
}

