/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.mime;

import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeUtils {
    private static HashMap contentTypes = new HashMap();

    public static String getUniqueValue() {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
            for (int i = 0; i < host.length(); ++i) {
                if ((host.charAt(i) & 0xFF80) == 0) continue;
                StringBuffer h = new StringBuffer(host.length());
                for (int j = 0; j < host.length(); ++j) {
                    h.append(host.charAt(j) & 0x7F | 0x20);
                }
                host = h.toString();
            }
        }
        catch (UnknownHostException uhe) {
            host = "localhost";
        }
        StringBuffer s = new StringBuffer(128);
        s.append(s.hashCode()).append('.').append(System.currentTimeMillis()).append(".apache-soap.").append(host);
        return s.toString();
    }

    public static String getEncoding(String type, String defaultEncoding) {
        String encoding = null;
        if (type != null && !type.equals("")) {
            encoding = MimeUtils.getContentType(type).getParameter("charset");
        }
        encoding = encoding == null ? defaultEncoding : MimeUtility.javaCharset((String)encoding);
        return encoding;
    }

    public static String encode(String s) {
        return URLEncoder.encode(s);
    }

    public static String decode(String s) {
        return URLDecoder.decode(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentType getContentType(String ctype) {
        HashMap hashMap = contentTypes;
        synchronized (hashMap) {
            ContentType type = (ContentType)contentTypes.get(ctype);
            if (type == null) {
                try {
                    type = new ContentType(ctype);
                }
                catch (ParseException e) {
                    return null;
                }
                contentTypes.put(ctype, type);
            }
            return type;
        }
    }
}

