/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;
import org.apache.soap.util.mime.MimeUtils;

public class ServerUtils {
    public static Envelope readEnvelopeFromInputStream(DocumentBuilder xdb, InputStream is, int contentLength, String contentType, EnvelopeEditor editor, SOAPContext ctx) throws SOAPException, IOException, IllegalArgumentException, MessagingException {
        return ServerUtils.readEnvelopeFromInputStream(xdb, is, contentLength, contentType, editor, ctx, null);
    }

    public static Envelope readEnvelopeFromInputStream(DocumentBuilder xdb, InputStream is, int contentLength, String contentType, EnvelopeEditor editor, SOAPContext ctx, Hashtable headers) throws SOAPException, IOException, IllegalArgumentException, MessagingException {
        TransportMessage reqMsg = new TransportMessage(is, contentLength, contentType, ctx, headers);
        reqMsg.read();
        String ctype = ctx.getRootPartContentType();
        ContentType type = null;
        type = MimeUtils.getContentType(ctype);
        if (type == null || !Constants.CTYPE_TEXT_XML.match(type)) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported content type \"" + ctype + "\", must be: \"" + "text/xml" + "\".");
        }
        reqMsg.editIncoming(editor);
        return reqMsg.unmarshall(xdb);
    }

    public static Provider loadProvider(DeploymentDescriptor dd, SOAPContext ctxt) throws SOAPException {
        Object newObj;
        String className = dd.getServiceClass();
        if (className == null) {
            return null;
        }
        if (className.equals("java")) {
            className = "org.apache.soap.providers.RPCJavaProvider";
        } else if (className.equals("script")) {
            className = "org.apache.soap.providers.RPCJavaProvider";
        }
        try {
            Class c = ctxt.loadClass(className);
            newObj = c.newInstance();
        }
        catch (Exception exp) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't load provider '" + className + "'", exp);
        }
        if (!(newObj instanceof Provider)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "'" + className + "' isn't a provider");
        }
        return (Provider)newObj;
    }

    public static void setResponseGzip(DeploymentDescriptor dd, SOAPContext reqCtx, SOAPContext resCtx) {
        if (Boolean.TRUE.equals(reqCtx.getAcceptGzip())) {
            Hashtable props = dd.getProps();
            String gzip = props != null ? (String)props.get("gzip") : null;
            resCtx.setGzip(gzip != null && SoapEncUtils.decodeBooleanValue(gzip));
        } else if (Boolean.FALSE.equals(reqCtx.getAcceptGzip())) {
            resCtx.setGzip(false);
        } else {
            resCtx.setGzip(false);
        }
    }
}

