/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service.listener;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.SCMCommentInfo;
import com.trs.scm.sdk.model.Comment;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CreateAndDestroyListenerForScmCommon
implements IServiceListener {
    Logger logger = Logger.getLogger(CreateAndDestroyListenerForScmCommon.class);
    private final String sCreateComment = "createComment";
    private final String sdestroyComment = "destroyComment";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterServiceExecuted(ServiceListenerConfig listenerConfig, MethodContext methodContext, Object serviceResult) {
        Boolean bIsSuccess;
        Comment oComment;
        String sMethodName = listenerConfig.getMethodName();
        if ("createComment".equalsIgnoreCase(sMethodName) && null != (oComment = (Comment)serviceResult)) {
            User loginUser = ContextHelper.getLoginUser();
            CMyDateTime creatTime = CMyDateTime.now();
            boolean bIsReplyComment = methodContext.getValue("isReplyComment", false);
            String sContent = methodContext.getValue("Content");
            String nCommentId = oComment.getCommentId();
            long nAccountId = methodContext.getValue("AccountId", 0);
            String nMicroContentId = methodContext.getValue("MicroContentId");
            String sPlatform = null;
            try {
                Account oAccount = Account.findById(methodContext.getValue("AccountId", 0));
                sPlatform = oAccount.getPlatform();
            }
            catch (WCMException e2) {
                e2.printStackTrace();
            }
            SCMCommentInfo commentInfo = new SCMCommentInfo();
            try {
                commentInfo.setIsReplyComment(bIsReplyComment);
                commentInfo.setCommentContent(sContent);
                commentInfo.setCommentId(nCommentId);
                commentInfo.setWeiboAccountId(nAccountId);
                commentInfo.setMicrocontentId(nMicroContentId);
                commentInfo.setCrUser(loginUser);
                commentInfo.setCrTime(creatTime);
                commentInfo.setPlatform(sPlatform);
                commentInfo.insert();
            }
            catch (WCMException e) {
                try {
                    throw new WCMException("\u4fdd\u5b58\u8bc4\u8bba\u4fe1\u606f\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38", e);
                }
                catch (WCMException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if ("destroyComment".equalsIgnoreCase(sMethodName) && null != (bIsSuccess = (Boolean)serviceResult) && bIsSuccess.booleanValue()) {
            String nCommentId = methodContext.getValue("CommentId");
            if (null == nCommentId) {
                try {
                    throw new Exception("\u8981\u5220\u9664\u7684\u8bc4\u8bbaID\u4e3a\u7a7a\uff0cCommentId is null\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Connection oConn = null;
            PreparedStatement oPreStmt = null;
            ResultSet oRset = null;
            DBManager dbManager = DBManager.getDBManager();
            String sSql_delete = "delete from XWCMSCMCOMMENTINFO where COMMENTID = ?";
            try {
                oConn = dbManager.getConnection();
                oPreStmt = oConn.prepareStatement("delete from XWCMSCMCOMMENTINFO where COMMENTID = ?");
                oPreStmt.setString(1, nCommentId);
                oPreStmt.executeUpdate();
            }
            catch (Exception e) {
                this.logger.error((Object)"\u8bf7\u68c0\u67e5\u76d1\u542c\u5668[CreateAndDestroyListenerForScmCommon]\u4e2dsSql_delete\u8bed\u53e5\u662f\u5426\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\uff0c\u4e0d\u652f\u6301\u7684\u8bdd\u8bf7\u53e6\u52a0\u8bed\u53e5\u6216\u5176\u5b83\u539f\u56e0", (Throwable)e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != oRset) {
                        oRset.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"Failed to close oRset", (Throwable)e);
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (null != oPreStmt) {
                            oPreStmt.close();
                        }
                    }
                    catch (Exception e2) {
                        this.logger.error((Object)"Failed to close oPreStmt", (Throwable)e2);
                        e2.printStackTrace();
                    }
                    finally {
                        try {
                            if (null != oConn) {
                                oConn.close();
                            }
                        }
                        catch (Exception e3) {
                            this.logger.error((Object)"Failed to close oConn", (Throwable)e3);
                            e3.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

