/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4FolderHostBase;
import com.trs.infra.common.WCMException;
import java.util.ArrayList;
import java.util.List;

public class TagPreNextChannelsParser
extends WCMTagParser4FolderHostBase
implements ITagParser4List {
    private List m_channels;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_PRENEXTCHNLS");
            tagBeanInfo.setDesc("\u524d\u540e\u680f\u76ee\u96c6\u5408");
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("NEXT");
            tbai.setDesc("\u53d6\u540e\u4e00\u4e2a\u680f\u76ee");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tbai);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.m_channels = this.find(_context);
        try {
            this.m_nextRecordContext = new PublishTagContext(_context, this.m_tagItem, this);
            String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, _context, this);
            return stringArray;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to parse the channels list!", ex);
        }
        finally {
            this.clear();
        }
    }

    private List find(PublishTagContext _context) throws WCMException {
        ArrayList<Channel> r = new ArrayList<Channel>(1);
        BaseChannel current = super.findHost(_context, true);
        if (current == null || current.getWCMType() != 101) {
            return r;
        }
        Channel channel = (Channel)current;
        List<Channel> brothers = channel.getHost().getChildren(null);
        int currIndex = brothers.indexOf(channel);
        if (currIndex == -1) {
            return r;
        }
        currIndex = _context.getAttribute("NEXT", false) ? ++currIndex : --currIndex;
        if (currIndex < 0 || currIndex >= brothers.size()) {
            return r;
        }
        r.add(brothers.get(currIndex));
        return r;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_channels != null) {
            this.m_channels = null;
            this.m_nCurrPos = 0;
            this.m_nextRecordContext = null;
        }
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public int getRecordSize() {
        return this.m_channels == null ? 0 : this.m_channels.size();
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl folder = new PublishFolderChannelImpl(channel);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(folder);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl folder = new PublishFolderChannelImpl(channel);
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(folder);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    protected int getQuoteType() {
        return 5;
    }
}

