/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.logo;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.publish.logo.Logos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;

public class Logo
extends CMSObj {
    public static final int OBJ_TYPE = 1718600976;
    public static final String DB_TABLE_NAME = "XWCMLOGO";
    public static final String DB_ID_NAME = "LOGOID";
    static final String MOVE_FORWORD_SQL = "update XWCMLogo set LogoOrder=LogoOrder+1 where HostType=? and HostId=? and LogoOrder>=? and LogoOrder<?";
    static final String MOVE_AFTER_SQL = "update XWCMLogo set LogoOrder=LogoOrder-1 where HostType=? and HostId=? and LogoOrder<=? and LogoOrder>?";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1718600976;
    }

    public boolean isUpdated() {
        return this.getPropertyAsBoolean("UPDATED", true);
    }

    public boolean setUpdated(boolean _bUpdated) throws WCMException {
        return this.setProperty("UPDATED", _bUpdated);
    }

    public int getHostType() {
        return this.getPropertyAsInt("HOSTTYPE", 0);
    }

    public boolean setHostType(int _nHostType) throws WCMException {
        return this.setProperty("HOSTTYPE", _nHostType);
    }

    public int getHostId() {
        return this.getPropertyAsInt("HOSTID", 0);
    }

    public boolean setHostId(int _nHostId) throws WCMException {
        return this.setProperty("HOSTID", _nHostId);
    }

    public String getFileName() {
        return this.getPropertyAsString("FILENAME");
    }

    public boolean setFileName(String _sFileName) throws WCMException {
        return this.setProperty("FILENAME", _sFileName);
    }

    public int getLogoOrder() {
        return this.getPropertyAsInt("LOGOORDER", 0);
    }

    public boolean setLogoOrder(int _nLogoOrder) throws WCMException {
        return this.setProperty("LOGOORDER", _nLogoOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sNewFielName = null;
        if (this.isAddMode()) {
            if (this.getProperty("HOSTTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Logo.class, "Logo.label1", "\u5c5e\u6027HostType\u6ca1\u6709\u8bbe\u7f6e(Logo.isValid)"));
            }
            if (this.getProperty("HOSTID") == null) {
                throw new WCMException(1106, I18NMessage.get(Logo.class, "Logo.label2", "\u5c5e\u6027HostId\u6ca1\u6709\u8bbe\u7f6e(Logo.isValid)"));
            }
            if (this.getProperty("FILENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Logo.class, "Logo.label3", "\u5c5e\u6027FileName\u6ca1\u6709\u8bbe\u7f6e(Logo.isValid)"));
            }
            sNewFielName = this.getFileName();
            if (this.getProperty("LOGOORDER") == null) {
                String sQueryMaxOrderSQL = "select max(LogoOrder) from XWCMLOGO where HostType=? and HostId=?";
                int nNewOrder = DBManager.getDBManager().sqlExecuteIntQuery("select max(LogoOrder) from XWCMLOGO where HostType=? and HostId=?", new int[]{this.getHostType(), this.getHostId()});
                if (nNewOrder < 0) {
                    nNewOrder = 0;
                }
                this.setLogoOrder(++nNewOrder);
            }
            if (sNewFielName != null) {
                sNewFielName = FilesMan.getFilesMan().moveWCMFile(sNewFielName, "P0", false);
                this.setFileName(sNewFielName);
            }
            this.setUpdated(true);
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Logo.class, "Logo.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Logo.isValid)"));
            }
            if (this.isChangeProperty("FILENAME")) {
                sNewFielName = this.getNewPropertyAsString("FILENAME");
            }
            if (this.isChangeProperty("LOGOORDER")) {
                this.changeOrder(this.getNewPropertyAsInt("LOGOORDER", this.getLogoOrder()));
            }
            if (sNewFielName != null) {
                FilesMan filesMan = FilesMan.getFilesMan();
                sNewFielName = filesMan.mapFilePath(sNewFielName, 0) + sNewFielName;
                String sDstFileName = filesMan.mapFilePath(this.getFileName(), 0) + this.getFileName();
                try {
                    CMyFile.copyFile(sNewFielName, sDstFileName);
                    CMyFile.deleteDir(sNewFielName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setFileName(this.getFileName());
                this.setUpdated(true);
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    private void changeOrder(int _nNewOrder) throws WCMException {
        int nOrder = this.getLogoOrder();
        if (nOrder == _nNewOrder) {
            return;
        }
        int[] pParameters = new int[]{this.getHostType(), this.getHostId(), _nNewOrder, nOrder};
        String[] pUpdateSQL = new String[]{nOrder > _nNewOrder ? MOVE_FORWORD_SQL : MOVE_AFTER_SQL};
        DBManager.getDBManager().sqlExecuteUpdate(pUpdateSQL, pParameters);
    }

    public static final Logo findOf(int _nHostType, int _nHostId, int _nIndex) throws WCMException {
        Logos logos = Logos.findOf(null, _nHostType, _nHostId, null);
        if (logos.size() <= _nIndex) {
            return null;
        }
        return (Logo)logos.getAt(_nIndex);
    }

    public static final Logo findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Logo)BaseObj.findById(Logo.class, _nId);
    }

    public static final Logo createNewInstance() throws WCMException {
        return (Logo)BaseObj.createNewInstance(Logo.class);
    }

    public static final Logo findByKey(Object _oKey) throws WCMException {
        return (Logo)BaseObj.findByKey(Logo.class, _oKey);
    }
}

