/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyleServiceProvider;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleExporter;
import com.trs.components.common.publish.widget.ResourceStyleImporter;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ResourceStyleServiceProvider
implements IGlueServiceProvider {
    private static transient Logger mLogger = Logger.getLogger(PageStyleServiceProvider.class);
    private IResourceStyleMgr m_oResourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
    private IStyleCenterMgr m_oStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
    private Reports m_copyReports;
    public static final int SYSTEMPAGESTYLEID = 0;
    public static final int PAGESTYLECOUNTONLY = 2;

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sResourceStyleIds = context.getObjectIds();
        ResourceStyles resourceStyles = ResourceStyles.findByIds(loginUser, sResourceStyleIds);
        HttpServletRequest oRequest = context.getServiceContext().getRequest();
        HttpSession hsSession = null;
        if (oRequest != null) {
            hsSession = oRequest.getSession();
        }
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            boolean bHasRight = SpecialAuthServer.hasRight(loginUser, resourceStyle, 13);
            if (!bHasRight) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u98ce\u683c\u3010" + resourceStyle.getStyleDesc() + "\u3011\uff01");
            }
            if (resourceStyle.getPageStyleId() == 0) {
                this.m_oStyleCenterMgr.setResourceStylePrivate(resourceStyle);
            }
            String sResourceStyleName = resourceStyle.getStyleName();
            WCMFilter filter = new WCMFilter("", "StyleName=?", " PageStyleId desc");
            filter.addSearchValues(sResourceStyleName);
            ResourceStyles currentResourceStyles = ResourceStyles.openWCMObjs(loginUser, filter);
            if (currentResourceStyles.size() == 2 && ((ResourceStyle)currentResourceStyles.getAt(1)).getPageStyleId() == 0) {
                this.m_oResourceStyleMgr.delete(loginUser, (ResourceStyle)currentResourceStyles.getAt(1));
            }
            if (hsSession != null) {
                hsSession.setAttribute("currentPageStyle", (Object)("\u5220\u9664\u8d44\u6e90\u98ce\u683c\u3010" + resourceStyle.getProperty("STYLEDESC") + "\u3011\uff0c"));
            }
            try {
                this.m_oResourceStyleMgr.delete(loginUser, resourceStyle);
                continue;
            }
            catch (Exception e) {
                if (hsSession == null) continue;
                hsSession.setAttribute("ErrorInfo", (Object)e.getStackTrace());
            }
        }
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        WCMFilter extraFilter = new WCMFilter(context.getQueryFilter());
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.query(pageStyle, extraFilter);
        for (int i = resourceStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            ResourceStyle esourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (esourceStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, esourceStyle, 4))) continue;
            resourceStyles.removeAt(i, false);
        }
        return resourceStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext context) throws Throwable {
        String sCssFlag;
        PageStyle oPageStyle;
        int nRightIndex;
        boolean bHasRight;
        User loginUser = this.getLoginUser();
        int nResourceStyleId = context.getObjectId();
        int nPageStyleId = context.getValue("PageStyleId", -1);
        ResourceStyle resourceStyle = null;
        if (nResourceStyleId > 0) {
            resourceStyle = ResourceStyle.findById(nResourceStyleId);
            if (resourceStyle == null) {
                throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + nResourceStyleId + "]");
            }
        } else {
            resourceStyle = new ResourceStyle();
        }
        if (!(bHasRight = SpecialAuthServer.hasRight(loginUser, resourceStyle, nRightIndex = nResourceStyleId > 0 ? 12 : 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (nPageStyleId > 0 ? "\u4fee\u6539\u98ce\u683c\u3010" + resourceStyle.getStyleDesc() + "\u3011\uff01" : "\u65b0\u5efa\u98ce\u683c\uff01"));
        }
        String[] pLogicFields = new String[]{"ObjectId", "StyleItemXML", "CopyToSystemResourceStyle"};
        resourceStyle = (ResourceStyle)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, resourceStyle, pLogicFields);
        if (nResourceStyleId == 0) {
            if (nPageStyleId == 0) {
                resourceStyle.setIsPrivate(0);
            } else {
                resourceStyle.setIsPrivate(1);
            }
        }
        if (!this.m_oResourceStyleMgr.checkCssFlag(oPageStyle = PageStyle.findById(nPageStyleId), resourceStyle, sCssFlag = resourceStyle.getPropertyAsString("CssFlag"))) {
            throw new WCMException(1008, "\u5728\u5f53\u524d\u9875\u9762\u98ce\u683c\u4e0b\u5df2\u7ecf\u5b58\u5728\u98ce\u683c\u6807\u8bc6\u4e3a[" + sCssFlag + "]\u7684\u8d44\u6e90\u98ce\u683c.");
        }
        String sStyleName = resourceStyle.getPropertyAsString("StyleName");
        if (!this.m_oResourceStyleMgr.checkStyleName(oPageStyle, resourceStyle, sStyleName)) {
            throw new WCMException(1008, "\u5728\u5f53\u524d\u9875\u9762\u98ce\u683c\u4e0b\u5df2\u7ecf\u5b58\u5728\u98ce\u683c\u540d\u79f0\u4e3a[" + sStyleName + "]\u7684\u8d44\u6e90\u98ce\u683c.");
        }
        this.m_oResourceStyleMgr.save(loginUser, resourceStyle);
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(context.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnuseStyleItems(resourceStyle, xmlToCMSObj.getObjectIds());
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.save(loginUser, resourceStyle, styleItem);
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
        if (nResourceStyleId == 0 && nPageStyleId != 0) {
            this.m_oResourceStyleMgr.copy(this.getLoginUser(), null, resourceStyle);
        }
        if (nPageStyleId == 0 && nResourceStyleId == 0) {
            this.m_oStyleCenterMgr.copyToAllPageSylte(resourceStyle);
        }
        try {
            if (nPageStyleId != 0) {
                this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), PageStyle.findById(nPageStyleId));
            }
        }
        catch (WCMException ex) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + ex));
        }
        return resourceStyle.getId();
    }

    public int saveStyleThumb(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nResourceStyleId = context.getObjectId();
        String sStyleThumb = context.getValue("StyleThumb");
        ResourceStyle resourceStyle = ResourceStyle.findById(nResourceStyleId);
        if (resourceStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + nResourceStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, resourceStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + resourceStyle.getStyleDesc() + "\u3011\uff01");
        }
        resourceStyle.setStyleThumb(sStyleThumb);
        this.m_oResourceStyleMgr.save(this.getLoginUser(), resourceStyle);
        this.m_oStyleCenterMgr.saveStyleThumb(sStyleThumb);
        WCMFilter aFilter = new WCMFilter("", "PAGESTYLEID=0 AND CSSFLAG=?", "");
        aFilter.addSearchValues(resourceStyle.getCssFlag());
        ResourceStyles oResourceStyles = ResourceStyles.openWCMObjs(loginUser, aFilter);
        if (oResourceStyles.size() > 0) {
            ResourceStyle oSysResourceStyle = (ResourceStyle)oResourceStyles.getAt(0);
            oSysResourceStyle.setStyleThumb(sStyleThumb);
            oSysResourceStyle.save(loginUser);
        }
        return resourceStyle.getId();
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return ResourceStyle.findById(context.getObjectId());
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return ResourceStyles.findByIds(this.getLoginUser(), context.getObjectIds());
    }

    public String copy(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSourceResourceStyleId = context.getValue("SourceResourceStyleId", -1);
        String sTargetPageStyleIds = context.getValue("TargetPageStyleIds");
        int nCopyMode = context.getValue("CopyMode", 1);
        ResourceStyle sourceResourceStyle = ResourceStyle.findById(nSourceResourceStyleId);
        if (sourceResourceStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01SourceResourceStyleId=[" + nSourceResourceStyleId + "]");
        }
        this.m_copyReports = new Reports("");
        int[] arId = CMyString.splitToInt(sTargetPageStyleIds, ",");
        int nCount = arId.length;
        int[] copyIds = new int[nCount];
        for (int i = 0; i < nCount; ++i) {
            boolean bHasRight;
            int nTargetPageStyleId = arId[i];
            PageStyle targetPageStyle = PageStyle.findById(nTargetPageStyleId);
            if (nTargetPageStyleId > 0 && targetPageStyle == null || !(bHasRight = SpecialAuthServer.hasRight(loginUser, sourceResourceStyle, 11))) continue;
            ResourceStyle copyResourceStyle = this.m_oResourceStyleMgr.copy(this.getLoginUser(), targetPageStyle, sourceResourceStyle, nCopyMode, this.m_copyReports);
            try {
                if (nTargetPageStyleId > 0 && targetPageStyle != null) {
                    this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), targetPageStyle);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            copyIds[i] = copyResourceStyle == null ? 0 : copyResourceStyle.getId();
        }
        this.setReportsTitle();
        return this.m_copyReports.toJSONXML();
    }

    public String makePreviewCssContent(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nResourceStyleId = _context.getObjectId();
        ResourceStyle resourceStyle = ResourceStyle.findById(nResourceStyleId);
        if (resourceStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + nResourceStyleId + "]");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, resourceStyle, 14);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + resourceStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.makePreviewCssContent(resourceStyle);
    }

    public boolean checkCssFlag(MethodContext _context) throws Throwable {
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        String sCssFlag = _context.getValue("CssFlag");
        int nCurrResourceStyleId = _context.getValue("CurrResourceStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        ResourceStyle resourceStyle = ResourceStyle.findById(nCurrResourceStyleId);
        if (sCssFlag.startsWith(".")) {
            sCssFlag = sCssFlag.substring(1);
        }
        return this.m_oResourceStyleMgr.checkCssFlag(pageStyle, resourceStyle, sCssFlag);
    }

    public ResourceStyles queryResourceStyles(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nPageStyleId = context.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        WCMFilter extraFilter = new WCMFilter(context.getQueryFilter());
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.query(pageStyle, extraFilter);
        for (int i = resourceStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            ResourceStyle esourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (esourceStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, esourceStyle, 4))) continue;
            resourceStyles.removeAt(i, false);
        }
        return resourceStyles;
    }

    public String previewStyle(MethodContext _context) throws Throwable {
        boolean bHasRight;
        User loginUser = this.getLoginUser();
        int nResourceStyleId = _context.getObjectId();
        String sCssFlag = _context.getValue("CssFlag");
        String sTemplateName = _context.getValue("Template");
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        ResourceStyle resourceStyle = ResourceStyle.findById(nResourceStyleId);
        if (resourceStyle != null && !(bHasRight = SpecialAuthServer.hasRight(loginUser, resourceStyle, 14))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + resourceStyle.getStyleDesc() + "\u3011\uff01");
        }
        String sCustomStyle = _context.getValue("CustomStyle");
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new StyleItem());
        xmlToCMSObj.parse(_context.getValue("StyleItemXML"));
        StyleItems styleItems = StyleItems.createNewInstance(loginUser);
        int nSize = xmlToCMSObj.getCMSObjs().length;
        for (int i = 0; i < nSize; ++i) {
            StyleItem styleItem = (StyleItem)xmlToCMSObj.getCMSObjs()[i];
            if (styleItem == null) continue;
            styleItem.setId(i + 1);
            styleItem.setAddMode(false);
            styleItem.setStyleObjId(nResourceStyleId);
            styleItem.setStyleObjType(1004807208);
            styleItems.addElement(styleItem);
        }
        return this.m_oStyleCenterMgr.previewStyle(pageStyle, sCssFlag, sTemplateName, styleItems, sCustomStyle);
    }

    public HashMap findCssFlagUsedInfo(MethodContext _context) throws Throwable {
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        String sCssFlag = _context.getValue("CssFlag");
        int nCurrResourceStyleId = _context.getValue("CurrResourceStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        ResourceStyle resourceStyle = ResourceStyle.findById(nCurrResourceStyleId);
        if (nCurrResourceStyleId > 0 && resourceStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + nCurrResourceStyleId + "]");
        }
        if (sCssFlag.startsWith(".")) {
            sCssFlag = sCssFlag.substring(1);
        }
        HashMap hmStylesOfCssFlag = this.m_oStyleCenterMgr.findCssFlagUsedStyles(pageStyle, resourceStyle, sCssFlag);
        return hmStylesOfCssFlag;
    }

    public HashMap findStyleNameUsedInfo(MethodContext _context) throws Throwable {
        int nPageStyleId = _context.getValue("PageStyleId", -1);
        String sCssFlag = _context.getValue("StyleName");
        int nCurrResourceStyleId = _context.getValue("CurrResourceStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        ResourceStyle resourceStyle = ResourceStyle.findById(nCurrResourceStyleId);
        if (nCurrResourceStyleId > 0 && resourceStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + nCurrResourceStyleId + "]");
        }
        if (sCssFlag.startsWith(".")) {
            sCssFlag = sCssFlag.substring(1);
        }
        HashMap hmStylesOfCssFlag = this.m_oStyleCenterMgr.findStyleNameUsedStyles(pageStyle, resourceStyle, sCssFlag);
        return hmStylesOfCssFlag;
    }

    public boolean checkCssFlagOrNameCanUse(MethodContext _context) throws WCMException {
        int nPageStyleId = _context.getValue("PageStyleId", 0);
        PageStyle oPageStyle = PageStyle.findById(nPageStyleId);
        if (nPageStyleId > 0 && oPageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + nPageStyleId + "]");
        }
        String sCssFlag = _context.getValue("CssFlag");
        String sStyleName = _context.getValue("StyleName");
        if (CMyString.isEmpty(sCssFlag) && CMyString.isEmpty(sStyleName)) {
            throw new WCMException("\u98ce\u683c\u6807\u8bc6\u3010CssFlag\u3011\u548c\u98ce\u683c\u540d\u79f0\u3010StyleName\u3011\u5fc5\u987b\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\uff01");
        }
        HashMap hmStylesOfCssFlag = this.m_oStyleCenterMgr.findCssFlagUsedStyles(oPageStyle, null, sCssFlag);
        ResourceStyles resourceStyles = (ResourceStyles)hmStylesOfCssFlag.get("ResourceStyles");
        if (resourceStyles.size() > 0) {
            return false;
        }
        HashMap hmStylesOfStyleName = this.m_oStyleCenterMgr.findStyleNameUsedStyles(oPageStyle, null, sStyleName);
        resourceStyles = (ResourceStyles)hmStylesOfStyleName.get("ResourceStyles");
        return resourceStyles.size() <= 0;
    }

    public void resetResourceStyle(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nCurrResourceStyleId = _oContext.getValue("ResourceStyleId", 0);
        if (nCurrResourceStyleId <= 0) {
            throw new WCMException("\u4f20\u5165\u7684ResourceStyleId[" + nCurrResourceStyleId + "]\u5e94\u8be5\u5927\u4e8e0\uff01");
        }
        ResourceStyle oCurrResourceStyle = ResourceStyle.findById(nCurrResourceStyleId);
        if (oCurrResourceStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c[id\uff1a" + nCurrResourceStyleId + "]\u5931\u8d25\uff01");
        }
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, oCurrResourceStyle, 12);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + oCurrResourceStyle.getStyleDesc() + "\u3011\uff01");
        }
        this.m_oStyleCenterMgr.resetStyle(oCurrResourceStyle);
    }

    public String exportResourceStyleZip(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sResourceStyleIds = context.getObjectIds();
        int nPageStyleId = context.getValue("PageStyleId", 0);
        ResourceStyles resourceStyles = ResourceStyles.findByIds(loginUser, sResourceStyleIds);
        for (int i = resourceStyles.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, resourceStyle, 4))) continue;
            resourceStyles.removeAt(i, false);
        }
        ResourceStyleExporter resourceStyleExporter = (ResourceStyleExporter)DreamFactory.createObjectById("ResourceStyleExporter");
        return resourceStyleExporter.export(resourceStyles, nPageStyleId);
    }

    public Reports importResourceStyleZip(MethodContext context) throws Throwable {
        String sResourceStyleZipFile = context.getValue("ResourceStyleZipFile");
        if (sResourceStyleZipFile == null) {
            throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
        }
        int nPageStyleId = context.getValue("PageStyleId", 0);
        int nImportMode = context.getValue("ImportMode", 1);
        ResourceStyleImporter resourceStyleImporter = (ResourceStyleImporter)DreamFactory.createObjectById("ResourceStyleImporter");
        Reports importReports = resourceStyleImporter.importFromFile(sResourceStyleZipFile, nImportMode, nPageStyleId);
        return importReports;
    }

    private void setReportsTitle() {
        int nSuccessed = this.m_copyReports.getSucessedReporter().size();
        this.m_copyReports.setTitle(CMyString.format("\u5171\u5904\u7406{0}\u4e2a\u98ce\u683c", new int[]{nSuccessed}));
    }
}

