/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WCMHandler
extends DefaultHandler {
    private static Logger s_logger = Logger.getLogger(WCMHandler.class);
    private CMSObj m_oWCMObj;
    private StringBuffer m_sbValue;
    private boolean m_bParseObjProp;
    private String m_sWCMObjTagName = "WCMOBJ";
    private boolean m_bParasingObj = false;

    public WCMHandler(CMSObj _obj) {
        this.m_oWCMObj = _obj;
        this.m_bParseObjProp = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ((qName = qName.toUpperCase()).equals(this.m_sWCMObjTagName) || qName.equals(this.m_oWCMObj.getDbTableName())) {
            this.m_bParasingObj = true;
            return;
        }
        if (this.m_bParasingObj && qName.equals("PROPERTIES")) {
            this.m_bParseObjProp = true;
            this.m_sbValue = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_bParseObjProp && this.m_sbValue != null) {
            this.m_sbValue.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((qName = qName.toUpperCase()).equals("PROPERTIES")) {
            this.m_bParseObjProp = false;
            return;
        }
        if (qName.equals(this.m_sWCMObjTagName) || qName.equals(this.m_oWCMObj.getDbTableName())) {
            this.m_bParasingObj = false;
            return;
        }
        if (this.m_bParseObjProp) {
            try {
                String sValue = this.m_sbValue.toString();
                if (qName.equalsIgnoreCase("RIGHTVALUE")) {
                    CMyBitsValue aValue = new CMyBitsValue(sValue);
                    this.m_oWCMObj.setProperty(qName, aValue.getValue());
                } else {
                    this.m_oWCMObj.setPropertyWithString(qName, this.checkPropertyValue(sValue));
                }
            }
            catch (Exception e) {
                s_logger.error((Object)(I18NMessage.get(WCMHandler.class, "WCMHandler.label1", "\u8bbe\u7f6e[") + qName.toUpperCase() + I18NMessage.get(WCMHandler.class, "WCMHandler.label2", "]\u5c5e\u6027\u5931\u8d25\uff01")), (Throwable)e);
                throw new SAXException(I18NMessage.get(WCMHandler.class, "WCMHandler.label1", "\u8bbe\u7f6e[") + qName.toUpperCase() + I18NMessage.get(WCMHandler.class, "WCMHandler.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
            }
            finally {
                this.m_sbValue.delete(0, this.m_sbValue.length());
            }
        }
    }

    public CMSObj getWCMObj() {
        return this.m_oWCMObj;
    }

    private String checkPropertyValue(String _sValue) {
        if (_sValue == null) {
            return _sValue;
        }
        if (_sValue.length() < 1) {
            return _sValue;
        }
        if (_sValue.charAt(0) == '`' && _sValue.charAt(_sValue.length() - 1) == '`') {
            return CMyString.decodeForCDATA(_sValue.substring(1, _sValue.length() - 1));
        }
        return _sValue;
    }
}

