/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.Duration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public class DateUtil {
    static final String STR_YYYYMMDD_HH = "yyyy-MM-dd HH";
    private static final String DEFAULT_TIME_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String FMT_TRS_yMdHm = "yyyy.MM.dd HH:mm";
    public static final String FMT_TRS_yMd = "yyyy.MM.dd";
    public static final long ONE_DAY_SECONDS = 86400L;
    public static final long ONE_HOUR_SCONDS = 3600L;
    public static final long ONE_MINUTE_SCONDS = 60L;
    public static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat TIMEAREA_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH");
    public static final SimpleDateFormat TIMEAREA_MIN_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static final long getDateAsMillis(String time, String pattern) {
        if (time == null) {
            return -1L;
        }
        Date theTime = DateUtil.stringToDate(time, pattern == null ? DEFAULT_TIME_PATTERN : pattern);
        if (theTime == null) {
            return -1L;
        }
        return theTime.getTime();
    }

    public static String timeToString(long msUsed) {
        if (msUsed < 0L) {
            return String.valueOf(msUsed);
        }
        if (msUsed < 1000L) {
            return String.valueOf(String.valueOf(msUsed)) + "\u6beb\u79d2";
        }
        if ((msUsed /= 1000L) < 60L) {
            return String.valueOf(String.valueOf(msUsed)) + "\u79d2";
        }
        if (msUsed < 3600L) {
            long nMinute = msUsed / 60L;
            long nSecond = msUsed % 60L;
            return String.valueOf(String.valueOf(nMinute)) + "\u5206" + String.valueOf(nSecond) + "\u79d2";
        }
        if (msUsed < 86400L) {
            long nHour = msUsed / 3600L;
            long nMinute = (msUsed - nHour * 3600L) / 60L;
            long nSecond = (msUsed - nHour * 3600L) % 60L;
            return String.valueOf(String.valueOf(nHour)) + "\u5c0f\u65f6" + String.valueOf(nMinute) + "\u5206" + String.valueOf(nSecond) + "\u79d2";
        }
        long nDay = msUsed / 86400L;
        long nHour = (msUsed - nDay * 86400L) / 3600L;
        long nMinute = (msUsed - nDay * 86400L - nHour * 3600L) / 60L;
        long nSecond = (msUsed - nDay * 86400L - nHour * 3600L) % 60L;
        return String.valueOf(String.valueOf(nDay)) + "\u5929" + String.valueOf(nHour) + "\u5c0f\u65f6" + String.valueOf(nMinute) + "\u5206" + String.valueOf(nSecond) + "\u79d2";
    }

    public static String secondsToHMS(int seconds) {
        return new Duration(seconds).defaultShow();
    }

    public static Calendar getThisMonday() {
        return DateUtil.getThatMonday(Calendar.getInstance());
    }

    public static Calendar getThatMonday(Calendar cal) {
        int n = cal.get(7) - 2;
        cal.add(5, n);
        return cal;
    }

    public static Calendar getThisSunday() {
        return DateUtil.getThatSunday(Calendar.getInstance());
    }

    public static Calendar getThatSunday(Calendar cal) {
        int n = 8 - cal.get(7);
        cal.add(5, n);
        return cal;
    }

    public static int minus(Calendar cal1, Calendar cal2) {
        if (cal1.after(cal2)) {
            int nBase = (cal1.get(1) - cal2.get(1)) * 365;
            return nBase + cal1.get(6) - cal2.get(6);
        }
        return DateUtil.minus(cal2, cal1);
    }

    public static int getThisYear() {
        return DateUtil.getYear(System.currentTimeMillis());
    }

    public static int getYear(long timestamp) {
        Date now = new Date(timestamp);
        Calendar cal = DateUtil.toCalendar(now);
        return cal.get(1);
    }

    public static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal;
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static Date stringToDate(String dateString, String dateFormat) {
        if ("".equals(dateString) || dateString == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(dateFormat).parse(dateString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar getCalendar(Calendar cal, int relativeDay) {
        cal.add(5, relativeDay);
        return cal;
    }

    public static Date getDate(int relativeDay) {
        return DateUtil.getCalendar(Calendar.getInstance(), relativeDay).getTime();
    }

    public static String date2String(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDateClose(Date date, Date baseDate, int seconds) {
        long m_time = date.getTime();
        long b_time = baseDate.getTime();
        long ms = seconds * 1000;
        if (m_time == b_time) {
            return true;
        }
        if (m_time > b_time) {
            return b_time + ms > m_time;
        }
        if (m_time < b_time) {
            return m_time + ms > b_time;
        }
        return true;
    }

    public static final long getDateAsMillis(String time, String pattern, int deltaDay) {
        if (time == null) {
            return -1L;
        }
        Date theTime = DateUtil.stringToDate(time, pattern == null ? DEFAULT_TIME_PATTERN : pattern);
        if (theTime == null) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theTime);
        calendar.add(5, deltaDay);
        return theTime.getTime();
    }

    public static final long getDateAsMillis(String time) {
        return DateUtil.getDateAsMillis(time, DEFAULT_TIME_PATTERN);
    }

    public static final String date2String(Date date) {
        return DateUtil.date2String(date, DEFAULT_TIME_PATTERN);
    }

    public static final String millis2String(long dateMillis, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(dateMillis));
    }

    public static final long getMonthStartAsMillis(String date, String pattern) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.stringToDate(date, pattern));
        cal.set(5, 1);
        return cal.getTime().getTime();
    }

    public static final long getMonthEndAsMillis(String date, String pattern) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.stringToDate(date, pattern));
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getTime().getTime();
    }

    public static final long getDayEndAsMillis(String date, String pattern) {
        Calendar current = DateUtil.toCalendar(DateUtil.stringToDate(date, pattern));
        current.roll(5, true);
        return current.getTimeInMillis();
    }

    public static final long getDayDurationAsMillis(int duration) {
        Calendar current = Calendar.getInstance();
        Calendar nextDay = Calendar.getInstance();
        nextDay.set(5, current.get(5) + duration);
        nextDay.set(10, 0);
        nextDay.set(12, 0);
        nextDay.set(13, 0);
        return nextDay.getTimeInMillis() - current.getTimeInMillis();
    }

    public static final long getHourDurationAsMillis(int duration) {
        Calendar current = Calendar.getInstance();
        Calendar nextHour = Calendar.getInstance();
        nextHour.set(10, current.get(10) + duration);
        nextHour.set(12, 0);
        nextHour.set(13, 0);
        return nextHour.getTimeInMillis() - current.getTimeInMillis();
    }

    public static final long getDayStartAsMillis(String date, String pattern) {
        Calendar current = DateUtil.toCalendar(DateUtil.stringToDate(date, pattern));
        current.roll(5, true);
        return current.getTimeInMillis();
    }

    public static long getMillisForDeltaDay(int deltaDay) {
        long deltaMillis = deltaDay * 1000 * 60 * 60 * 24;
        return System.currentTimeMillis() - deltaMillis;
    }

    public static String formatMillisMin(long timeMillis) {
        return TIMEAREA_MIN_FORMAT.format(new Date(timeMillis));
    }

    public static String formatMillis(long timeMillis) {
        return DEFAULT_FORMAT.format(new Date(timeMillis));
    }

    public static String formatTimeArea(long timeMillis) {
        return TIMEAREA_FORMAT.format(new Date(timeMillis));
    }

    public static String formatMillis2Date(long timeMillis) {
        return DATE_FORMAT.format(new Date(timeMillis));
    }

    public static String formatMillis2Time(long timeMillis) {
        return TIME_FORMAT.format(new Date(timeMillis));
    }

    public static String formatMillis(long timeMillis, String format) {
        return DateUtil.formatMillis(timeMillis, format, Locale.SIMPLIFIED_CHINESE);
    }

    public static String formatMillis(long timeMillis, String format, Locale locale) {
        SimpleDateFormat sdf = locale == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, locale);
        return sdf.format(new Date(timeMillis));
    }

    public static long formatDate2Millis(String date) {
        try {
            return DATE_FORMAT.parse(date).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static long formatTimeArea(String sDate) {
        Date date = null;
        try {
            date = TIMEAREA_FORMAT.parse(sDate);
            return date.getTime();
        }
        catch (NumberFormatException e) {
            throw new WrappedException("fail to parse date! sDate=" + sDate + ", pattern: " + TIMEAREA_FORMAT, e);
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static long formatDateTime(String dateTime) {
        try {
            return DEFAULT_FORMAT.parse(dateTime).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static Date format(String dateTime) {
        try {
            return DEFAULT_FORMAT.parse(dateTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String format2String(Date date) {
        return DEFAULT_FORMAT.format(date);
    }

    public static long formatDateTime(String dateTime, long defaultValue) {
        try {
            return DEFAULT_FORMAT.parse(dateTime).getTime();
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static String formatMillisWithDefaultValue(long timeMillis, String defaultValue) {
        return timeMillis < 0L ? defaultValue : DEFAULT_FORMAT.format(new Date(timeMillis));
    }

    public static Date millis2DateType(long millis) {
        return millis < 0L ? null : new Date(millis);
    }

    public static String getCurrentDateTime() {
        return DateUtil.formatMillis(System.currentTimeMillis());
    }

    public static Calendar getCalendar(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        return calendar;
    }

    public static int getMondayPlus(long date) {
        Calendar cd = Calendar.getInstance();
        cd.setTimeInMillis(date);
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static long getPreviousWeekday(long date) {
        int weeks = -1;
        int mondayPlus = DateUtil.getMondayPlus(date);
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTimeInMillis(date);
        currentDate.add(5, mondayPlus + 7 * weeks);
        return currentDate.getTimeInMillis();
    }

    public static long getMondayOFWeek(long date) {
        int mondayPlus = DateUtil.getMondayPlus(date);
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTimeInMillis(date);
        currentDate.add(5, mondayPlus);
        return currentDate.getTimeInMillis();
    }

    public static long getPreviousMonthFirst(long date) {
        Calendar lastDate = Calendar.getInstance();
        lastDate.setTimeInMillis(date);
        lastDate.set(5, 1);
        lastDate.add(2, -1);
        return lastDate.getTimeInMillis();
    }

    public static long getFirstDayOfMonth(long date) {
        Calendar lastDate = Calendar.getInstance();
        lastDate.setTimeInMillis(date);
        lastDate.set(5, 1);
        return lastDate.getTimeInMillis();
    }

    public static String nowAsLongFormat() {
        return DateUtil.formatMillis(DateUtil.getCurrentTimeMillis(), "yyyy\u5e74MM\u6708dd\u65e5 E");
    }

    public static String format2String(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static long getTodayRemainAsSecond() {
        return (DateUtil.getNextDayBeginAsMillis() - DateUtil.getCurrentTimeMillis()) / 1000L;
    }

    public static long getCurrentHourRemainAsSecond() {
        return (DateUtil.getNextHourBeginAsMillis() - DateUtil.getCurrentTimeMillis()) / 1000L;
    }

    public static long getNextDayBeginAsMillis() {
        return DateUtil.getNextDayBeginAsMillis(1);
    }

    public static long getNextDayBeginAsMillis(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        return calendar.getTimeInMillis();
    }

    public static long getNextHourBeginAsMillis() {
        return DateUtil.getNextHourBeginAsMillis(1);
    }

    public static long getNextHourBeginAsMillis(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, 1);
        calendar.set(13, 0);
        calendar.set(12, 0);
        return calendar.getTimeInMillis();
    }

    public static Date getDate(Date date, int relativeDay) {
        return DateUtil.getCalendar(DateUtil.toCalendar(date), relativeDay).getTime();
    }

    public static int month2second(int month) {
        return month * 30 * 24 * 3600;
    }

    public static int betweenDays(Calendar begin, Calendar end) {
        long msBegin = begin.getTimeInMillis();
        long msEnd = end.getTimeInMillis();
        long between_days = (msEnd - msBegin) / 86400000L;
        between_days = Math.abs(between_days);
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int minusWithoutAbs(Calendar calBegin, Calendar calEnd) {
        long msBegin = calBegin.getTimeInMillis();
        long msEnd = calEnd.getTimeInMillis();
        long between_days = (msEnd - msBegin) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int minusWithoutAbs(Date begin, Date end) {
        long between_days = (end.getTime() - begin.getTime()) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static boolean isBeforeToday(Date someDate) {
        return DateUtil.minusWithoutAbs(someDate, new Date()) > 0;
    }

    public static boolean isAfterToday(Date date) {
        return DateUtil.minusWithoutAbs(Calendar.getInstance(), DateUtil.toCalendar(date)) > 0;
    }

    public static String formatDate(Date date) {
        return DateUtil.date2String(date, "yyyy-MM-dd");
    }

    public static Date parseDate(String date) {
        return DateUtil.parseDate(date, DateUtil.prepareDefaultPatterns());
    }

    public static Date parseDate(String date, List<String> patterns) {
        if (date == null) {
            return null;
        }
        for (String pattern : patterns) {
            try {
                return new SimpleDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<String> prepareDefaultPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("yyyy-MM-dd");
        patterns.add("yyyy/MM/dd");
        patterns.add("yyyyMMdd");
        return patterns;
    }
}

