/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.utils.DateUtil;
import java.io.Serializable;

public class ApplicationSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private long createdTime = DateUtil.getCurrentTimeMillis();
    private long visitedTime;
    private boolean console;
    private String hostAddress;
    private int userId;
    private String userName;
    private String nickName;
    private String remoteAddr;
    private String verifyCode;
    private long lastModifiedTime = DateUtil.getCurrentTimeMillis();

    public static final ApplicationSession buildAnonymousApplicationSession(String ucsid, String remoteAddr) {
        ApplicationSession as = new ApplicationSession(ucsid);
        as.setNickName("anonymous");
        as.setUserId(-1);
        as.setUserName("anonymous");
        as.setRemoteAddr(remoteAddr);
        as.setCreatedTime(DateUtil.getCurrentTimeMillis());
        return as;
    }

    public ApplicationSession() {
    }

    public ApplicationSession(String ucsid) {
        this.id = ucsid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public long getVisitedTime() {
        return this.visitedTime;
    }

    public void setVisitedTime(long visitedTime) {
        this.visitedTime = visitedTime;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String removeAddr) {
        this.remoteAddr = removeAddr;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public boolean isLogined() {
        return this.userId != -1;
    }

    public void access() {
        this.lastModifiedTime = DateUtil.getCurrentTimeMillis();
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[id=").append(this.id).append(",userName=").append(this.userName).append(",lastModified=").append(this.lastModifiedTime).append("]");
        return builder.toString();
    }

    public long duration() {
        return DateUtil.getCurrentTimeMillis() - this.lastModifiedTime;
    }

    public boolean isTimeouted(long anonymousTTL, long loginedTTL) {
        boolean isTimeouted = false;
        isTimeouted = this.isLogined() ? this.duration() > loginedTTL : this.duration() > anonymousTTL;
        return isTimeouted;
    }

    public boolean isConsole() {
        return this.console;
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }
}

