/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.schedule;

import com.trs.dev4.jdk16.schedule.ISchedulable;
import com.trs.dev4.jdk16.schedule.ScheduleRunner;
import com.trs.dev4.jdk16.schedule.SchedulerFactory;
import com.trs.dev4.jdk16.utils.ClassUtil;
import com.trs.dev4.jdk16.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SchedulablesMgr {
    private static final Logger LOG = Logger.getLogger(SchedulablesMgr.class);
    private Map<String, ScheduledExecutorService> schedulerMap = new HashMap<String, ScheduledExecutorService>();
    private List<ScheduleRunner> runners = new ArrayList<ScheduleRunner>();

    public void start(ISchedulable schedulable, int fixedDelaySeconds) {
        String key = schedulable.getClass().getName();
        if (this.schedulerMap.containsKey(key)) {
            return;
        }
        int poolSize = 1;
        int initialDelay = 10;
        ScheduledExecutorService scheduler = SchedulerFactory.newScheduler(ClassUtil.getSimpleName(schedulable), poolSize);
        this.schedulerMap.put(key, scheduler);
        ScheduleRunner runner = new ScheduleRunner(schedulable, fixedDelaySeconds);
        this.runners.add(runner);
        scheduler.scheduleWithFixedDelay(runner, initialDelay, fixedDelaySeconds, TimeUnit.SECONDS);
    }

    public void stop(ISchedulable schedulable) {
        String key = schedulable.getClass().getName();
        ScheduledExecutorService scheduler = this.schedulerMap.get(key);
        if (scheduler == null) {
            LOG.warn((Object)("no such ScheduledExecutorService: " + key));
            return;
        }
        scheduler.shutdown();
        List<Runnable> runnables = scheduler.shutdownNow();
        if (!CollectionUtil.isEmpty(runnables)) {
            LOG.info((Object)("these tasks were awaiting execution: " + runnables));
        }
        LOG.info((Object)(String.valueOf(key) + " stopped."));
        this.runners.remove(new ScheduleRunner(schedulable, 0));
    }

    public void stopAll() {
        int i = 0;
        while (i < this.runners.size()) {
            ScheduleRunner runner = this.runners.get(i);
            this.stop(runner.getSchedulable());
            ++i;
        }
    }

    public List<ScheduleRunner> listRunners() {
        return this.runners;
    }
}

