/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Header;
import org.apache.soap.Utils;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Envelope {
    public static final String LINE_SEPARATOR = "\n";
    private Header header = null;
    private Body body = null;
    private Vector envelopeEntries = null;
    private AttributeHandler attrHandler = null;
    private static final QName N_SOAP_ENV = new QName("http://www.w3.org/2000/xmlns/", "SOAP-ENV");
    private static final QName N_SCHEMA_XSI = new QName("http://www.w3.org/2000/xmlns/", "xsi");
    private static final QName N_SCHEMA_XSD = new QName("http://www.w3.org/2000/xmlns/", "xsd");
    private static final QName N_ENCOD_STYLE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");

    public Envelope() {
        this.attrHandler = new AttributeHandler();
        this.setAttribute(N_SOAP_ENV, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public Envelope(AttributeHandler attrHandler) {
        this.attrHandler = attrHandler;
    }

    public void setAttribute(QName attrQName, String value) {
        this.attrHandler.setAttribute(attrQName, value);
    }

    public String getAttribute(QName attrQName) {
        return this.attrHandler.getAttribute(attrQName);
    }

    public void removeAttribute(QName attrQName) {
        this.attrHandler.removeAttribute(attrQName);
    }

    public void declareNamespace(String nsPrefix, String namespaceURI) {
        this.attrHandler.declareNamespace(nsPrefix, namespaceURI);
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Body getBody() {
        return this.body;
    }

    public void setEnvelopeEntries(Vector envelopeEntries) {
        this.envelopeEntries = envelopeEntries;
    }

    public Vector getEnvelopeEntries() {
        return this.envelopeEntries;
    }

    public void marshall(Writer sink, XMLJavaMappingRegistry xjmr) throws IllegalArgumentException, IOException {
        this.marshall(sink, xjmr, new SOAPContext());
    }

    public void marshall(Writer sink, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        Body body = this.getBody();
        if (body == null) {
            throw new IllegalArgumentException("An '" + Constants.Q_ELEM_ENVELOPE + "' must contain a: '" + Constants.Q_ELEM_BODY + "'.");
        }
        if (xjmr instanceof SOAPMappingRegistry) {
            String schemaURI = ((SOAPMappingRegistry)xjmr).getSchemaURI();
            this.setAttribute(N_SCHEMA_XSI, schemaURI + "-instance");
            this.setAttribute(N_SCHEMA_XSD, schemaURI);
        } else {
            this.setAttribute(N_SCHEMA_XSI, "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttribute(N_SCHEMA_XSD, "http://www.w3.org/2001/XMLSchema");
        }
        NSStack nsStack = new NSStack();
        this.attrHandler.populateNSStack(nsStack);
        Header header = this.getHeader();
        Vector envelopeEntries = this.getEnvelopeEntries();
        String declEncStyle = this.getAttribute(N_ENCOD_STYLE);
        String soapEnvNSPrefix = this.attrHandler.getUniquePrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV", nsStack);
        sink.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        sink.write(60);
        sink.write(soapEnvNSPrefix);
        sink.write(":Envelope");
        this.attrHandler.marshall(sink, ctx);
        sink.write(">\n");
        if (header != null) {
            header.marshall(sink, nsStack, xjmr, ctx);
        }
        body.marshall(declEncStyle, sink, nsStack, xjmr, ctx);
        if (envelopeEntries != null) {
            Enumeration e = envelopeEntries.elements();
            while (e.hasMoreElements()) {
                Element envelopeEntryEl = (Element)e.nextElement();
                Utils.marshallNode(envelopeEntryEl, sink);
                sink.write(LINE_SEPARATOR);
            }
        }
        sink.write("</");
        sink.write(soapEnvNSPrefix);
        sink.write(":Envelope>\n");
    }

    public static Envelope unmarshall(Node src) throws IllegalArgumentException {
        return Envelope.unmarshall(src, new SOAPContext());
    }

    public static Envelope unmarshall(Node src, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        Envelope env = null;
        if (Constants.Q_ELEM_ENVELOPE.matches(root)) {
            Element headerEl = null;
            Element bodyEl = null;
            Element tempEl = DOMUtils.getFirstChildElement(root);
            if (Constants.Q_ELEM_HEADER.matches(tempEl)) {
                headerEl = tempEl;
                tempEl = DOMUtils.getNextSiblingElement(tempEl);
            }
            if (!Constants.Q_ELEM_BODY.matches(tempEl)) {
                throw new IllegalArgumentException("An '" + Constants.Q_ELEM_ENVELOPE + "' element must contain a: '" + Constants.Q_ELEM_BODY + "' element.");
            }
            bodyEl = tempEl;
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
            env = new Envelope(AttributeHandler.unmarshall(root, ctx));
            if (headerEl != null) {
                env.setHeader(Header.unmarshall(headerEl, ctx));
            }
            env.setBody(Body.unmarshall(bodyEl, ctx));
            if (tempEl != null) {
                Vector<Element> envelopeEntries = new Vector<Element>();
                while (tempEl != null) {
                    envelopeEntries.addElement(tempEl);
                    tempEl = DOMUtils.getNextSiblingElement(tempEl);
                }
                env.setEnvelopeEntries(envelopeEntries);
            }
        } else {
            String localName = root.getLocalName();
            if (localName != null && localName.equals("Envelope")) {
                throw new IllegalArgumentException(Constants.ERR_MSG_VERSION_MISMATCH);
            }
            throw new IllegalArgumentException("Root element of a SOAP message must be: '" + Constants.Q_ELEM_ENVELOPE + "', not '" + root.getNamespaceURI() + ":" + localName + "' (" + root.getNodeName() + ").");
        }
        return env;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Attributes=" + this.attrHandler + "] " + "[Header=" + this.header + "] " + "[Body=" + this.body + "] " + "[EnvelopeEntries=");
        if (this.envelopeEntries != null) {
            pw.println();
            for (int i = 0; i < this.envelopeEntries.size(); ++i) {
                pw.println("[(" + i + ")=" + DOM2Writer.nodeToString((Element)this.envelopeEntries.elementAt(i)) + "]");
            }
        }
        pw.print("]");
        return sw.toString();
    }
}

