/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications;

import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.tags.HTMLLinkTag;
import org.htmlparser.util.DefaultHTMLParserFeedback;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLParserFeedback;

public class Robot {
    private HTMLParser parser;

    public Robot(String resourceLocation) {
        try {
            this.parser = new HTMLParser(resourceLocation, (HTMLParserFeedback)new DefaultHTMLParserFeedback());
            this.parser.registerScanners();
        }
        catch (HTMLParserException e) {
            System.err.println("Error, could not create parser object");
            e.printStackTrace();
        }
    }

    public void crawl(int crawlDepth) throws HTMLParserException {
        try {
            this.crawl(this.parser, crawlDepth);
        }
        catch (HTMLParserException e) {
            throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLParserException at crawl(").append(crawlDepth).append(")"))), e);
        }
    }

    public void crawl(HTMLParser parser, int crawlDepth) throws HTMLParserException {
        System.out.println(" crawlDepth = ".concat(String.valueOf(String.valueOf(crawlDepth))));
        HTMLEnumeration e = parser.elements();
        while (e.hasMoreNodes()) {
            HTMLLinkTag linkTag;
            HTMLNode node = e.nextHTMLNode();
            if (!(node instanceof HTMLLinkTag) || (linkTag = (HTMLLinkTag)node).isMailLink() || linkTag.getLink().toUpperCase().indexOf("HTM") == -1 && linkTag.getLink().toUpperCase().indexOf("COM") == -1 && linkTag.getLink().toUpperCase().indexOf("ORG") == -1) continue;
            if (crawlDepth > 0) {
                HTMLParser newParser = new HTMLParser(linkTag.getLink(), (HTMLParserFeedback)new DefaultHTMLParserFeedback());
                newParser.registerScanners();
                System.out.print("Crawling to ".concat(String.valueOf(String.valueOf(linkTag.getLink()))));
                this.crawl(newParser, crawlDepth - 1);
                continue;
            }
            System.out.println(linkTag.getLink());
        }
    }

    public static void main(String[] args) {
        System.out.println("Robot Crawler v1.2 (Production Release)");
        if (args.length < 2 || args[0].equals("-help")) {
            System.out.println();
            System.out.println("Syntax : java -classpath htmlparser.jar org.htmlparser.parserapplications.Robot <resourceLocn/website> <depth>");
            System.out.println();
            System.out.println("   <resourceLocn> the name of the file to be parsed (with complete path ");
            System.out.println("                  if not in current directory)");
            System.out.println("   <depth> No of links to be followed from each link");
            System.out.println("   -help This screen");
            System.out.println();
            System.out.println("HTML Parser home page : http://htmlparser.sourceforge.net");
            System.out.println();
            System.out.println("Example : java -classpath htmlparser.jar com.kizna.parserapplications.Robot http://www.google.com 3");
            System.out.println();
            System.out.println("If you have any doubts, please join the HTMLParser mailing list (user/developer) from the HTML Parser home page instead of mailing any of the contributors directly. You will be surprised with the quality of open source support. ");
            System.exit(-1);
        }
        String resourceLocation = "";
        int crawlDepth = 1;
        if (args.length != 0) {
            resourceLocation = args[0];
        }
        if (args.length == 2) {
            crawlDepth = Integer.valueOf(args[1]);
        }
        Robot robot = new Robot(resourceLocation);
        System.out.println("Crawling Site ".concat(String.valueOf(String.valueOf(resourceLocation))));
        try {
            robot.crawl(crawlDepth);
        }
        catch (HTMLParserException e) {
            e.printStackTrace();
        }
    }
}

