/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.shell;

import com.trs.net.ftp.shell.Cftp;
import com.trs.net.ftp.shell.Command;
import com.trs.net.ftp.shell.CommandLocal;
import java.util.Arrays;
import java.util.Iterator;

class CommandHelp
extends CommandLocal {
    private String[] m_sCmdArrays = null;

    public CommandHelp() {
        this.setName("help", new String[]{"?", "help"});
        this.setSupported(true);
    }

    private String[] getCmdArrays() {
        if (this.m_sCmdArrays == null) {
            Object[] cmds = new String[Cftp.s_oValidCmds.size()];
            Iterator itr = Cftp.s_oValidCmds.keySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                String name = (String)itr.next();
                if (!this.getCommandByName(name).getSupported()) {
                    name = String.valueOf(name) + "*";
                }
                if (name.length() < 8) {
                    name = String.valueOf(name) + "\t";
                }
                cmds[i] = name;
                ++i;
            }
            Arrays.sort(cmds);
            this.m_sCmdArrays = cmds;
        }
        return this.m_sCmdArrays;
    }

    public void execute(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            String[] cmds = this.getCmdArrays();
            System.out.println("Commands may be abbreviated.  Commands are:");
            System.out.println();
            int i = 0;
            while (i < cmds.length) {
                if (i > 0 && i % 5 == 4) {
                    System.out.println(cmds[i]);
                } else {
                    System.out.print(cmds[i]);
                    System.out.print('\t');
                }
                ++i;
            }
            System.out.println();
            System.out.println("With * means unimplemented");
        } else {
            Command cmd = this.getCommandByName(args[0]);
            if (cmd == null) {
                System.out.print("Invalid help command ");
                System.out.print(args[0]);
                System.out.println('.');
            } else {
                System.out.print(args[0]);
                System.out.print('\t');
                if (args[0].length() < 8) {
                    System.out.print('\t');
                }
                System.out.println(cmd.getHelpInfo());
            }
        }
    }
}

