/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster;

import com.trs.infra.cluster.Address;
import com.trs.infra.cluster.impl.transport.AddressByUDP;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClusterConfig {
    private static final Logger s_logger;
    private final Properties configs = new Properties();
    private boolean enabled;
    private boolean master;
    private String memberName;
    private String memberHost;
    private int magicNumber;
    private InetAddress inetMulticastBind;
    private String multicastBind;
    private InetAddress inetMulticastAddress;
    private String multicastAddress;
    private int multicastPort;
    private int multicastThreadCount;
    private int multicastTTL;
    private InetAddress inetTCPListenAddress;
    private String tcpListenAddress;
    private int tcpListenPort;
    private int tcpBufferSize;
    private int tcpSoTimeout;
    private int tcpThreadCount;
    private InetAddress inetUDPListenAddress;
    private String udpListenAddress;
    private int udpListenPort;
    private int udpBufferSize;
    private int udpSoTimeout;
    private int udpThreadCount;
    private String tracerDirectory;
    private String cookieName;
    private String cookiePath;
    private int cookieTLD;
    private String cookieDomain;
    private String balancerRoute;
    private String balancerSeparator;
    private int sessionTimeout;
    private int sessionLimit;
    private String sessionUnlimitURI;
    private int addressLimit;
    private String addressSpecial;
    private Address[] brotherAddresses;
    private boolean tcpNoDelay;
    private boolean keepAlive;
    private boolean reuseAddress;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.ClusterConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public final void load(File file) {
        block12: {
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(is);
                    this.load(props);
                }
                catch (Exception e) {
                    s_logger.error((Object)("Load cluster config failed, from file:" + file), (Throwable)e);
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public final void load(URL url) {
        block12: {
            InputStream is = null;
            try {
                try {
                    is = url.openStream();
                    Properties props = new Properties();
                    props.load(is);
                    this.load(props);
                }
                catch (Exception e) {
                    s_logger.error((Object)("Load cluster config failed, from url:" + url), (Throwable)e);
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public final void load(Properties map) {
        if (map != null) {
            Iterator<Object> itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                if (!key.startsWith("cluster.")) continue;
                this.configs.setProperty(key, map.getProperty(key));
            }
        }
        this.enabled = this.getConfig("cluster.enabled", true);
        this.master = this.getConfig("cluster.master", true);
        this.memberName = this.getConfig("cluster.memberName");
        this.memberHost = this.getConfig("cluster.memberHost");
        this.magicNumber = this.getConfig("cluster.magicNumber", (short)257);
        this.multicastBind = this.getConfig("cluster.multicastBind", "auto");
        this.multicastAddress = this.getConfig("cluster.multicastAddress", "230.0.0.1");
        this.multicastPort = this.getConfig("cluster.multicastPort", 54321);
        this.multicastThreadCount = this.getConfig("cluster.multicastThreadCount", 2);
        this.multicastTTL = this.getConfig("cluster.multicastTTL", 32);
        this.tcpListenAddress = this.getConfig("cluster.tcpListenAddress", "auto");
        this.tcpListenPort = this.getConfig("cluster.tcpListenPort", 54322);
        this.tcpBufferSize = this.getConfig("cluster.tcpBufferSize", 8196);
        this.tcpSoTimeout = this.getConfig("cluster.tcpSoTimeout", 5000);
        this.tcpThreadCount = this.getConfig("cluster.tcpThreadCount", 5);
        this.udpListenAddress = this.getConfig("cluster.udpListenAddress", "auto");
        this.udpListenPort = this.getConfig("cluster.udpListenPort", 54323);
        this.udpBufferSize = this.getConfig("cluster.udpBufferSize", 8196);
        this.udpSoTimeout = this.getConfig("cluster.udpSoTimeout", 5000);
        this.udpThreadCount = this.getConfig("cluster.udpThreadCount", 5);
        this.tracerDirectory = this.getConfig("cluster.tracerDirectory");
        this.cookieName = this.getConfig("cluster.session.cookieName", "CSID");
        this.cookiePath = this.getConfig("cluster.session.cookiePath", "/");
        this.cookieTLD = this.getConfig("cluster.session.cookieTLD", 2);
        this.cookieDomain = this.getConfig("cluster.session.cookieDomain", null);
        this.balancerRoute = this.getConfig("cluster.session.balancerRoute", null);
        this.balancerSeparator = this.getConfig("cluster.session.balancerSeparator", null);
        this.sessionTimeout = this.getConfig("cluster.session.timeout", 1800);
        this.sessionLimit = this.getConfig("cluster.session.limit", -1);
        this.sessionUnlimitURI = this.getConfig("cluster.session.unimitURI", null);
        this.addressLimit = this.getConfig("cluster.session.addressLimit", -1);
        this.addressSpecial = this.getConfig("cluster.session.addressSpecial", null);
        this.keepAlive = this.getConfig("cluster.socket.keepAlive", false);
        this.reuseAddress = this.getConfig("cluster.socket.reuseAddress", false);
        this.tcpNoDelay = this.getConfig("cluster.socket.tcpNoDelay", false);
        String brothers = this.getConfig("cluster.brothers.hosts", "");
        if (brothers != null && brothers.trim().length() > 0) {
            String[] hosts = brothers.split(",");
            this.brotherAddresses = new Address[hosts.length];
            int i = 0;
            int len = hosts.length;
            while (i < len) {
                block6: {
                    InetAddress inetAddress = null;
                    try {
                        inetAddress = InetAddress.getByName(hosts[i]);
                    }
                    catch (UnknownHostException e) {
                        s_logger.warn((Object)("UnknownHost:" + hosts[i]));
                        break block6;
                    }
                    this.brotherAddresses[i] = new AddressByUDP(inetAddress, this.udpListenPort);
                }
                ++i;
            }
        }
    }

    final String getConfig(String key) {
        return this.configs.getProperty(key);
    }

    final boolean getConfig(String key, boolean zDefault) {
        String value = this.configs.getProperty(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return zDefault;
    }

    final int getConfig(String key, int iDefault) {
        String value = this.configs.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return iDefault;
    }

    final short getConfig(String key, short iDefault) {
        String value = this.configs.getProperty(key);
        if (value != null) {
            return Short.parseShort(value);
        }
        return iDefault;
    }

    final String getConfig(String key, String sDefault) {
        String value = this.configs.getProperty(key);
        if (value != null) {
            return value;
        }
        return sDefault;
    }

    public ClusterConfig() {
        this.load((Properties)null);
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isMaster() {
        return this.master;
    }

    public final void setMaster(boolean master) {
        this.master = master;
    }

    public final String getMemberName() {
        if (this.memberName != null && this.memberName.length() > 0) {
            return this.memberName;
        }
        return this.getMemberHost();
    }

    public final void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public final String getMemberHost() {
        if (this.memberHost == null || this.memberHost.length() <= 0) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                this.memberHost = localhost.getHostName();
            }
            catch (Exception e) {
                s_logger.error((Object)"Get local host name failed", (Throwable)e);
                return "HostNameError";
            }
        }
        return this.memberHost;
    }

    public final void setMemberHost(String memberHost) {
        this.memberHost = memberHost;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(int magicNumber) {
        this.magicNumber = magicNumber;
    }

    public final InetAddress getInetMulticastAddress() throws UnknownHostException {
        if (this.inetMulticastAddress == null) {
            this.inetMulticastAddress = InetAddress.getByName(this.multicastAddress);
        }
        return this.inetMulticastAddress;
    }

    public final void setInetMulticastAddress(InetAddress inetMulticastAddress) {
        this.inetMulticastAddress = inetMulticastAddress;
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(String address) {
        this.multicastAddress = address;
    }

    public final InetAddress getInetMulticastBind() throws UnknownHostException {
        if (this.inetMulticastBind == null) {
            this.inetMulticastBind = "auto".equals(this.multicastBind) ? this.getInetAutoAddress() : InetAddress.getByName(this.multicastBind);
        }
        return this.inetMulticastBind;
    }

    public final void setInetMulticastBind(InetAddress inetMulticastBind) {
        this.inetMulticastBind = inetMulticastBind;
    }

    public String getMulticastBind() {
        return this.multicastBind;
    }

    public void setMulticastBind(String bind) {
        this.multicastBind = bind;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int port) {
        this.multicastPort = port;
    }

    public final int getMulticastThreadCount() {
        return this.multicastThreadCount;
    }

    public final void setMulticastThreadCount(int multicastThreadCount) {
        this.multicastThreadCount = multicastThreadCount;
    }

    public int getMulticastTTL() {
        return this.multicastTTL;
    }

    public void setMulticastTTL(int ttl) {
        this.multicastTTL = ttl;
    }

    public final InetAddress getInetAutoAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            s_logger.fatal((Object)"Get local host address failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public final InetAddress getInetTCPListenAddress() throws UnknownHostException {
        if (this.inetTCPListenAddress == null) {
            this.inetTCPListenAddress = "auto".equals(this.tcpListenAddress) ? this.getInetMulticastBind() : InetAddress.getByName(this.tcpListenAddress);
        }
        return this.inetTCPListenAddress;
    }

    public final void setInetTCPListenAddress(InetAddress inetTCPListenAddress) {
        this.inetTCPListenAddress = inetTCPListenAddress;
    }

    public final String getTCPListenAddress() {
        return this.tcpListenAddress;
    }

    public final void setTCPListenAddress(String tcpListenAddress) {
        this.tcpListenAddress = tcpListenAddress;
    }

    public final int getTCPListenPort() {
        return this.tcpListenPort;
    }

    public final void setTCPListenPort(int tcpListenPort) {
        this.tcpListenPort = tcpListenPort;
    }

    public final int getTCPBufferSize() {
        return this.tcpBufferSize;
    }

    public final void setTCPBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
    }

    public final int getTCPSoTimeout() {
        return this.tcpSoTimeout;
    }

    public final void setTCPSoTimeout(int tcpSoTimeout) {
        this.tcpSoTimeout = tcpSoTimeout;
    }

    public final int getTCPThreadCount() {
        return this.tcpThreadCount;
    }

    public final void setTCPThreadCount(int tcpThreadCount) {
        this.tcpThreadCount = tcpThreadCount;
    }

    public final InetAddress getInetUDPListenAddress() throws UnknownHostException {
        if (this.inetUDPListenAddress == null) {
            this.inetUDPListenAddress = "auto".equals(this.udpListenAddress) ? this.getInetMulticastBind() : InetAddress.getByName(this.udpListenAddress);
        }
        return this.inetUDPListenAddress;
    }

    public final void setInetUDPListenAddress(InetAddress inetUDPListenAddress) {
        this.inetUDPListenAddress = inetUDPListenAddress;
    }

    public final String getUDPListenAddress() {
        return this.udpListenAddress;
    }

    public final void setUDPListenAddress(String udpListenAddress) {
        this.udpListenAddress = udpListenAddress;
    }

    public final int getUDPListenPort() {
        return this.udpListenPort;
    }

    public final void setUDPListenPort(int udpListenPort) {
        this.udpListenPort = udpListenPort;
    }

    public final int getUDPBufferSize() {
        return this.udpBufferSize;
    }

    public final void setUDPBufferSize(int udpBufferSize) {
        this.udpBufferSize = udpBufferSize;
    }

    public final int getUDPSoTimeout() {
        return this.udpSoTimeout;
    }

    public final void setUDPSoTimeout(int udpSoTimeout) {
        this.udpSoTimeout = udpSoTimeout;
    }

    public final int getUDPThreadCount() {
        return this.udpThreadCount;
    }

    public final void setUDPThreadCount(int udpThreadCount) {
        this.udpThreadCount = udpThreadCount;
    }

    public final String getTracerDirectory() {
        return this.tracerDirectory;
    }

    public final void setTracerDirectory(String tracerDirectory) {
        this.tracerDirectory = tracerDirectory;
    }

    public final String getCookieName() {
        return this.cookieName;
    }

    public final void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public final int getCookieTLD() {
        return this.cookieTLD;
    }

    public final void setCookieTLD(int cookieTLD) {
        this.cookieTLD = cookieTLD;
    }

    public final String getCookieDomain() {
        return this.cookieDomain;
    }

    public final void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public final String getBalancerRoute() {
        return this.balancerRoute;
    }

    public final void setBalancerRoute(String balancerRoute) {
        this.balancerRoute = balancerRoute;
    }

    public final String getBalancerSeparator() {
        return this.balancerSeparator;
    }

    public final void setBalancerSeparator(String balancerSeparator) {
        this.balancerSeparator = balancerSeparator;
    }

    public final int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public final void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public final int getSessionLimit() {
        return this.sessionLimit;
    }

    public final void setSessionLimit(int sessionLimit) {
        this.sessionLimit = sessionLimit;
    }

    public final String getSessionUnlimitURI() {
        return this.sessionUnlimitURI;
    }

    public final void setSessionUnlimitURI(String sessionUnlimitURI) {
        this.sessionUnlimitURI = sessionUnlimitURI;
    }

    public final int getAddressLimit() {
        return this.addressLimit;
    }

    public final void setAddressLimit(int addressLimit) {
        this.addressLimit = addressLimit;
    }

    public final String getAddressSpecial() {
        return this.addressSpecial;
    }

    public final void setAddressSpecial(String addressSpecial) {
        this.addressSpecial = addressSpecial;
    }

    public final boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public final void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public final boolean getKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public final boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public final void setResuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public final Address[] getBrotherAddresses() {
        return this.brotherAddresses;
    }

    public final void setBrotherAddresses(Address[] brotherAddresses) {
        this.brotherAddresses = brotherAddresses;
    }
}

