/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.GenerateUtil;
import com.trs.cis4.util.RegexUtil;
import com.trs.cis4.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import sun.misc.BASE64Encoder;

public class EmailUtil {
    private static final Logger logger;
    private JavaMailSender mailSender;
    private SimpleMailMessage mailMessage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.cis4.util.EmailUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void setMailMessage(SimpleMailMessage mailMessage) {
        this.mailMessage = mailMessage;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public SimpleMailMessage getMailMessage() {
        return this.mailMessage;
    }

    public boolean sendTextMail(String[] to, String[] cc, String[] bcc, String subject, String content) {
        if (this.arrayUtilsisEmpty(to) && this.arrayUtilsisEmpty(cc) && this.arrayUtilsisEmpty(bcc)) {
            return false;
        }
        boolean success = false;
        SimpleMailMessage message = new SimpleMailMessage(this.mailMessage);
        String prefix = this.mailMessage.getSubject();
        message.setSubject(String.valueOf(prefix) + subject);
        if (!this.arrayUtilsisEmpty(to)) {
            message.setTo(to);
        }
        if (!this.arrayUtilsisEmpty(cc)) {
            message.setTo(cc);
        }
        if (!this.arrayUtilsisEmpty(bcc)) {
            message.setTo(bcc);
        }
        message.setText(content);
        try {
            this.mailSender.send(message);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Send plain text email successfully!");
            }
            success = true;
        }
        catch (MailException e) {
            System.out.println((Object)e);
            logger.error((Object)"Send plain text email failure!", (Throwable)e);
        }
        return success;
    }

    public boolean sendTextMail(String[] to, String subject, String content) {
        return this.sendTextMail(to, null, null, subject, content);
    }

    public int sendTextMailSeparately(String[] to, String subject, String content) {
        if (this.arrayUtilsisEmpty(to)) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < to.length) {
            boolean bsend = this.sendTextMail(new String[]{to[i]}, null, null, subject, content);
            if (bsend) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean sendMimeMail(String[] to, String subject, String content) {
        return this.sendMimeMail(to, null, null, subject, content, null, null, null);
    }

    public boolean sendMimeMail(String[] to, String[] cc, String[] bcc, String subject, String content) {
        return this.sendMimeMail(to, cc, bcc, subject, content, null, null, null);
    }

    public boolean sendMimeMail(String[] to, String subject, String content, List attachList, List attachNameList, List imageList) {
        return this.sendMimeMail(to, null, null, subject, content, attachList, attachNameList, imageList);
    }

    public boolean sendMimeMail(final String[] to, final String[] cc, final String[] bcc, final String subject, final String content, final List attachList, final List attachNameList, final List imageList) {
        if (this.arrayUtilsisEmpty(to) && this.arrayUtilsisEmpty(cc) && this.arrayUtilsisEmpty(bcc)) {
            return false;
        }
        boolean success = false;
        MimeMessagePreparator mimeMail = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                if (!EmailUtil.this.arrayUtilsisEmpty(to)) {
                    mimeMessage.setRecipients(Message.RecipientType.TO, EmailUtil.this.getRecipients(to));
                }
                if (!EmailUtil.this.arrayUtilsisEmpty(cc)) {
                    mimeMessage.setRecipients(Message.RecipientType.CC, EmailUtil.this.getRecipients(cc));
                }
                if (!EmailUtil.this.arrayUtilsisEmpty(bcc)) {
                    mimeMessage.setRecipients(Message.RecipientType.BCC, EmailUtil.this.getRecipients(bcc));
                }
                mimeMessage.setFrom((Address)new InternetAddress(EmailUtil.this.mailMessage.getFrom()));
                String prefix = EmailUtil.this.mailMessage.getSubject();
                mimeMessage.setSubject(String.valueOf(prefix) + subject, "UTF-8");
                mimeMessage.setSentDate(new Date());
                mimeMessage.setContent(EmailUtil.this.getMultipartContent(content, attachList, attachNameList, imageList));
            }
        };
        try {
            this.mailSender.send(mimeMail);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Send html email successfully!");
            }
            success = true;
        }
        catch (MailException e) {
            System.out.println((Object)e);
            logger.error((Object)"Send html email failure!", (Throwable)e);
        }
        return success;
    }

    public int sendMimeMailSeparately(String[] to, String subject, String content, List attachList, List attachNameList, List imageList) {
        if (this.arrayUtilsisEmpty(to)) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < to.length) {
            boolean bsend = this.sendMimeMail(new String[]{to[i]}, null, null, subject, content, attachList, attachNameList, imageList);
            if (bsend) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean arrayUtilsisEmpty(String[] to) {
        if (to == null || to.length == 0) {
            return true;
        }
        int i = 0;
        while (i < to.length) {
            if (to[i] == null || to[i].length() == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Address[] getRecipients(String[] to) {
        ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>();
        int i = 0;
        while (i < to.length) {
            try {
                addressList.add(new InternetAddress(to[i]));
            }
            catch (AddressException e) {
                logger.error((Object)("error while parse the address:[" + to[i] + "]"), (Throwable)e);
            }
            ++i;
        }
        return addressList.toArray(new Address[addressList.size()]);
    }

    private String addAttachPart(Multipart multipart, String content, String filepath, String newfilename, boolean isImage) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        FileDataSource dataSource = new FileDataSource(filepath);
        bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
        String filename = dataSource.getName();
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            if (StringUtil.isEmpty(newfilename)) {
                newfilename = filename;
            }
            bodyPart.setFileName("=?UTF-8?B?" + encoder.encode(newfilename.getBytes("UTF-8")) + "?=");
        }
        catch (UnsupportedEncodingException encoder) {
            // empty catch block
        }
        multipart.addBodyPart((BodyPart)bodyPart);
        String contentId = "ATT" + GenerateUtil.generate9();
        bodyPart.setHeader("content-id", contentId);
        List list = isImage ? RegexUtil.getMatchGroupList(content, "(?i)<img +src *= *([^>]*)>", 1) : RegexUtil.getMatchGroupList(content, "(?i)<a +href *= *([^>]*)>", 1);
        int i = 0;
        while (i < list.size()) {
            String imagePath = (String)list.get(i);
            if (imagePath.indexOf("/" + newfilename) != -1 || imagePath.indexOf("\\" + newfilename) != -1) {
                content = StringUtil.replaceString(content, imagePath, "cid:" + contentId);
            }
            ++i;
        }
        return content;
    }

    private Multipart getMultipartContent(String content, List attachList, List attachNameList, List imageList) throws MessagingException {
        String filepath;
        int i;
        MimeMultipart multipart = new MimeMultipart("related");
        if (attachList != null) {
            i = 0;
            while (i < attachList.size()) {
                String newfilename;
                filepath = (String)attachList.get(i);
                try {
                    newfilename = (String)attachNameList.get(i);
                }
                catch (Exception e) {
                    newfilename = null;
                }
                content = this.addAttachPart((Multipart)multipart, content, filepath, newfilename, false);
                ++i;
            }
        }
        if (imageList != null) {
            i = 0;
            while (i < imageList.size()) {
                filepath = (String)imageList.get(i);
                content = this.addAttachPart((Multipart)multipart, content, filepath, null, true);
                ++i;
            }
        }
        MimeBodyPart contentPart = new MimeBodyPart();
        contentPart.setText(content, "utf-8", "html");
        multipart.addBodyPart((BodyPart)contentPart, 0);
        return multipart;
    }
}

