/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import de.laures.cewolf.util.ImageHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class RenderingHelper {
    private static final int PADDING_X = 5;

    public static String renderMessage(String msg, int width, int height, OutputStream out) throws IOException {
        BufferedImage image = ImageHelper.createImage(width, height);
        Graphics gr = image.getGraphics();
        gr.setColor(Color.white);
        gr.fillRect(0, 0, width, height);
        gr.setColor(Color.black);
        gr.drawString(msg, 5, height / 2 - 7);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(1.0f, true);
        encoder.encode(image, param);
        return "image/jpeg";
    }

    public static String renderException(Throwable ex, int width, int height, OutputStream out) throws IOException {
        BufferedImage image = ImageHelper.createImage(width, height);
        Graphics gr = image.getGraphics();
        gr.setColor(Color.white);
        gr.fillRect(0, 0, width, height);
        gr.setColor(Color.red);
        gr.drawString(ex.getClass().getName() + " raised:", 5, 15);
        gr.drawString(String.valueOf(ex.getMessage()), 5, 30);
        gr.setColor(Color.black);
        Font stFont = gr.getFont().deriveFont(9.0f);
        gr.setFont(stFont);
        RenderingHelper.drawStackTrace(gr, 5, 50, ex);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(1.0f, true);
        encoder.encode(image, param);
        return "image/jpeg";
    }

    private static void drawStackTrace(Graphics gr, int x, int y, Throwable ex) {
        int linePadding = 4;
        int lineHeight = gr.getFont().getSize() + 4;
        int currY = y;
        StringTokenizer lines = new StringTokenizer(RenderingHelper.getStackTrace(ex), "\n", false);
        while (lines.hasMoreElements()) {
            gr.drawString(((String)lines.nextElement()).trim(), x, currY);
            currY += lineHeight;
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }
}

