/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.utils;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.utils.Sort;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;

public class DDLGenerator {
    private Hashtable dbInfos;
    private DBInfo dbInfo;
    private static final String DEFAULT = "Default";
    private static final String CREATETABLE = "CREATE TABLE";
    private static final String NULL = "NULL";
    private static final String NOTNULL = "NOT NULL";
    private static final String CONSTRAINT = "CONSTRAINT";
    private static final String PRIMARYKEY = "PRIMARY KEY";
    private static final String UNIQUE = "UNIQUE";
    private static final String FOREIGNKEY = "FOREIGN KEY";
    private static final String REFERENCES = "REFERENCES";
    private static final String LENGTH = "LENGTH";
    private static final String PRECISION = "PRECISION";
    private static final String SCALE = "SCALE";
    private static final String PRECISIONSCALE = "PRECISION, SCALE";

    public DDLGenerator() {
        this.dbInfos = null;
        this.dbInfo = new DBInfo();
        this.initDatabaseMetadata();
        this.initDataTypeMetadata();
    }

    public DDLGenerator(String string, DatabaseMetaData databaseMetaData) throws SQLException {
        if (string == null) {
            string = DEFAULT;
        }
        this.dbInfo = new DBInfo();
        this.dbInfos = new Hashtable();
        this.dbInfos.put(string, this.dbInfo);
        this.initDatabaseMetadata(string, databaseMetaData);
        this.initDataTypeMetadata(string, databaseMetaData);
    }

    public DDLGenerator(String[] stringArray, DatabaseMetaData[] databaseMetaDataArray) throws SQLException {
        this.dbInfos = new Hashtable();
        int n = 0;
        while (n < stringArray.length) {
            if (this.dbInfos.get(stringArray[n]) != null) {
                throw new IllegalArgumentException("Database name used more than once: " + stringArray[n]);
            }
            this.dbInfo = new DBInfo();
            this.dbInfos.put(stringArray[n], this.dbInfo);
            this.initDatabaseMetadata(stringArray[n], databaseMetaDataArray[n]);
            this.initDataTypeMetadata(stringArray[n], databaseMetaDataArray[n]);
            ++n;
        }
    }

    public Vector getCreateTableStrings(XMLDBMSMap xMLDBMSMap) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = xMLDBMSMap.getTables();
        while (enumeration.hasMoreElements()) {
            Table table = (Table)enumeration.nextElement();
            vector.addElement(this.getCreateTableString(table));
        }
        return vector;
    }

    public String getCreateTableString(Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dbInfos != null) {
            this.dbInfo = (DBInfo)this.dbInfos.get(table.getDatabaseName());
            if (this.dbInfo == null) {
                throw new IllegalArgumentException("No DatabaseMetaData object specified for the " + table.getDatabaseName() + " database.");
            }
        }
        stringBuffer.append(CREATETABLE);
        stringBuffer.append(' ');
        stringBuffer.append(this.getTableName(table));
        stringBuffer.append(' ');
        stringBuffer.append('(');
        boolean bl = false;
        Enumeration enumeration = table.getColumns();
        while (enumeration.hasMoreElements()) {
            Column column = (Column)enumeration.nextElement();
            stringBuffer.append(this.getColumnName(column, bl));
            bl = true;
            stringBuffer.append(' ');
            stringBuffer.append(this.getDataType(column));
            stringBuffer.append(' ');
            stringBuffer.append(this.getNull(column));
        }
        Key key = table.getPrimaryKey();
        if (key != null) {
            stringBuffer.append(this.getKeyConstraint(key));
        }
        Enumeration enumeration2 = table.getUniqueKeys();
        while (enumeration2.hasMoreElements()) {
            key = (Key)enumeration2.nextElement();
            stringBuffer.append(this.getKeyConstraint(key));
        }
        enumeration2 = table.getForeignKeys();
        while (enumeration2.hasMoreElements()) {
            key = (Key)enumeration2.nextElement();
            stringBuffer.append(this.getKeyConstraint(key));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String getTableName(Table table) {
        String string;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dbInfo.useCatalog && (string2 = table.getCatalogName()) != null && this.dbInfo.isCatalogAtStart) {
            stringBuffer.append(this.getQuotedName(string2));
            stringBuffer.append(this.dbInfo.catalogSeparator);
        }
        if (this.dbInfo.useSchema && (string = table.getSchemaName()) != null) {
            stringBuffer.append(this.getQuotedName(string));
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getQuotedName(table.getTableName()));
        if (this.dbInfo.useCatalog && string2 != null && !this.dbInfo.isCatalogAtStart) {
            stringBuffer.append(this.dbInfo.catalogSeparator);
            stringBuffer.append(this.getQuotedName(string2));
        }
        return stringBuffer.toString();
    }

    private String getColumnName(Column column, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.getQuotedName(column.getName()));
        return stringBuffer.toString();
    }

    private String getQuotedName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dbInfo.quote);
        stringBuffer.append(string);
        stringBuffer.append(this.dbInfo.quote);
        return stringBuffer.toString();
    }

    private String getDataType(Column column) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        long[] lArray = new long[3];
        Object[] objectArray = new String[]{LENGTH, PRECISION, SCALE};
        int n2 = column.getType();
        stringBuffer.append((String)this.dbInfo.typeNames.get(new Integer(n2)));
        String string = (String)this.dbInfo.createParams.get(new Integer(n2));
        if (string != null) {
            lArray[0] = string.indexOf(LENGTH);
            lArray[1] = string.indexOf(PRECISION);
            lArray[2] = string.indexOf(SCALE);
            Sort.sort(lArray, objectArray);
            boolean bl = true;
            int n3 = 0;
            while (n3 < lArray.length) {
                if (lArray[n3] != -1L) {
                    boolean bl2;
                    if (((String)objectArray[n3]).equals(LENGTH)) {
                        bl2 = column.lengthExists();
                        if (bl2) {
                            n = column.getLength();
                        }
                    } else if (((String)objectArray[n3]).equals(PRECISION)) {
                        bl2 = column.precisionExists();
                        if (bl2) {
                            n = column.getPrecision();
                        }
                    } else {
                        bl2 = column.scaleExists();
                        if (bl2) {
                            n = column.getScale();
                        }
                    }
                    if (bl2) {
                        if (bl) {
                            stringBuffer.append('(');
                            bl = false;
                        } else {
                            stringBuffer.append(',');
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(String.valueOf(n));
                    }
                }
                ++n3;
            }
            if (!bl) {
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    private String getNull(Column column) {
        column.getNullability();
        switch (column.getNullability()) {
            case 1: {
                return NULL;
            }
            case 0: {
                return NOTNULL;
            }
        }
        return null;
    }

    private String getKeyConstraint(Key key) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(',');
        stringBuffer.append(' ');
        stringBuffer.append(CONSTRAINT);
        stringBuffer.append(' ');
        stringBuffer.append(key.getName());
        stringBuffer.append(' ');
        int n = key.getType();
        switch (n) {
            case 1: {
                stringBuffer.append(PRIMARYKEY);
                break;
            }
            case 2: {
                stringBuffer.append(UNIQUE);
                break;
            }
            case 3: {
                stringBuffer.append(FOREIGNKEY);
                break;
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append('(');
        stringBuffer.append(this.getKeyColumns(key));
        stringBuffer.append(')');
        if (n == 3) {
            stringBuffer.append(' ');
            stringBuffer.append(REFERENCES);
            stringBuffer.append(' ');
            stringBuffer.append(this.getTableName(key.getRemoteTable()));
            stringBuffer.append(' ');
            stringBuffer.append('(');
            stringBuffer.append(this.getKeyColumns(key.getRemoteKey()));
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private String getKeyColumns(Key key) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Column[] columnArray = key.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            stringBuffer.append(this.getColumnName(columnArray[n], bl));
            bl = true;
            ++n;
        }
        return stringBuffer.toString();
    }

    private void initDatabaseMetadata() {
        this.dbInfo.quote = "\"";
        this.dbInfo.isCatalogAtStart = true;
        this.dbInfo.catalogSeparator = ".";
        this.dbInfo.useCatalog = true;
        this.dbInfo.useSchema = true;
    }

    private void initDatabaseMetadata(String string, DatabaseMetaData databaseMetaData) throws SQLException {
        this.dbInfo.quote = databaseMetaData.getIdentifierQuoteString();
        if (this.dbInfo.quote == null) {
            this.dbInfo.quote = "";
        }
        this.dbInfo.isCatalogAtStart = databaseMetaData.isCatalogAtStart();
        this.dbInfo.catalogSeparator = databaseMetaData.getCatalogSeparator();
        if (this.dbInfo.catalogSeparator == null) {
            this.dbInfo.catalogSeparator = ".";
        }
        if (this.dbInfo.catalogSeparator.length() == 0) {
            this.dbInfo.catalogSeparator = ".";
        }
        this.dbInfo.useCatalog = databaseMetaData.supportsCatalogsInTableDefinitions();
        this.dbInfo.useSchema = databaseMetaData.supportsSchemasInTableDefinitions();
    }

    private void initDataTypeMetadata() {
        this.dbInfo.typeNames.put(new Integer(-5), JDBCTypes.getName(-5));
        this.dbInfo.typeNames.put(new Integer(-2), JDBCTypes.getName(-2));
        this.dbInfo.typeNames.put(new Integer(-7), JDBCTypes.getName(-7));
        this.dbInfo.typeNames.put(new Integer(1), JDBCTypes.getName(1));
        this.dbInfo.typeNames.put(new Integer(91), JDBCTypes.getName(91));
        this.dbInfo.typeNames.put(new Integer(3), JDBCTypes.getName(3));
        this.dbInfo.typeNames.put(new Integer(8), JDBCTypes.getName(8));
        this.dbInfo.typeNames.put(new Integer(6), JDBCTypes.getName(6));
        this.dbInfo.typeNames.put(new Integer(4), JDBCTypes.getName(4));
        this.dbInfo.typeNames.put(new Integer(-4), JDBCTypes.getName(-4));
        this.dbInfo.typeNames.put(new Integer(-1), JDBCTypes.getName(-1));
        this.dbInfo.typeNames.put(new Integer(2), JDBCTypes.getName(2));
        this.dbInfo.typeNames.put(new Integer(7), JDBCTypes.getName(7));
        this.dbInfo.typeNames.put(new Integer(5), JDBCTypes.getName(5));
        this.dbInfo.typeNames.put(new Integer(92), JDBCTypes.getName(92));
        this.dbInfo.typeNames.put(new Integer(93), JDBCTypes.getName(93));
        this.dbInfo.typeNames.put(new Integer(-6), JDBCTypes.getName(-6));
        this.dbInfo.typeNames.put(new Integer(-3), JDBCTypes.getName(-3));
        this.dbInfo.typeNames.put(new Integer(12), JDBCTypes.getName(12));
        this.dbInfo.createParams.put(new Integer(-2), LENGTH);
        this.dbInfo.createParams.put(new Integer(1), LENGTH);
        this.dbInfo.createParams.put(new Integer(3), PRECISIONSCALE);
        this.dbInfo.createParams.put(new Integer(6), PRECISION);
        this.dbInfo.createParams.put(new Integer(-4), LENGTH);
        this.dbInfo.createParams.put(new Integer(-1), LENGTH);
        this.dbInfo.createParams.put(new Integer(2), PRECISIONSCALE);
        this.dbInfo.createParams.put(new Integer(-3), LENGTH);
        this.dbInfo.createParams.put(new Integer(12), LENGTH);
    }

    private void initDataTypeMetadata(String string, DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            Integer n = new Integer(resultSet.getShort(2));
            String string3 = resultSet.getString(6);
            if (resultSet.wasNull()) {
                string3 = null;
            }
            if (this.dbInfo.typeNames.get(n) != null) continue;
            this.dbInfo.typeNames.put(n, string2);
            if (string3 == null) continue;
            this.dbInfo.createParams.put(n, string3.toUpperCase());
        }
        resultSet.close();
    }

    private class DBInfo {
        String quote;
        String catalogSeparator;
        boolean isCatalogAtStart = true;
        boolean useCatalog = true;
        boolean useSchema = true;
        Hashtable typeNames = new Hashtable();
        Hashtable createParams = new Hashtable();

        DBInfo() {
            DDLGenerator.this = DDLGenerator.this;
        }
    }
}

