/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.ImageLibConstants;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;

public class ImageLibConfigImpl
implements IImageLibConfig {
    private static Logger logger = Logger.getLogger(ImageLibConfigImpl.class);
    private static final String RELATED_CONVERT_TYPE = "RELATED_CONVERT_TYPE";
    private static final String WARTERMARK_POS = "WARTERMARK_POS";
    private static final String WATERMARK_ID = "WATERMARK_ID";
    private static final String RELATED_KINDID = "RELATED_KINDID";
    private static final String AUTO_ENABLE = "AUTO_ENABLE";
    private static final String RELATED_KINDIDS = "RELATED_KINDIDS";
    private int m_nRelateSiteId = 0;
    private String[] m_pScaleSizeDescs = new String[0];
    private int[] m_pScaleSizes = new int[0];
    private int m_nDefaultOutTemplateId = 0;
    private int m_nDefaultDetailTemplateId = 0;
    private Properties m_oConfigProperties = null;
    private HashMap m_mapWaterMarkScale = new HashMap();
    private boolean m_zCmdUsed = false;
    private boolean m_zMarkOriginal = false;
    private String m_sScaleStyle = "auto";

    public ImageLibConfigImpl() {
        this.m_mapWaterMarkScale.put(new Integer(240), new Integer(50));
        this.m_mapWaterMarkScale.put(new Integer(500), new Integer(100));
        this.m_mapWaterMarkScale.put(new Integer(640), new Integer(120));
    }

    @Override
    public WebSite getRelateSite() throws WCMException {
        return WebSite.findById(this.getRelateSiteId());
    }

    @Override
    public int getRelateSiteId() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_nRelateSiteId;
    }

    @Override
    public Template getDefaultOutlineTemplate() throws WCMException {
        return Template.findById(this.getDefaultOutlineTemplateId());
    }

    @Override
    public int getDefaultOutlineTemplateId() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_nDefaultOutTemplateId;
    }

    @Override
    public Template getDefaultDetailTemplate() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return Template.findById(this.m_nDefaultDetailTemplateId);
    }

    @Override
    public int getDefaultDetailTemplateId() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_nDefaultDetailTemplateId;
    }

    @Override
    public int[] getScaleSizes() throws WCMException {
        this.loadConfig();
        return this.m_pScaleSizes;
    }

    @Override
    public String[] getSupportImageFileExt() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("SupportImageFilesExts", "gif,jpg,jpeg,bmp,png").split(",");
    }

    private int[] findScaleSizes() throws WCMException {
        String sValue = ConfigServer.getServer().getSysConfigValue("ScaleSizes", "124, 133, 240, 500, 640");
        if (sValue == null || (sValue = sValue.trim()).length() <= 0) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label11", "\u56fe\u7247\u5e93\u914d\u7f6e\u9519\u8bef\uff1a\u7f29\u653e\u5c3a\u5bf8\uff08SCALE_SIZE\uff09\u6ca1\u6709\u914d\u7f6e\uff01"));
        }
        int[] pDefineScaleSizes = CMyString.splitToInt(sValue, ",");
        Arrays.sort(pDefineScaleSizes);
        int[] pScaleSizes = new int[pDefineScaleSizes.length + 1];
        pScaleSizes[0] = 75;
        System.arraycopy(pDefineScaleSizes, 0, pScaleSizes, 1, pDefineScaleSizes.length);
        return pScaleSizes;
    }

    @Override
    public boolean isSupportImageFileExt(String _sImageFileExt) throws WCMException {
        String[] pSupportImageFileExt = this.getSupportImageFileExt();
        for (int i = 0; i < pSupportImageFileExt.length; ++i) {
            if (!pSupportImageFileExt[i].equalsIgnoreCase(_sImageFileExt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultConvertImageFileExt() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("DefaultConvertImageFileExt", "gif");
    }

    @Override
    public boolean reloadConfig() throws WCMException {
        if (this.m_oConfigProperties != null) {
            this.m_oConfigProperties.clear();
        }
        this.m_oConfigProperties = null;
        return this.loadConfig();
    }

    private synchronized boolean loadConfig() throws WCMException {
        try {
            this.m_pScaleSizes = this.findScaleSizes();
            this.m_pScaleSizeDescs = this.findScaleSizeDescs();
            this.m_mapWaterMarkScale = this.findScaleRelateMark();
            if (this.m_oConfigProperties != null && !this.m_oConfigProperties.isEmpty()) {
                return true;
            }
            this.m_oConfigProperties = new Properties();
            URL url = Loader.getResource((String)"TRSWCMPhoto.properties");
            if (url == null) {
                throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label7", "\u6ca1\u6709\u627e\u5230\u56fe\u7247\u5e93\u7684\u914d\u7f6e\u6587\u4ef6\uff01[") + "TRSWCMPhoto.properties" + "]");
            }
            try {
                this.m_oConfigProperties.load(url.openStream());
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label8", "\u8bfb\u53d6\u56fe\u7247\u5e93\u914d\u7f6e\u6587\u4ef6[") + url.getPath() + I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label9", "]\u5931\u8d25\uff01"), e);
            }
            HashMap<String, String> cmds = new HashMap<String, String>(5);
            String cmd = this.m_oConfigProperties.getProperty("CMD_COMPOSITE");
            if (cmd != null) {
                cmds.put("CMD_COMPOSITE", cmd);
                cmd = this.m_oConfigProperties.getProperty("CMD_CONVERT");
                cmds.put("CMD_CONVERT", cmd);
                cmd = this.m_oConfigProperties.getProperty("CMD_IDENTIFY");
                cmds.put("CMD_IDENTIFY", cmd);
                cmd = this.m_oConfigProperties.getProperty("CONVERT_QUALITY");
                cmds.put("CONVERT_QUALITY", cmd);
                cmd = this.m_oConfigProperties.getProperty("CONVERT_STRIP");
                cmds.put("CONVERT_STRIP", cmd);
                ImageMagickCmd.setCmds(cmds);
                this.m_zCmdUsed = true;
            }
            this.m_zMarkOriginal = "true".equals(this.m_oConfigProperties.getProperty("MARKORIGINAL"));
            this.m_sScaleStyle = this.m_oConfigProperties.getProperty("SCALE_STYLE", "auto");
            return true;
        }
        catch (Throwable t) {
            logger.error((Object)"\u52a0\u8f7d\u56fe\u7247\u5e93\u914d\u7f6e\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", t);
            throw new WCMException("\u52a0\u8f7d\u56fe\u7247\u5e93\u914d\u7f6e\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", t);
        }
    }

    private HashMap findScaleRelateMark() throws WCMException {
        String sValue = ConfigServer.getServer().getSysConfigValue("WaterMarkScales", "640:120,240:50,500:100");
        if (sValue == null || (sValue = sValue.trim()).length() <= 0) {
            return new HashMap();
        }
        String[] pScaleRelateMark = CMyString.split(sValue, ",");
        HashMap<Integer, Integer> mapTemp = new HashMap<Integer, Integer>(pScaleRelateMark.length);
        for (int i = 0; i < pScaleRelateMark.length; ++i) {
            int nPos = pScaleRelateMark[i].indexOf(58);
            if (nPos <= 0) continue;
            Integer iKey = new Integer(pScaleRelateMark[i].substring(0, nPos).trim());
            Integer iValue = new Integer(pScaleRelateMark[i].substring(nPos + 1).trim());
            mapTemp.put(iKey, iValue);
        }
        return mapTemp;
    }

    private String toScalerelateMark() {
        if (this.m_mapWaterMarkScale == null) {
            return "";
        }
        Object[] pImageSizes = this.m_mapWaterMarkScale.keySet().toArray();
        StringBuffer sbResult = new StringBuffer(pImageSizes.length * 10);
        for (int i = 0; i < pImageSizes.length; ++i) {
            if (i > 0) {
                sbResult.append(',');
            }
            sbResult.append(pImageSizes[i]);
            sbResult.append(':');
            sbResult.append(this.m_mapWaterMarkScale.get(pImageSizes[i]));
        }
        return sbResult.toString();
    }

    @Override
    public int getWaterMarkSize(int _nImageWidth) throws WCMException {
        this.loadConfig();
        Integer iMarkSize = (Integer)this.m_mapWaterMarkScale.get(new Integer(_nImageWidth));
        if (iMarkSize == null) {
            return 0;
        }
        return iMarkSize;
    }

    @Override
    public String getScaleDescAt(int _nScaleIndex) throws WCMException {
        this.loadConfig();
        if (_nScaleIndex >= this.m_pScaleSizeDescs.length) {
            return I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label14", "\u672a\u77e5");
        }
        String sSizeDesc = this.m_pScaleSizeDescs[_nScaleIndex];
        return I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label" + sSizeDesc, sSizeDesc);
    }

    private String[] findScaleSizeDescs() throws WCMException {
        String sValue = ConfigServer.getServer().getSysConfigValue("ScaleSizeDescs", I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label2", "\u56fe\u7247\u5217\u8868,\u53d1\u5e03\u6982\u89c8,\u4e2d\u56fe,\u5927\u56fe,\u8d85\u5927\u56fe"));
        if (sValue == null || (sValue = sValue.trim()).length() <= 0) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label12", "\u56fe\u7247\u5e93\u914d\u7f6e\u9519\u8bef\uff1a\u7f29\u653e\u5c3a\u5bf8\u63cf\u8ff0\uff08SCALE_SIZE_DESC\uff09\u6ca1\u6709\u914d\u7f6e\uff01"));
        }
        String[] pDefineScaleSizeDescs = CMyString.split(sValue, ",");
        String[] pScaleSizeDescs = new String[pDefineScaleSizeDescs.length + 1];
        pScaleSizeDescs[0] = I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label1", "\u7f29\u7565\u56fe");
        System.arraycopy(pDefineScaleSizeDescs, 0, pScaleSizeDescs, 1, pDefineScaleSizeDescs.length);
        return pScaleSizeDescs;
    }

    @Override
    public boolean saveConfig() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.m_oConfigProperties = new Properties();
        }
        ConfigServer.getServer().updateConfigValue("WaterMarkScales", this.toScalerelateMark());
        try {
            this.m_oConfigProperties.setProperty("Installed", "true");
        }
        catch (Error e) {
            e.printStackTrace();
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label15", "\u4fdd\u5b58\u56fe\u7247\u5e93\u8bbe\u7f6e\u5931\u8d25\uff01"), e);
        }
        return true;
    }

    @Override
    public void setDefaultTemplateId(int _nOutlineTemplateId, int _nDetailTemplateId) throws WCMException {
        Template template = Template.findById(_nDetailTemplateId);
        if (template == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label16", "\u8bbe\u7f6e\u7684\u7ec6\u89c8\u6a21\u677f\u4e0d\u5b58\u5728\uff01[TempalteId=") + _nDetailTemplateId + "]");
        }
        this.m_nDefaultDetailTemplateId = _nDetailTemplateId;
        template = Template.findById(_nOutlineTemplateId);
        if (template == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label16", "\u8bbe\u7f6e\u7684\u7ec6\u89c8\u6a21\u677f\u4e0d\u5b58\u5728\uff01[TempalteId=") + _nDetailTemplateId + "]");
        }
        this.m_nDefaultOutTemplateId = _nOutlineTemplateId;
    }

    @Override
    public void setImageFileExt(String[] _pSupportFileExt, String _sDefaultConvertFileExt) throws WCMException {
        ConfigServer.getServer().updateConfigValue("SupportImageFilesExts", CMyString.join(_pSupportFileExt, ","));
        boolean bContains = false;
        for (int i = 0; i < _pSupportFileExt.length; ++i) {
            if (!_sDefaultConvertFileExt.equalsIgnoreCase(_pSupportFileExt[i])) continue;
            bContains = true;
            break;
        }
        if (!bContains && _sDefaultConvertFileExt != null && _sDefaultConvertFileExt.length() > 0) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label17", "\u9ed8\u8ba4\u7684\u8f6c\u6362\u683c\u5f0f[") + _sDefaultConvertFileExt + I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label18", "]\u4e0d\u5728\u652f\u6301\u7684\u7c7b\u578b\u4e2d\uff01"));
        }
        ConfigServer.getServer().updateConfigValue("DefaultConvertImageFileExt", _sDefaultConvertFileExt);
    }

    @Override
    public void setScaleSizes(int[] _pScaleSize, String[] _pScaleSizeDesc, int[] _pWaterMarkSize) throws WCMException {
        if (_pScaleSize.length != _pScaleSizeDesc.length) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label19", "\u5bbd\u5ea6\u4e0e\u63cf\u8ff0\u957f\u5ea6\u4e0d\u662f\u4e00\u4e00\u5bf9\u5e94"));
        }
        if (_pScaleSize.length != _pWaterMarkSize.length) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label20", "\u5bbd\u5ea6\u4e0e\u6c34\u5370\u957f\u5ea6\u4e0d\u662f\u4e00\u4e00\u5bf9\u5e94"));
        }
        ConfigServer.getServer().updateConfigValue("ScaleSizes", CMyString.join(_pScaleSize, ","));
        ConfigServer.getServer().updateConfigValue("ScaleSizeDescs", CMyString.join(_pScaleSizeDesc, ","));
        this.m_mapWaterMarkScale.clear();
        for (int i = 0; i < _pWaterMarkSize.length; ++i) {
            if (_pWaterMarkSize[i] == 0) continue;
            this.m_mapWaterMarkScale.put(new Integer(_pScaleSize[i]), new Integer(_pWaterMarkSize[i]));
        }
    }

    @Override
    public void setRelateSiteId(int _nRelateId) throws WCMException {
        WebSite site = WebSite.findById(_nRelateId);
        if (site == null) {
            throw new WCMException(I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label21", "\u6307\u5b9a\u7ad9\u70b9[SiteId=") + _nRelateId + I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label22", "]\u4e0d\u5b58\u5728\uff01"));
        }
        this.m_nRelateSiteId = _nRelateId;
    }

    @Override
    public boolean isAutoEnable() throws WCMException {
        this.ensureLoaded();
        return "true".equals(this.m_oConfigProperties.get(AUTO_ENABLE));
    }

    @Override
    public void setAtuoEnable(boolean _enable) throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(AUTO_ENABLE, String.valueOf(_enable));
    }

    @Override
    public int getRelatedKindId() throws WCMException {
        this.ensureLoaded();
        String id = this.m_oConfigProperties.getProperty(RELATED_KINDID, "0");
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void setRealtedKindId(int _id) throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(RELATED_KINDID, String.valueOf(_id));
    }

    @Override
    public int[] getOtherRelatedKindIds() throws WCMException {
        this.ensureLoaded();
        String ids = this.m_oConfigProperties.getProperty(RELATED_KINDIDS);
        if (CMyString.isEmpty(ids)) {
            return new int[0];
        }
        return CMyString.splitToInt(ids, ",");
    }

    @Override
    public void setOtherRelatedKindIds(String _ids) throws WCMException {
        this.ensureLoaded();
        String ids = CMyString.showNull(_ids, "");
        this.m_oConfigProperties.setProperty(RELATED_KINDIDS, ids);
    }

    @Override
    public int getRelatedWaterMarkId() throws WCMException {
        this.ensureLoaded();
        String id = this.m_oConfigProperties.getProperty(WATERMARK_ID, "0");
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void setRelatedWaterMarkId(int _id) throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(WATERMARK_ID, String.valueOf(_id));
    }

    @Override
    public int[] getRelatedWaterMarkPos() throws WCMException {
        this.ensureLoaded();
        String pos = this.m_oConfigProperties.getProperty(WARTERMARK_POS);
        if (CMyString.isEmpty(pos)) {
            return new int[]{ImageLibConstants.MARKPOS_RIGHT_BOTTOM};
        }
        return CMyString.splitToInt(pos, ",");
    }

    @Override
    public void setRelatedWaterMarkPos(String _pos) throws WCMException {
        this.ensureLoaded();
        String pos = CMyString.showNull(_pos, "");
        this.m_oConfigProperties.setProperty(WARTERMARK_POS, pos);
    }

    private void ensureLoaded() throws WCMException {
        this.loadConfig();
    }

    @Override
    public String getRelatedConvertType() throws WCMException {
        this.ensureLoaded();
        return this.m_oConfigProperties.getProperty(RELATED_CONVERT_TYPE, "");
    }

    @Override
    public void setRelatedConvertType(String _type) throws WCMException {
        this.assertValidType(_type);
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty(RELATED_CONVERT_TYPE, _type);
    }

    private void assertValidType(String _type) throws WCMException {
        if (_type == null) {
            throw new WCMException(10, I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label23", "\u65e0\u6548\u53c2\u6570!"));
        }
        String type = _type.toLowerCase();
        if (!"gif".equals(type) && !"jpg".equals(type)) {
            throw new WCMException(10, I18NMessage.get(ImageLibConfigImpl.class, "ImageLibConfigImpl.label24", "\u65e0\u6548\u7684\u8f6c\u6362\u683c\u5f0f,\u53ea\u652f\u6301\u5230gif/jpg\u7684\u8f6c\u6362!"));
        }
    }

    @Override
    public boolean isInstalled() throws WCMException {
        this.ensureLoaded();
        String first = this.m_oConfigProperties.getProperty("Installed", "true");
        first = first.toLowerCase();
        return "true".equals(first) || "on".equals(first);
    }

    @Override
    public void setInstalled() throws WCMException {
        this.ensureLoaded();
        this.m_oConfigProperties.setProperty("Installed", "true");
    }

    @Override
    public boolean isCmdUsed() throws WCMException {
        if (this.m_oConfigProperties == null) {
            this.loadConfig();
        }
        return this.m_zCmdUsed;
    }

    @Override
    public boolean isOriginalMarked() throws WCMException {
        this.ensureLoaded();
        return this.m_zMarkOriginal;
    }

    @Override
    public String getScaleStyle() throws WCMException {
        this.ensureLoaded();
        return this.m_sScaleStyle;
    }
}

