/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.ILog;
import com.trs.infra.support.log.ILogMgr;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogType;
import com.trs.infra.support.log.LogXmlConverter;
import com.trs.infra.support.log.Logs;
import com.trs.infra.support.log.OperType;
import com.trs.infra.support.log.OperTypes;
import com.trs.infra.util.CMyBeanConfig;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LogServer {
    private static Class[] m_arLoggerClazz = null;
    private static final String LOGGER_CONFIG_FILE = "LoggerConfig.xml";
    private static Logger s_logger = Logger.getLogger(LogServer.class);
    public static int CONTEXT_INDEX_IP = BaseContextHelper.getNextIndex();
    public static int CONTEXT_INDEX_TOPID = BaseContextHelper.getNextIndex();
    private static Map m_operTypeMap = null;
    private static final int LOGDESC_MAX_BYTE_LENGTH = 3000;
    private static final int LOGDESC_MAX_LENGTH = 1500;
    private static LogType[] ALL_LOG_TYPE = new LogType[]{LogType.ERROR, LogType.WARN, LogType.INFO, LogType.DEBUG};
    private static final String LOGOBJS_CONFIG = "LogObjectConfig.properties";
    private static Properties m_logObjConf = null;

    private static long save(String _sUserName, String _sOperType, String _sLogDesc, int _nLogTypeId, BaseObj _baseObj, int _nTopId, String _sIp, long _lStartTime) throws WCMException {
        ILog[] arLog = LogServer.getLoggers();
        long lStartId = 0L;
        ILog log = null;
        for (int i = 0; i < arLog.length; ++i) {
            log = arLog[i];
            if (log == null) continue;
            log.setOpType(LogServer.getOperTypeAsInt(_sOperType));
            log.setDesc(_sLogDesc);
            log.setLogType(_nLogTypeId);
            log.setUser(_sUserName);
            log.setObj(_baseObj);
            log.setLogUserIP(_sIp);
            log.setTopLogId(_nTopId);
            log.setResult(0);
            log.setStartTimeMillis(_lStartTime);
            log.setEndTimeMillis(_lStartTime);
            log.saveLog();
            if (_nTopId == 0) {
                BaseContextHelper.setArg(CONTEXT_INDEX_TOPID, ((Log)log).getKey());
            }
            lStartId = log.getStartId();
        }
        return lStartId;
    }

    private static int getOperTypeAsInt(String _sOperType) throws WCMException {
        String sOperType = _sOperType.toUpperCase();
        OperType currOperType = (OperType)LogServer.initOperTypeMap().get(sOperType);
        return currOperType != null ? currOperType.getId() : 0;
    }

    private static String getLogIP() {
        try {
            return CMyString.showNull((String)BaseContextHelper.getArg(CONTEXT_INDEX_IP), "127.0.0.1");
        }
        catch (Exception e) {
            s_logger.error((Object)"not accurate logip", (Throwable)e);
            return "";
        }
    }

    private static int getTopLogId() {
        Integer iTopId = (Integer)BaseContextHelper.getArg(CONTEXT_INDEX_TOPID);
        if (iTopId == null) {
            return 0;
        }
        return iTopId;
    }

    private static ILog[] getLoggers() throws WCMException {
        if (m_arLoggerClazz == null) {
            LogServer.initLoggerClazz();
        }
        ILog[] arLoggers = new ILog[m_arLoggerClazz.length];
        for (int i = 0; i < arLoggers.length; ++i) {
            try {
                Class clz = m_arLoggerClazz[i];
                if (clz == null) continue;
                arLoggers[i] = (ILog)clz.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label1", "\u521b\u5efa\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25!"), e);
            }
        }
        return arLoggers;
    }

    private static void initLoggerClazz() throws WCMException {
        CMyBeanConfig[] configs = CMyBeanConfig.fromXMLFile(LOGGER_CONFIG_FILE);
        m_arLoggerClazz = new Class[configs.length];
        CMyBeanConfig config = null;
        for (int i = 0; i < configs.length; ++i) {
            config = configs[i];
            try {
                LogServer.m_arLoggerClazz[i] = Class.forName(config.getProperty("LoggerName"));
                continue;
            }
            catch (ClassNotFoundException e) {
                s_logger.error((Object)"load class failed!", (Throwable)e);
                throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label2", "\u6ca1\u6709\u627e\u5230\u76f8\u5339\u914d\u7684Logger[") + config.getName() + "]!", e);
            }
        }
    }

    public static boolean delete(ILog _currLog) throws WCMException {
        return _currLog.deleteLog();
    }

    public static boolean delete(int _nLogId) throws WCMException {
        LogServer.getLogMgr().delete(_nLogId);
        return true;
    }

    public static boolean delete(BaseObjs _currLogs) throws WCMException {
        if (_currLogs == null) {
            throw new WCMException(10, "args is null");
        }
        if (_currLogs instanceof Logs) {
            _currLogs.removeAll();
            return true;
        }
        return false;
    }

    public static boolean delete(String _sLogIds) throws WCMException {
        String[] arrayLogId = null;
        try {
            arrayLogId = CMyString.split(_sLogIds, ",");
        }
        catch (Exception e) {
            s_logger.error((Object)"spilt the logid sequence failed", (Throwable)e);
            throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label3", "\u89e3\u91ca\u65e5\u5fd7\u7684ID\u5e8f\u5217\u51fa\u9519!"), e);
        }
        for (int i = 0; i < arrayLogId.length; ++i) {
            LogServer.delete(arrayLogId[i]);
        }
        return true;
    }

    public static boolean delete(CMyDateTime _currDate) throws WCMException {
        String sDateTime = LogServer.formatDateTimeForSql(_currDate);
        WCMFilter aFilter = new WCMFilter("", "CrTime<" + sDateTime, "");
        LogServer.getLogMgr().delete(aFilter);
        return true;
    }

    public static boolean delete(CMyDateTime _startDate, CMyDateTime _endDate) throws WCMException {
        String sStartDateTime = LogServer.formatDateTimeForSql(_startDate);
        String sEndDateTime = LogServer.formatDateTimeForSql(_endDate);
        WCMFilter aFilter = new WCMFilter("", "CrTime>" + sStartDateTime + " AND CrTime<" + sEndDateTime, "");
        LogServer.getLogMgr().delete(aFilter);
        return true;
    }

    private static String formatDateTimeForSql(CMyDateTime _date) throws WCMException {
        if (_date == null || _date.isNull()) {
            throw new WCMException(10, I18NMessage.get(LogServer.class, "LogServer.label4", "\u6307\u5b9a\u7684\u65e5\u671f\u65e0\u6548!"));
        }
        DBManager dbMgr = DBManager.getDBManager();
        return dbMgr.getDBType().sqlDateTime(_date.toString(), "YYYY-MM-DD HH24:MI:SS");
    }

    public static boolean clearLogs() throws WCMException {
        return LogServer.getLogMgr().clearLogs();
    }

    public static BaseObjs getLogs(WCMFilter _filter) throws WCMException {
        return LogServer.getLogMgr().getLogs(_filter);
    }

    public static BaseObjs getLogs(int _nLogType, WCMFilter _filter) throws WCMException {
        return LogServer.getLogMgr().getLogs(_filter, _nLogType);
    }

    public static BaseObjs getLogsByTopId(int _nLogTopId, WCMFilter _filter) throws WCMException {
        return LogServer.getLogMgr().getLogsByTopId(_filter, _nLogTopId);
    }

    public static void archiveLogs(CMyDateTime _arciveDate) throws WCMException {
        String sDateTime = LogServer.formatDateTimeForSql(_arciveDate);
        WCMFilter aFilter = new WCMFilter("", "LogOpTime<" + sDateTime, "");
        BaseObjs logs = LogServer.getLogs(aFilter);
        if (logs.isEmpty()) {
            return;
        }
        LogServer.bakupLogs(logs);
        LogServer.delete(logs);
    }

    private static void bakupLogs(BaseObjs _logs) throws WCMException {
        LogServer.getLogMgr().bakupLogs(_logs);
    }

    public static String exportToXMLString(int _nLogId) throws WCMException {
        ILog log = LogServer.getLogMgr().find(_nLogId);
        return LogServer.exportToXMLString(log);
    }

    public static String exportToXMLString(ILog _currLog) throws WCMException {
        LogXmlConverter converter = new LogXmlConverter();
        return converter.toXMLString(_currLog);
    }

    public static String export(String _sLogIds) throws WCMException {
        BaseObjs logs = LogServer.getLogMgr().find(_sLogIds);
        return LogServer.export(logs);
    }

    public static String export(BaseObjs _currLogs) throws WCMException {
        if (_currLogs == null || _currLogs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(LogServer.class, "LogServer.label5", "\u65e0\u6548\u7684\u65e5\u5fd7\u96c6\u5408!"));
        }
        LogXmlConverter converter = new LogXmlConverter();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        converter.toXMLFile(_currLogs, sXmlFile);
        return CMyFile.extractFileName(sXmlFile);
    }

    public static BaseObjs getLogBaks(WCMFilter _currFilter) throws WCMException {
        return LogServer.getLogMgr().getLogBaks(_currFilter);
    }

    public static BaseObjs getLogBaks(int _nLogType, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "LogType=" + _nLogType, "");
        aFilter.mergeWith(_filter);
        return LogServer.getLogBaks(aFilter);
    }

    public static boolean deleteLogBaks(CMyDateTime _currDate) throws WCMException {
        String sDateTime = LogServer.formatDateTimeForSql(_currDate);
        WCMFilter aFilter = new WCMFilter("", "CrTime<" + sDateTime, "");
        BaseObjs logBaks = LogServer.getLogBaks(aFilter);
        logBaks.removeAll();
        return true;
    }

    public static boolean deleteLogBaks(CMyDateTime _startDate, CMyDateTime _endDate) throws WCMException {
        String sStartDateTime = LogServer.formatDateTimeForSql(_startDate);
        String sEndDateTime = LogServer.formatDateTimeForSql(_endDate);
        WCMFilter aFilter = new WCMFilter("", "CrTime<" + sEndDateTime + " AND CrTime>" + sStartDateTime, "");
        BaseObjs logBaks = LogServer.getLogBaks(aFilter);
        logBaks.removeAll();
        return true;
    }

    public static boolean clearLogBaks() throws WCMException {
        return LogServer.getLogMgr().clearLogBaks();
    }

    public static String getLogTypeName(String _sLogTypeConst) throws WCMException {
        throw new WCMException(1100, I18NMessage.get(LogServer.class, "LogServer.label6", "\u5c1a\u672a\u5b9e\u73b0\u5177\u4f53\u7684\u65b9\u6cd5\u83b7\u53d6\u64cd\u4f5c\u7c7b\u578b:") + _sLogTypeConst);
    }

    private static Map initOperTypeMap() throws WCMException {
        if (m_operTypeMap == null) {
            OperTypes types = OperTypes.openWCMObjs(null);
            m_operTypeMap = new HashMap(types.size());
            OperType type = null;
            for (int i = 0; i < types.size(); ++i) {
                type = (OperType)types.getAt(i);
                m_operTypeMap.put(type.getName().toUpperCase(), type);
            }
        }
        return m_operTypeMap;
    }

    private static ILogMgr getLogMgr() {
        return (ILogMgr)DreamFactory.createObjectById("ILogMgr");
    }

    public static LogType[] getLogTypes() {
        return ALL_LOG_TYPE;
    }

    public static long startRecord(String _sUserName, String _sOperType, String _sLogDesc, BaseObj _baseObj, int _nLogType) {
        int nTopId = LogServer.getTopLogId();
        long lStartTime = System.currentTimeMillis();
        long lStartId = 0L;
        try {
            lStartId = LogServer.save(_sUserName, _sOperType, _sLogDesc, _nLogType, _baseObj, nTopId, LogServer.getLogIP(), lStartTime);
        }
        catch (Exception e) {
            s_logger.error((Object)"failed to record a log", (Throwable)e);
        }
        return lStartId;
    }

    public static long startRecord(String _sUserName, String _sOperType, String _sLogDesc, BaseObj _baseObj) {
        return LogServer.startRecord(_sUserName, _sOperType, _sLogDesc, _baseObj, 3);
    }

    public static void endRecordSucceedOperation(long _lStartId) {
        try {
            LogServer.updateLog(_lStartId, 1, 3, null);
        }
        catch (Exception e) {
            s_logger.error((Object)"failed to update a log", (Throwable)e);
        }
    }

    public static void endRecordSucceedOperation(long _lStartId, int _nLogObjId) {
        try {
            if (_lStartId < 0L) {
                return;
            }
            ILog[] arLog = LogServer.getLoggers();
            long lEndTime = System.currentTimeMillis();
            ILog log = null;
            for (int i = 0; i < arLog.length; ++i) {
                log = arLog[i];
                log.loadByStartId(_lStartId);
                log.setEndTimeMillis(lEndTime);
                log.setExecTime(lEndTime - log.getStartTimeMillis());
                log.setResult(1);
                log.setLogType(3);
                log.setObjId(_nLogObjId);
                if (log.getTopLogId() == 0) {
                    BaseContextHelper.setArg(CONTEXT_INDEX_TOPID, null);
                }
                log.saveLog();
            }
        }
        catch (Exception e) {
            s_logger.error((Object)"failed to update a log", (Throwable)e);
        }
    }

    public static void endRecordFailedOperation(long _lStartId, Throwable _throwable) {
        try {
            LogServer.updateLog(_lStartId, 0, 1, _throwable);
        }
        catch (Exception e) {
            s_logger.error((Object)"failed to update a log", (Throwable)e);
        }
    }

    private static void updateLog(long _lStartId, int _nResult, int _nLogTypeId, Throwable _throwable) throws WCMException {
        ILog[] arLog = LogServer.getLoggers();
        long lEndTime = System.currentTimeMillis();
        for (int i = 0; i < arLog.length; ++i) {
            if (_lStartId <= 0L) continue;
            arLog[i].loadByStartId(_lStartId);
            arLog[i].setEndTimeMillis(lEndTime);
            long lStartTime = arLog[i].getStartTimeMillis();
            arLog[i].setExecTime(lEndTime - lStartTime);
            arLog[i].setResult(_nResult);
            arLog[i].setLogType(_nLogTypeId);
            if (arLog[i].getTopLogId() == 0) {
                BaseContextHelper.setArg(CONTEXT_INDEX_TOPID, null);
            }
            if (_throwable != null) {
                String sDesc = arLog[i].getDesc();
                if ((sDesc = sDesc + "\n" + CMyException.getStackTraceText(_throwable)).getBytes().length > 3000) {
                    sDesc = sDesc.substring(0, 1500);
                }
                arLog[i].setDesc(sDesc);
            }
            arLog[i].saveLog();
        }
    }

    public static final boolean isRecordNeeded(BaseObj _currObj) {
        if (_currObj == null) {
            return false;
        }
        if (m_logObjConf == null || m_logObjConf.isEmpty()) {
            m_logObjConf = new Properties();
            try {
                InputStream fis = new FileService(CMyFile.mapResouceFullPath(LOGOBJS_CONFIG)).getInputStream();
                m_logObjConf.load(fis);
            }
            catch (Exception e) {
                e.printStackTrace();
                s_logger.error((Object)"fatal:get the objects that need to record log config failed!", (Throwable)e);
                return true;
            }
        }
        return m_logObjConf.containsValue(_currObj.getClassName(true));
    }

    public static boolean existsLogType(String _sLogType) {
        try {
            return LogServer.initOperTypeMap().containsKey(_sLogType.toUpperCase());
        }
        catch (WCMException e) {
            return false;
        }
    }

    public static void cachedLogtype(OperType _type) {
        if (_type == null) {
            return;
        }
        try {
            LogServer.initOperTypeMap().put(_type.getName().toUpperCase(), _type);
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
    }
}

