/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaViewFieldGroupMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFieldGroups;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class WCMTagParserViewFieldGroups
extends BaseTagParser4List {
    private MetaView m_oCurrView = null;
    private MetaViewFieldGroup m_oViewFieldGroup = null;
    private IMetaViewFieldGroupMgr m_oFieldGroupMgr = (IMetaViewFieldGroupMgr)DreamFactory.createObjectById("IMetaViewFieldGroupMgr");

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        this.makeCurrView(_context);
        int nParentId = 0;
        if (this.m_oViewFieldGroup == null) {
            String sParentName = _context.getAttributeTrim("ParentName");
            if (sParentName != null && sParentName.length() > 0) {
                MetaViewFieldGroup group = this.m_oFieldGroupMgr.findGroup(this.m_oCurrView, sParentName);
                if (group != null) {
                    nParentId = group.getId();
                }
            } else {
                nParentId = _context.getAttribute("ParentId", 0);
            }
        } else {
            nParentId = this.m_oViewFieldGroup.getId();
        }
        WCMFilter filter = new WCMFilter("", "ParentId=?", "");
        filter.addSearchValues(nParentId);
        MetaViewFieldGroups fieldGroups = this.m_oFieldGroupMgr.queryGroupsForView(null, this.m_oCurrView, filter);
        boolean bHideEmptyGroup = _context.getAttribute("HIDEEMPTYGROUP", false);
        if (bHideEmptyGroup && fieldGroups != null && !fieldGroups.isEmpty()) {
            for (int i = fieldGroups.size() - 1; i >= 0; --i) {
                MetaViewFieldGroup group = (MetaViewFieldGroup)fieldGroups.getAt(i);
                if (!this.hideTheGroup(group)) continue;
                fieldGroups.remove(group, false);
            }
        }
        return fieldGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hideTheGroup(MetaViewFieldGroup group) {
        if (group == null) {
            return true;
        }
        String sql = "select count(VIEWFIELDINFOID) from XWCMVIEWFIELDINFO where VIEWID=? and (FIELDGROUPID=? or FIELDGROUPID in( select METAVIEWFIELDGROUPID from XWCMMETAVIEWFIELDGROUP where PARENTID = ?))";
        DBManager dbman = DBManager.getDBManager();
        boolean hidden = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, group.getMetaViewId());
            pstmt.setInt(2, group.getId());
            pstmt.setInt(3, group.getId());
            rs = pstmt.executeQuery();
            hidden = rs.next() && rs.getInt(1) == 0;
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbman.freeConnection(conn);
            }
        }
        return hidden;
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        this.makeCurrView(_context);
        return true;
    }

    private void makeCurrView(PublishTagContext _context) throws WCMException {
        if (this.m_oCurrView != null) {
            return;
        }
        int nViewId = _context.getAttribute("ViewId", 0);
        if (nViewId > 0) {
            this.m_oCurrView = MetaView.findById(nViewId);
            if (this.m_oCurrView == null) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewFieldGroups.class, "WCMTagParserViewFieldGroups.label1", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01Id=") + nViewId);
            }
            return;
        }
        IPublishElement upperHost = _context.getUpperHost();
        CMSObj subinstance = upperHost.getSubstance();
        if (subinstance instanceof Channel) {
            IMetaViewEmployerMgr employerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
            this.m_oCurrView = employerMgr.getViewOfEmployer((Channel)subinstance);
            if (this.m_oCurrView == null) {
                throw new WCMException(CMyString.format(I18NMessage.get(WCMTagParserViewFieldGroups.class, "WCMTagParserViewFieldGroups.label2", "\u5f53\u524d\u53d1\u5e03\u680f\u76ee[{0}]\u4e0a\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe"), new Object[]{subinstance}));
            }
            return;
        }
        if (subinstance instanceof MetaView) {
            this.m_oCurrView = (MetaView)subinstance;
            return;
        }
        if (subinstance instanceof MetaViewFieldGroup) {
            this.m_oViewFieldGroup = (MetaViewFieldGroup)subinstance;
            int nMetaViewId = this.m_oViewFieldGroup.getMetaViewId();
            this.m_oCurrView = MetaView.findById(nMetaViewId);
        } else {
            if (subinstance instanceof MetaViewData) {
                this.m_oCurrView = ((MetaViewData)subinstance).getMetaView();
                return;
            }
            if (subinstance instanceof Document) {
                this.m_oCurrView = MetaView.findById(((Document)subinstance).getPropertyAsInt("DocKind", 0));
                return;
            }
        }
    }
}

