/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.gkml.sqgk.process.engine.handlers;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.gkml.sqgk.persistent.ApplyForm;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMySMTPServer;
import com.trs.infra.util.email.TRSMailer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReplyNotifyHandler
implements IActionHandler {
    private Map m_hVarValues = null;
    private static Logger logger = Logger.getLogger(ReplyNotifyHandler.class);
    private static ConfigServer m_oConfigServer = null;

    public static String getNotifyRootPath() throws WCMException {
        String sNotifyRootPath = ReplyNotifyHandler.getConfigServer().getSysConfigValue("APPLYFORM_NOTIFY_PATH", "");
        if (CMyString.isEmpty(sNotifyRootPath)) {
            throw new WCMException("\u7cfb\u7edf\u4e2d\u672a\u6b63\u786e\u8bbe\u7f6e\u4f9d\u7533\u8bf7\u516c\u5f00\u5de5\u4f5c\u6d41\u8f6c\u4e2d\u901a\u77e5\u4e66\u5b58\u50a8\u7684\u6839\u8def\u5f84\u3002\u8bf7\u5728\u7cfb\u7edf\u914d\u7f6e\u4e2d\u589e\u52a0APPLYFORM_NOTIFY_PATH\u7684\u914d\u7f6e\u9879\u3002");
        }
        return CMyString.setStrEndWith(sNotifyRootPath.replace('\\', '/'), '/').replace('/', File.separatorChar);
    }

    private static ConfigServer getConfigServer() {
        if (m_oConfigServer == null) {
            m_oConfigServer = ConfigServer.getServer();
        }
        return m_oConfigServer;
    }

    @Override
    public boolean execute(ExecuteContext _context, FlowAction _action) throws WCMException {
        String sReceiverEmail;
        ActionParametersAnalyser parameters = new ActionParametersAnalyser(_action.getParams());
        String sReceiver = parameters.getParameterValue("Receiver");
        if (sReceiver == null || (sReceiver = sReceiver.trim()).length() == 0) {
            return true;
        }
        IFlowContent flowContent = null;
        BaseObj applyForm = null;
        if (_context != null && (flowContent = _context.getFlowContent()) != null) {
            CMSObj oCMSObj = flowContent.getSubinstance();
            if (!(oCMSObj instanceof ApplyForm)) {
                return true;
            }
            applyForm = (ApplyForm)oCMSObj;
        }
        if (CMyString.isEmpty(sReceiverEmail = applyForm.getPropertyAsString(sReceiver))) {
            sReceiverEmail = sReceiver;
        }
        if (sReceiverEmail.indexOf("@") == -1) {
            return true;
        }
        this.m_hVarValues = new HashMap(5);
        this.m_hVarValues.put("CONTENTTITLE".toUpperCase(), _context.getFlowContent().getDesc());
        this.m_hVarValues.put("CurrDateTime".toUpperCase(), CMyDateTime.now().toString());
        this.m_hVarValues.put("SenderName".toUpperCase(), _context.getPostUser().getName());
        String sNotifyFile = parameters.getParameterValue("NotifyFile");
        String sMsgTitle = this.doPageVariablesParse(parameters.getParameterValue("MsgTitle"), _context);
        String sMsgBody = this.doPageVariablesParse(parameters.getParameterValue("MsgTemplate"), _context);
        ReplyNotifyHandler.sendEmail(sReceiverEmail, sMsgTitle, sMsgBody, sNotifyFile);
        return true;
    }

    private static void sendEmail(String _sEmailAddr, String _sEmailTitle, String _sEmailBody, String sNotifyFile) throws WCMException {
        TRSMailer currMailer;
        if (CMyString.isEmpty(_sEmailAddr)) {
            logger.error((Object)"\u90ae\u4ef6\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        CMyEmail myEmail = new CMyEmail();
        User loginUser = ReplyNotifyHandler.getLoginUser();
        myEmail.setFrom(CMyString.showNull(loginUser.getEmail(), CMyString.showNull(loginUser.getNickName(), loginUser.getName())));
        myEmail.setTo(_sEmailAddr);
        myEmail.setSubject(_sEmailTitle);
        myEmail.setMailFormat(1);
        String sHtmlEmailBody = _sEmailBody.replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
        myEmail.setBody(sHtmlEmailBody);
        if (!CMyString.isEmpty(sNotifyFile)) {
            String sTrueFile = ReplyNotifyHandler.getAppendixFile(sNotifyFile);
            myEmail.setAttachedFile(sTrueFile);
        }
        if (!(currMailer = new TRSMailer()).send(myEmail, CMySMTPServer.getDefaultSMTPServer())) {
            throw new WCMException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!" + currMailer.getMailLogString());
        }
    }

    private static String getAppendixFile(String notifyFile) throws WCMException {
        return ReplyNotifyHandler.getNotifyRootPath() + notifyFile;
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String doPageVariablesParse(String _sContent, ExecuteContext _context) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        try {
            char[] chrArray = _sContent.toCharArray();
            int nLength = chrArray.length;
            int nPos = 0;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '{') {
                    StringBuffer buffVarName = new StringBuffer(16);
                    ++nPos;
                    int iCount = 0;
                    boolean zFound = false;
                    while (iCount++ < 20 && nPos < nLength) {
                        if ((aChar = chrArray[nPos++]) == '}') {
                            zFound = true;
                            break;
                        }
                        buffVarName.append(aChar);
                    }
                    Map hVarValues = this.getVarValues();
                    if (zFound) {
                        String sKey = buffVarName.toString().toUpperCase();
                        String sVal = (String)hVarValues.get(sKey);
                        if (sVal == null) {
                            sVal = this.getSubstanceProperty(sKey, _context);
                            hVarValues.put(sKey, sVal);
                        }
                        if (sVal != null) {
                            buffResult.append(sVal);
                            continue;
                        }
                        buffResult.append("${").append(buffVarName).append('}');
                        continue;
                    }
                    buffResult.append("${").append(buffVarName);
                    continue;
                }
                buffResult.append(aChar);
            }
            return buffResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(1100, "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!", ex);
        }
    }

    public Map getVarValues() {
        if (this.m_hVarValues == null) {
            this.m_hVarValues = new HashMap(5);
        }
        return this.m_hVarValues;
    }

    private String getSubstanceProperty(String _sKey, ExecuteContext _context) throws WCMException {
        if (CMyString.isEmpty(_sKey)) {
            return null;
        }
        CMSObj content = _context.getFlowContent().getSubstance();
        return content.getPropertyAsString(_sKey);
    }
}

